/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.invocation;

import javax.annotation.Nullable;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildController;

public interface BuildActionRunner {
    public Result run(BuildAction var1, BuildController var2);

    public static class Result {
        private final boolean hasResult;
        private final Object result;
        private final Throwable buildFailure;
        private final Throwable clientFailure;
        private static final Result NOTHING = new Result(false, null, null, null);
        private static final Result NULL = new Result(true, null, null, null);

        private Result(boolean hasResult, Object result, Throwable buildFailure, Throwable clientFailure) {
            this.hasResult = hasResult;
            this.result = result;
            this.buildFailure = buildFailure;
            this.clientFailure = clientFailure;
        }

        public static Result nothing() {
            return NOTHING;
        }

        public static Result of(@Nullable Object result) {
            if (result == null) {
                return NULL;
            }
            return new Result(true, result, null, null);
        }

        public static Result failed(Throwable buildFailure) {
            return new Result(true, null, buildFailure, buildFailure);
        }

        public static Result failed(Throwable buildFailure, RuntimeException clientFailure) {
            return new Result(true, null, buildFailure, clientFailure);
        }

        public boolean hasResult() {
            return this.hasResult;
        }

        @Nullable
        public Object getClientResult() {
            return this.result;
        }

        @Nullable
        public Throwable getBuildFailure() {
            return this.buildFailure;
        }

        @Nullable
        public Throwable getClientFailure() {
            return this.clientFailure;
        }
    }
}

