/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.deployer;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.maven.MavenDeployment;
import org.gradle.api.artifacts.maven.MavenPom;
import org.gradle.api.artifacts.maven.MavenResolver;
import org.gradle.api.artifacts.maven.PomFilterContainer;
import org.gradle.api.artifacts.maven.PublishFilter;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.IvyUtil;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.internal.artifacts.mvnsettings.MavenSettingsProvider;
import org.gradle.api.internal.artifacts.repositories.AbstractArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publication.maven.internal.ArtifactPomContainer;
import org.gradle.api.publication.maven.internal.PomFilter;
import org.gradle.api.publication.maven.internal.action.MavenPublishAction;
import org.gradle.api.publish.maven.internal.publication.ReadableMavenProjectIdentity;
import org.gradle.api.publish.maven.internal.publisher.MavenProjectIdentity;
import org.gradle.internal.MutableActionSet;
import org.gradle.internal.component.external.ivypublish.IvyModuleArtifactPublishMetadata;
import org.gradle.internal.component.external.ivypublish.IvyModulePublishMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.util.ConfigureUtil;

abstract class AbstractMavenResolver
extends AbstractArtifactRepository
implements MavenResolver,
ModuleVersionPublisher,
ResolutionAwareRepository,
PublicationAwareRepository {
    private ArtifactPomContainer artifactPomContainer;
    private PomFilterContainer pomFilterContainer;
    private LoggingManagerInternal loggingManager;
    private final MutableActionSet<MavenDeployment> beforeDeploymentActions = new MutableActionSet();
    private final MavenSettingsProvider mavenSettingsProvider;
    private final LocalMavenRepositoryLocator mavenRepositoryLocator;

    public AbstractMavenResolver(PomFilterContainer pomFilterContainer, ArtifactPomContainer artifactPomContainer, LoggingManagerInternal loggingManager, MavenSettingsProvider mavenSettingsProvider, LocalMavenRepositoryLocator mavenRepositoryLocator, ObjectFactory objectFactory) {
        super(objectFactory);
        this.pomFilterContainer = pomFilterContainer;
        this.artifactPomContainer = artifactPomContainer;
        this.loggingManager = loggingManager;
        this.mavenSettingsProvider = mavenSettingsProvider;
        this.mavenRepositoryLocator = mavenRepositoryLocator;
    }

    public ConfiguredModuleComponentRepository createResolver() {
        throw new UnsupportedOperationException("A Maven deployer cannot be used to resolve dependencies. It can only be used to publish artifacts.");
    }

    public RepositoryDescriptor getDescriptor() {
        throw new UnsupportedOperationException("A Maven deployer cannot be used to resolve dependencies, and don't have repository details available.");
    }

    public ModuleVersionPublisher createPublisher() {
        return this;
    }

    protected abstract MavenPublishAction createPublishAction(String var1, MavenProjectIdentity var2, LocalMavenRepositoryLocator var3);

    public void publish(IvyModulePublishMetadata moduleVersion) {
        for (IvyModuleArtifactPublishMetadata artifactMetadata : moduleVersion.getArtifacts()) {
            IvyArtifactName artifact = artifactMetadata.getArtifactName();
            ModuleRevisionId moduleRevisionId = IvyUtil.createModuleRevisionId((ModuleComponentIdentifier)artifactMetadata.getId().getComponentIdentifier());
            Map<String, String> attributes = Collections.singletonMap("classifier", artifact.getClassifier());
            DefaultArtifact ivyArtifact = new DefaultArtifact(moduleRevisionId, null, artifact.getName(), artifact.getType(), artifact.getExtension(), attributes);
            this.collectArtifact((Artifact)ivyArtifact, artifactMetadata.getFile());
        }
        this.publish();
    }

    private void collectArtifact(Artifact artifact, File src) {
        if (this.isIgnorable(artifact)) {
            return;
        }
        this.getArtifactPomContainer().addArtifact(artifact, src);
    }

    private boolean isIgnorable(Artifact artifact) {
        return artifact.getType().equals("ivy");
    }

    private void publish() {
        Set<MavenDeployment> mavenDeployments = this.getArtifactPomContainer().createDeployableFilesInfos();
        for (MavenDeployment mavenDeployment : mavenDeployments) {
            ReadableMavenProjectIdentity projectIdentity = new ReadableMavenProjectIdentity(mavenDeployment.getGroupId(), mavenDeployment.getArtifactId(), mavenDeployment.getVersion());
            MavenPublishAction publishAction = this.createPublishAction(mavenDeployment.getPackaging(), projectIdentity, this.mavenRepositoryLocator);
            this.beforeDeploymentActions.execute((Object)mavenDeployment);
            this.addArtifacts(publishAction, mavenDeployment);
            this.execute(publishAction);
        }
    }

    private void execute(MavenPublishAction publishAction) {
        this.loggingManager.captureStandardOutput(LogLevel.INFO).start();
        try {
            publishAction.publish();
        }
        finally {
            this.loggingManager.stop();
        }
    }

    private void addArtifacts(MavenPublishAction publishAction, MavenDeployment mavenDeployment) {
        publishAction.setPomArtifact(mavenDeployment.getPomArtifact().getFile());
        if (mavenDeployment.getMainArtifact() != null) {
            publishAction.setMainArtifact(mavenDeployment.getMainArtifact().getFile());
        }
        for (PublishArtifact classifierArtifact : mavenDeployment.getAttachedArtifacts()) {
            publishAction.addAdditionalArtifact(classifierArtifact.getFile(), classifierArtifact.getType(), classifierArtifact.getClassifier());
        }
    }

    public ArtifactPomContainer getArtifactPomContainer() {
        return this.artifactPomContainer;
    }

    @Override
    public Object getSettings() {
        try {
            return this.mavenSettingsProvider.buildSettings();
        }
        catch (SettingsBuildingException e) {
            throw new GradleException("Could not load Maven Settings", (Throwable)e);
        }
    }

    @Override
    public PublishFilter getFilter() {
        return this.pomFilterContainer.getFilter();
    }

    @Override
    public void setFilter(PublishFilter defaultFilter) {
        this.pomFilterContainer.setFilter(defaultFilter);
    }

    @Override
    public MavenPom getPom() {
        return this.pomFilterContainer.getPom();
    }

    @Override
    public void setPom(MavenPom defaultPom) {
        this.pomFilterContainer.setPom(defaultPom);
    }

    @Override
    public MavenPom addFilter(String name, PublishFilter publishFilter) {
        return this.pomFilterContainer.addFilter(name, publishFilter);
    }

    @Override
    public MavenPom addFilter(String name, Closure filter) {
        return this.pomFilterContainer.addFilter(name, filter);
    }

    @Override
    public void filter(Closure filter) {
        this.pomFilterContainer.filter(filter);
    }

    @Override
    public PublishFilter filter(String name) {
        return this.pomFilterContainer.filter(name);
    }

    @Override
    public MavenPom pom(String name) {
        return this.pomFilterContainer.pom(name);
    }

    @Override
    public MavenPom pom(Closure configureClosure) {
        return this.pomFilterContainer.pom(configureClosure);
    }

    @Override
    public MavenPom pom(String name, Closure configureClosure) {
        return this.pomFilterContainer.pom(name, configureClosure);
    }

    @Override
    public MavenPom pom(Action<? super MavenPom> configureAction) {
        return this.pomFilterContainer.pom(configureAction);
    }

    @Override
    public MavenPom pom(String name, Action<? super MavenPom> configureAction) {
        return this.pomFilterContainer.pom(name, configureAction);
    }

    @Override
    public Iterable<PomFilter> getActivePomFilters() {
        return this.pomFilterContainer.getActivePomFilters();
    }

    public PomFilterContainer getPomFilterContainer() {
        return this.pomFilterContainer;
    }

    @Override
    public void beforeDeployment(Action<? super MavenDeployment> action) {
        this.beforeDeploymentActions.add(action);
    }

    @Override
    public void beforeDeployment(Closure action) {
        this.beforeDeploymentActions.add(ConfigureUtil.configureUsing((Closure)action));
    }
}

