/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import org.gradle.BuildListener;
import org.gradle.StartParameter;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.RunNestedBuildBuildOperationType;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.NestedRootBuild;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.invocation.GradleBuildController;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.util.Path;

public class RootOfNestedBuildTree
extends AbstractBuildState
implements NestedRootBuild {
    private final BuildIdentifier buildIdentifier;
    private final Path identityPath;
    private final BuildState owner;
    private final GradleLauncher gradleLauncher;
    private String buildName;

    public RootOfNestedBuildTree(BuildDefinition buildDefinition, BuildIdentifier buildIdentifier, Path identityPath, BuildState owner) {
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.owner = owner;
        this.buildName = buildDefinition.getName() == null ? buildIdentifier.getName() : buildDefinition.getName();
        this.gradleLauncher = owner.getNestedBuildFactory().nestedBuildTree(buildDefinition, (NestedRootBuild)this);
    }

    public StartParameter getStartParameter() {
        return this.gradleLauncher.getGradle().getStartParameter();
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public Path getIdentityPath() {
        return this.identityPath;
    }

    public boolean isImplicitBuild() {
        return false;
    }

    public SettingsInternal getLoadedSettings() {
        return this.gradleLauncher.getGradle().getSettings();
    }

    public NestedBuildFactory getNestedBuildFactory() {
        return (NestedBuildFactory)this.gradleLauncher.getGradle().getServices().get(NestedBuildFactory.class);
    }

    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return this.owner.getCurrentPrefixForProjectsInChildBuilds().child(this.buildName);
    }

    public Path getIdentityPathForProject(Path projectPath) {
        return this.gradleLauncher.getGradle().getIdentityPath().append(projectPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(final Transformer<T, ? super BuildController> buildAction) {
        GradleBuildController buildController = new GradleBuildController(this.gradleLauncher);
        try {
            final GradleInternal gradle = this.gradleLauncher.getGradle();
            BuildOperationExecutor executor = (BuildOperationExecutor)gradle.getServices().get(BuildOperationExecutor.class);
            Object object = executor.call(new CallableBuildOperation<T>((BuildController)buildController){
                final /* synthetic */ BuildController val$buildController;
                {
                    this.val$buildController = buildController;
                }

                public T call(BuildOperationContext context) {
                    gradle.addBuildListener((BuildListener)new InternalBuildAdapter(){

                        public void settingsEvaluated(Settings settings) {
                            RootOfNestedBuildTree.this.buildName = settings.getRootProject().getName();
                        }
                    });
                    Object result = buildAction.transform((Object)this.val$buildController);
                    context.setResult((Object)new RunNestedBuildBuildOperationType.Result(){});
                    return result;
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)"Run nested build").details((Object)new RunNestedBuildBuildOperationType.Details(){

                        public String getBuildPath() {
                            return gradle.getIdentityPath().getPath();
                        }
                    });
                }
            });
            return (T)object;
        }
        finally {
            buildController.stop();
        }
    }
}

