/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.jedit.input.AbstractInputHandler;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.Log;

public class GrabKeyDialog
extends JDialog {
    private InputPane shortcut;
    private JLabel assignedTo;
    private JButton ok;
    private JButton remove;
    private JButton cancel;
    private JButton clear;
    private boolean isOK;
    private KeyBinding binding;
    private List<KeyBinding> allBindings;
    private Buffer debugBuffer;

    public GrabKeyDialog(Dialog dialog, KeyBinding keyBinding, List<KeyBinding> list, Buffer buffer) {
        super(dialog, jEdit.getProperty("grab-key.title"), true);
        this.init(keyBinding, list, buffer);
    }

    public GrabKeyDialog(Frame frame, KeyBinding keyBinding, List<KeyBinding> list, Buffer buffer) {
        super(frame, jEdit.getProperty("grab-key.title"), true);
        this.init(keyBinding, list, buffer);
    }

    public String getShortcut() {
        if (this.isOK) {
            return this.shortcut.getShortcut();
        }
        return null;
    }

    public boolean isOK() {
        return this.isOK;
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        this.shortcut.processKeyEvent(keyEvent);
    }

    private void init(KeyBinding keyBinding, List<KeyBinding> list, Buffer buffer) {
        this.binding = keyBinding;
        this.allBindings = list;
        this.debugBuffer = buffer;
        this.enableEvents(8L);
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 6)){

            @Override
            public boolean getFocusTraversalKeysEnabled() {
                return false;
            }
        };
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        JLabel jLabel = new JLabel(buffer == null ? jEdit.getProperty("grab-key.caption", new String[]{keyBinding.label}) : jEdit.getProperty("grab-key.keyboard-test"));
        Box box = Box.createHorizontalBox();
        this.shortcut = new InputPane();
        Dimension dimension = this.shortcut.getPreferredSize();
        dimension.width = Integer.MAX_VALUE;
        this.shortcut.setMaximumSize(dimension);
        box.add(this.shortcut);
        box.add(Box.createHorizontalStrut(12));
        this.clear = new JButton(jEdit.getProperty("grab-key.clear"));
        this.clear.addActionListener(new ActionHandler());
        box.add(this.clear);
        this.assignedTo = new JLabel();
        if (buffer == null) {
            this.updateAssignedTo(null);
        }
        Box box2 = Box.createHorizontalBox();
        box2.setBorder(BorderFactory.createEmptyBorder(17, 0, 0, 0));
        box2.add(Box.createGlue());
        if (buffer == null) {
            this.ok = new JButton(jEdit.getProperty("common.ok"));
            this.ok.addActionListener(new ActionHandler());
            box2.add(this.ok);
            box2.add(Box.createHorizontalStrut(6));
            if (keyBinding.isAssigned()) {
                this.remove = new JButton(jEdit.getProperty("grab-key.remove"));
                this.remove.addActionListener(new ActionHandler());
                box2.add(this.remove);
                box2.add(Box.createHorizontalStrut(6));
            }
        }
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        box2.add(this.cancel);
        GenericGUIUtilities.makeSameSize(this.ok, this.cancel);
        jPanel.add(jLabel);
        jPanel.add(box);
        if (buffer == null) {
            jPanel.add(this.assignedTo);
        }
        jPanel.add(box2);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this.setVisible(true);
    }

    public static String getSymbolicName(int n) {
        if (Debug.DUMP_KEY_EVENTS) {
            Log.log(1, GrabKeyDialog.class, "getSymbolicName(" + n + ").");
        }
        if (n == 0) {
            return null;
        }
        if (n >= 65 && n <= 90) {
            return String.valueOf(Character.toLowerCase((char)n));
        }
        try {
            Field[] fieldArray;
            for (Field field : fieldArray = KeyEvent.class.getFields()) {
                String string = field.getName();
                if (!string.startsWith("VK_") || field.getInt(null) != n) continue;
                return string.substring(3);
            }
        }
        catch (Exception exception) {
            Log.log(9, GrabKeyDialog.class, exception);
        }
        return null;
    }

    private void updateAssignedTo(String string) {
        String string2 = jEdit.getProperty("grab-key.assigned-to.none");
        KeyBinding keyBinding = this.getKeyBinding(string);
        if (keyBinding != null) {
            string2 = keyBinding.isPrefix ? jEdit.getProperty("grab-key.assigned-to.prefix", new String[]{string}) : keyBinding.label;
        }
        if (this.ok != null) {
            this.ok.setEnabled(keyBinding == null || !keyBinding.isPrefix);
        }
        this.assignedTo.setText(jEdit.getProperty("grab-key.assigned-to", new String[]{string2}));
    }

    private KeyBinding getKeyBinding(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = string + ' ';
        for (KeyBinding keyBinding : this.allBindings) {
            if (!keyBinding.isAssigned()) continue;
            String string3 = keyBinding.shortcut + ' ';
            if (string2.startsWith(string3)) {
                return keyBinding;
            }
            if (!string3.startsWith(string2)) continue;
            return new KeyBinding(keyBinding.name, keyBinding.label, keyBinding.tooltip, string, true);
        }
        return null;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GrabKeyDialog.this.ok) {
                if (this.canClose()) {
                    GrabKeyDialog.this.dispose();
                }
            } else if (actionEvent.getSource() == GrabKeyDialog.this.remove) {
                GrabKeyDialog.this.shortcut.setText(null);
                GrabKeyDialog.this.isOK = true;
                GrabKeyDialog.this.dispose();
            } else if (actionEvent.getSource() == GrabKeyDialog.this.cancel) {
                GrabKeyDialog.this.dispose();
            } else if (actionEvent.getSource() == GrabKeyDialog.this.clear) {
                GrabKeyDialog.this.shortcut.setText(null);
                if (GrabKeyDialog.this.debugBuffer == null) {
                    GrabKeyDialog.this.updateAssignedTo(null);
                }
                GrabKeyDialog.this.shortcut.requestFocus();
            }
        }

        private boolean canClose() {
            KeyBinding keyBinding;
            String string = GrabKeyDialog.this.shortcut.getShortcut();
            if (string.length() == 0 && GrabKeyDialog.this.binding.isAssigned()) {
                int n = GUIUtilities.confirm(GrabKeyDialog.this, "grab-key.remove-ask", null, 0, 3);
                if (n == 0) {
                    GrabKeyDialog.this.shortcut.setText(null);
                    GrabKeyDialog.this.isOK = true;
                } else {
                    return false;
                }
            }
            if ((keyBinding = GrabKeyDialog.this.getKeyBinding(string)) == null || keyBinding == GrabKeyDialog.this.binding) {
                GrabKeyDialog.this.isOK = true;
                return true;
            }
            if (keyBinding.name == ((GrabKeyDialog)GrabKeyDialog.this).binding.name) {
                GUIUtilities.error(GrabKeyDialog.this, "grab-key.duplicate-alt-shortcut", null);
                return false;
            }
            if (keyBinding.isPrefix) {
                GUIUtilities.error(GrabKeyDialog.this, "grab-key.prefix-shortcut", null);
                return false;
            }
            int n = GUIUtilities.confirm(GrabKeyDialog.this, "grab-key.duplicate-shortcut", new Object[]{keyBinding.label}, 0, 3);
            if (n == 0) {
                if (keyBinding.shortcut != null && string.startsWith(keyBinding.shortcut)) {
                    keyBinding.shortcut = null;
                }
                GrabKeyDialog.this.isOK = true;
                return true;
            }
            return false;
        }
    }

    private class InputPane
    extends JTextField {
        protected String rawShortcut = "";

        private InputPane() {
        }

        @Override
        public boolean getFocusTraversalKeysEnabled() {
            return false;
        }

        @Override
        public void setText(String string) {
            this.rawShortcut = string == null ? "" : string;
            super.setText(GUIUtilities.getPlatformShortcutLabel(string));
        }

        public String getShortcut() {
            return this.rawShortcut;
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            String string;
            KeyEvent keyEvent2 = KeyEventWorkaround.processKeyEvent(keyEvent);
            if (!KeyEventWorkaround.isBindable(keyEvent.getKeyCode())) {
                keyEvent2 = null;
            }
            if (GrabKeyDialog.this.debugBuffer != null) {
                GrabKeyDialog.this.debugBuffer.insert(GrabKeyDialog.this.debugBuffer.getLength(), "Event " + AbstractInputHandler.toString(keyEvent) + (keyEvent2 == null ? " filtered\n" : " passed\n"));
            }
            if (keyEvent2 == null) {
                return;
            }
            keyEvent2.consume();
            KeyEventTranslator.Key key = KeyEventTranslator.translateKeyEvent(keyEvent2);
            if (Debug.DUMP_KEY_EVENTS) {
                Log.log(1, GrabKeyDialog.class, "processKeyEvent() key=" + key + ", _evt=" + keyEvent + '.');
            }
            if (key == null) {
                return;
            }
            if (GrabKeyDialog.this.debugBuffer != null) {
                GrabKeyDialog.this.debugBuffer.insert(GrabKeyDialog.this.debugBuffer.getLength(), "==> Translated to " + key + '\n');
            }
            StringBuilder stringBuilder = new StringBuilder(this.getShortcut());
            if (this.getDocument().getLength() != 0) {
                stringBuilder.append(' ');
            }
            if (key.modifiers != null) {
                stringBuilder.append(key.modifiers).append('+');
            }
            if ((string = GrabKeyDialog.getSymbolicName(key.key)) != null) {
                stringBuilder.append(string);
            } else if (key.input != '\u0000') {
                if (key.input == ' ') {
                    stringBuilder.append("SPACE");
                } else {
                    stringBuilder.append(key.input);
                }
            } else {
                return;
            }
            this.setText(stringBuilder.toString());
            if (GrabKeyDialog.this.debugBuffer == null) {
                GrabKeyDialog.this.updateAssignedTo(stringBuilder.toString());
            }
        }
    }

    public static class KeyBinding {
        public String actionSet;
        public String name;
        public String label;
        public String tooltip;
        public String shortcut;
        public boolean isPrefix;

        public KeyBinding(String string, String string2, String string3, String string4, boolean bl) {
            this.name = string;
            this.label = string2;
            this.tooltip = string3;
            this.shortcut = string4;
            this.isPrefix = bl;
        }

        public boolean isAssigned() {
            return this.shortcut != null && this.shortcut.length() > 0;
        }
    }
}

