/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.plugins.repository.vfs.VfsRepository;
import org.apache.ivy.plugins.resolver.RepositoryResolver;

public class VfsResolver
extends RepositoryResolver {
    private static final Pattern URL_PATTERN = Pattern.compile("[a-z]*://(.+):(.+)@.*");
    private static final int PASSWORD_GROUP = 2;

    public VfsResolver() {
        this.setRepository(new VfsRepository());
    }

    @Override
    public String getTypeName() {
        return "vfs";
    }

    @Override
    public String hidePassword(String string) {
        return VfsResolver.prepareForDisplay(string);
    }

    public static String prepareForDisplay(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        Matcher matcher = URL_PATTERN.matcher(stringBuffer);
        if (matcher.matches()) {
            String string2 = matcher.group(2);
            int n = stringBuffer.indexOf(string2);
            StringBuffer stringBuffer2 = new StringBuffer(string2);
            for (int i = 0; i < string2.length(); ++i) {
                stringBuffer2.setCharAt(i, '*');
            }
            String string3 = stringBuffer2.toString();
            stringBuffer = stringBuffer.replace(n, n + string2.length(), string3);
        }
        return stringBuffer.toString();
    }
}

