/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.model;

import com.github.cereda.arara.controller.ConfigurationController;
import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.controller.LoggingController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Language;
import com.github.cereda.arara.model.Messages;
import com.github.cereda.arara.utils.CommonUtils;
import com.github.cereda.arara.utils.DisplayUtils;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Parser {
    private final String[] arguments;
    private Options options;
    private Option version;
    private Option help;
    private Option log;
    private Option verbose;
    private Option silent;
    private Option dryrun;
    private Option timeout;
    private Option language;
    private Option loops;
    private Option preamble;
    private Option onlyheader;
    private static final LanguageController messages = LanguageController.getInstance();

    public Parser() {
        this.arguments = null;
    }

    public Parser(String[] arguments) {
        this.arguments = arguments;
    }

    public boolean parse() throws AraraException {
        this.version = new Option("V", "version", false, "");
        this.help = new Option("h", "help", false, "");
        this.log = new Option("l", "log", false, "");
        this.verbose = new Option("v", "verbose", false, "");
        this.silent = new Option("s", "silent", false, "");
        this.dryrun = new Option("n", "dry-run", false, "");
        this.timeout = new Option("t", "timeout", true, "");
        this.timeout.setArgName("number");
        this.language = new Option("L", "language", true, "");
        this.language.setArgName("code");
        this.loops = new Option("m", "max-loops", true, "");
        this.loops.setArgName("number");
        this.preamble = new Option("p", "preamble", true, "");
        this.preamble.setArgName("name");
        this.onlyheader = new Option("H", "header", false, "");
        this.options = new Options();
        this.options.addOption(this.version);
        this.options.addOption(this.help);
        this.options.addOption(this.log);
        this.options.addOption(this.verbose);
        this.options.addOption(this.silent);
        this.options.addOption(this.dryrun);
        this.options.addOption(this.timeout);
        this.options.addOption(this.language);
        this.options.addOption(this.loops);
        this.options.addOption(this.preamble);
        this.options.addOption(this.onlyheader);
        this.updateDescriptions();
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(this.options, this.arguments);
            if (line.hasOption("language")) {
                ConfigurationController.getInstance().put("execution.language", new Language(line.getOptionValue("language")));
                Locale locale = ((Language)ConfigurationController.getInstance().get("execution.language")).getLocale();
                messages.setLocale(locale);
                this.updateDescriptions();
            }
            if (line.hasOption("help")) {
                this.printVersion();
                this.printUsage();
                return false;
            }
            if (line.hasOption("version")) {
                this.printVersion();
                this.printNotes();
                return false;
            }
            if (line.getArgs().length != 1) {
                this.printVersion();
                this.printUsage();
                return false;
            }
            String reference = line.getArgs()[0];
            if (line.hasOption("timeout")) {
                try {
                    long value = Long.parseLong(line.getOptionValue("timeout"));
                    if (value <= 0L) {
                        throw new AraraException(messages.getMessage(Messages.ERROR_PARSER_TIMEOUT_INVALID_RANGE));
                    }
                    ConfigurationController.getInstance().put("execution.timeout", true);
                    ConfigurationController.getInstance().put("execution.timeout.value", value);
                }
                catch (NumberFormatException nfexception) {
                    throw new AraraException(messages.getMessage(Messages.ERROR_PARSER_TIMEOUT_NAN));
                }
            }
            if (line.hasOption("max-loops")) {
                try {
                    long value = Long.parseLong(line.getOptionValue("max-loops"));
                    if (value <= 0L) {
                        throw new AraraException(messages.getMessage(Messages.ERROR_PARSER_LOOPS_INVALID_RANGE));
                    }
                    ConfigurationController.getInstance().put("execution.loops", value);
                }
                catch (NumberFormatException nfexception) {
                    throw new AraraException(messages.getMessage(Messages.ERROR_PARSER_LOOPS_NAN));
                }
            }
            if (line.hasOption("verbose")) {
                ConfigurationController.getInstance().put("execution.verbose", true);
            }
            if (line.hasOption("silent")) {
                ConfigurationController.getInstance().put("execution.verbose", false);
            }
            if (line.hasOption("dry-run")) {
                ConfigurationController.getInstance().put("execution.dryrun", true);
                ConfigurationController.getInstance().put("execution.errors.halt", false);
            }
            if (line.hasOption("log")) {
                ConfigurationController.getInstance().put("execution.logging", true);
            }
            if (line.hasOption("preamble")) {
                Map preambles = (Map)ConfigurationController.getInstance().get("execution.preambles");
                if (preambles.containsKey(line.getOptionValue("preamble"))) {
                    ConfigurationController.getInstance().put("execution.preamble.active", true);
                    ConfigurationController.getInstance().put("execution.preamble.content", preambles.get(line.getOptionValue("preamble")));
                } else {
                    throw new AraraException(messages.getMessage(Messages.ERROR_PARSER_INVALID_PREAMBLE, line.getOptionValue("preamble")));
                }
            }
            if (line.hasOption("header")) {
                ConfigurationController.getInstance().put("execution.header", true);
            }
            CommonUtils.discoverFile(reference);
            LoggingController.enableLogging((Boolean)ConfigurationController.getInstance().get("execution.logging"));
            ConfigurationController.getInstance().put("display.time", true);
            return true;
        }
        catch (ParseException pexception) {
            this.printVersion();
            this.printUsage();
            return false;
        }
    }

    private void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        StringBuilder builder = new StringBuilder();
        builder.append("arara [file [--dry-run] [--log] ");
        builder.append("[--verbose | --silent] [--timeout N] ");
        builder.append("[--max-loops N] [--language L] ");
        builder.append("[ --preamble P ] [--header] | --help | --version]");
        formatter.printHelp(builder.toString(), this.options);
    }

    private void printVersion() {
        String year = (String)ConfigurationController.getInstance().get("application.copyright.year");
        String number = (String)ConfigurationController.getInstance().get("application.version");
        String revision = (String)ConfigurationController.getInstance().get("application.revision");
        StringBuilder builder = new StringBuilder();
        builder.append("arara ");
        builder.append(number);
        builder.append(" (revision ");
        builder.append(revision);
        builder.append(")");
        builder.append("\n");
        builder.append("Copyright (c) ").append(year).append(", ");
        builder.append("Paulo Roberto Massa Cereda");
        builder.append("\n");
        builder.append(messages.getMessage(Messages.INFO_PARSER_ALL_RIGHTS_RESERVED));
        builder.append("\n");
        System.out.println(builder.toString());
    }

    private void printNotes() {
        DisplayUtils.wrapText(messages.getMessage(Messages.INFO_PARSER_NOTES));
    }

    private void updateDescriptions() {
        this.version.setDescription(messages.getMessage(Messages.INFO_PARSER_VERSION_DESCRIPTION));
        this.help.setDescription(messages.getMessage(Messages.INFO_PARSER_HELP_DESCRIPTION));
        this.log.setDescription(messages.getMessage(Messages.INFO_PARSER_LOG_DESCRIPTION));
        this.verbose.setDescription(messages.getMessage(Messages.INFO_PARSER_VERBOSE_MODE_DESCRIPTION));
        this.silent.setDescription(messages.getMessage(Messages.INFO_PARSER_SILENT_MODE_DESCRIPTION));
        this.dryrun.setDescription(messages.getMessage(Messages.INFO_PARSER_DRYRUN_MODE_DESCRIPTION));
        this.timeout.setDescription(messages.getMessage(Messages.INFO_PARSER_TIMEOUT_DESCRIPTION));
        this.language.setDescription(messages.getMessage(Messages.INFO_PARSER_LANGUAGE_DESCRIPTION));
        this.loops.setDescription(messages.getMessage(Messages.INFO_PARSER_LOOPS_DESCRIPTION));
        this.preamble.setDescription(messages.getMessage(Messages.INFO_PARSER_PREAMBLE_DESCRIPTION));
        this.onlyheader.setDescription(messages.getMessage(Messages.INFO_PARSER_ONLY_HEADER));
    }
}

