/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.utils;

import com.github.cereda.arara.controller.ConfigurationController;
import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Conditional;
import com.github.cereda.arara.model.Directive;
import com.github.cereda.arara.model.Messages;
import com.github.cereda.arara.model.Pair;
import com.github.cereda.arara.utils.CommonUtils;
import com.github.cereda.arara.utils.DirectiveAssembler;
import com.github.cereda.arara.utils.DirectiveResolver;
import com.github.cereda.arara.utils.DisplayUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.representer.Representer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectiveUtils {
    private static final LanguageController messages = LanguageController.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(DirectiveUtils.class);

    public static List<Directive> extractDirectives(List<String> lines) throws AraraException {
        Matcher matcher;
        boolean header = (Boolean)ConfigurationController.getInstance().get("execution.header");
        String regex = (String)ConfigurationController.getInstance().get("execution.file.pattern");
        Pattern linecheck = Pattern.compile(regex);
        regex = regex.concat((String)ConfigurationController.getInstance().get("application.pattern"));
        Pattern pattern = Pattern.compile(regex);
        ArrayList<Object> pairs = new ArrayList<Object>();
        for (int i = 0; i < lines.size(); ++i) {
            matcher = pattern.matcher(lines.get(i));
            if (matcher.find()) {
                String line = lines.get(i).substring(matcher.end(), lines.get(i).length());
                Pair<Integer, String> pair = new Pair<Integer, String>(i + 1, line);
                pairs.add(pair);
                logger.info(messages.getMessage(Messages.LOG_INFO_POTENTIAL_PATTERN_FOUND, i + 1, line.trim()));
                continue;
            }
            if (header && !DirectiveUtils.checkLinePattern(linecheck, lines.get(i))) break;
        }
        if (pairs.isEmpty()) {
            throw new AraraException(messages.getMessage(Messages.ERROR_VALIDATE_NO_DIRECTIVES_FOUND));
        }
        ArrayList<DirectiveAssembler> assemblers = new ArrayList<DirectiveAssembler>();
        DirectiveAssembler assembler = new DirectiveAssembler();
        regex = (String)ConfigurationController.getInstance().get("directives.linebreak.pattern");
        pattern = Pattern.compile(regex);
        for (Pair pair : pairs) {
            matcher = pattern.matcher((CharSequence)pair.getSecondElement());
            if (matcher.find()) {
                if (!assembler.isAppendAllowed()) {
                    throw new AraraException(messages.getMessage(Messages.ERROR_VALIDATE_ORPHAN_LINEBREAK, pair.getFirstElement()));
                }
                assembler.addLineNumber((Integer)pair.getFirstElement());
                assembler.appendLine(matcher.group(1));
                continue;
            }
            if (assembler.isAppendAllowed()) {
                assemblers.add(assembler);
            }
            assembler = new DirectiveAssembler();
            assembler.addLineNumber((Integer)pair.getFirstElement());
            assembler.appendLine((String)pair.getSecondElement());
        }
        if (assembler.isAppendAllowed()) {
            assemblers.add(assembler);
        }
        ArrayList<Directive> directives = new ArrayList<Directive>();
        for (DirectiveAssembler current : assemblers) {
            directives.add(DirectiveUtils.generateDirective(current));
        }
        return directives;
    }

    public static Directive generateDirective(DirectiveAssembler assembler) throws AraraException {
        String regex = (String)ConfigurationController.getInstance().get("directives.pattern");
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(assembler.getText());
        if (matcher.find()) {
            Directive directive = new Directive();
            directive.setIdentifier(matcher.group(1));
            directive.setParameters(DirectiveUtils.getParameters(matcher.group(3), assembler.getLineNumbers()));
            Conditional conditional = new Conditional();
            conditional.setType(DirectiveUtils.getType(matcher.group(5)));
            conditional.setCondition(DirectiveUtils.getCondition(matcher.group(6)));
            directive.setConditional(conditional);
            directive.setLineNumbers(assembler.getLineNumbers());
            logger.info(messages.getMessage(Messages.LOG_INFO_POTENTIAL_DIRECTIVE_FOUND, directive));
            return directive;
        }
        throw new AraraException(messages.getMessage(Messages.ERROR_VALIDATE_INVALID_DIRECTIVE_FORMAT, CommonUtils.getCollectionElements(assembler.getLineNumbers(), "(", ")", ", ")));
    }

    private static Conditional.ConditionalType getType(String text) {
        if (text == null) {
            return Conditional.ConditionalType.NONE;
        }
        if (text.equals("if")) {
            return Conditional.ConditionalType.IF;
        }
        if (text.equals("while")) {
            return Conditional.ConditionalType.WHILE;
        }
        if (text.equals("until")) {
            return Conditional.ConditionalType.UNTIL;
        }
        return Conditional.ConditionalType.UNLESS;
    }

    private static String getCondition(String text) {
        return text == null ? "" : text;
    }

    private static Map<String, Object> getParameters(String text, List<Integer> numbers) throws AraraException {
        if (text == null) {
            return new HashMap<String, Object>();
        }
        Yaml yaml = new Yaml(new Constructor(), new Representer(), new DumperOptions(), new DirectiveResolver());
        try {
            HashMap map = yaml.loadAs(text, HashMap.class);
            return map;
        }
        catch (MarkedYAMLException exception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_VALIDATE_YAML_EXCEPTION, CommonUtils.getCollectionElements(numbers, "(", ")", ", ")), exception);
        }
    }

    public static List<Directive> validate(List<Directive> directives) throws AraraException {
        ArrayList<Directive> result = new ArrayList<Directive>();
        for (Directive directive : directives) {
            Map<String, Object> parameters = directive.getParameters();
            if (parameters.containsKey("file")) {
                throw new AraraException(messages.getMessage(Messages.ERROR_VALIDATE_FILE_IS_RESERVED, CommonUtils.getCollectionElements(directive.getLineNumbers(), "(", ")", ", ")));
            }
            if (parameters.containsKey("reference")) {
                throw new AraraException(messages.getMessage(Messages.ERROR_VALIDATE_REFERENCE_IS_RESERVED, CommonUtils.getCollectionElements(directive.getLineNumbers(), "(", ")", ", ")));
            }
            if (parameters.containsKey("files")) {
                Object holder = parameters.get("files");
                if (holder instanceof List) {
                    List files = (List)holder;
                    parameters.remove("files");
                    if (files.isEmpty()) {
                        throw new AraraException(messages.getMessage(Messages.ERROR_VALIDATE_EMPTY_FILES_LIST, CommonUtils.getCollectionElements(directive.getLineNumbers(), "(", ")", ", ")));
                    }
                    for (Object file : files) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        for (String key : parameters.keySet()) {
                            map.put(key, parameters.get(key));
                        }
                        File representation = CommonUtils.getCanonicalFile(String.valueOf(file));
                        map.put("reference", representation);
                        map.put("file", representation.getName());
                        Directive addition = new Directive();
                        Conditional conditional = new Conditional();
                        conditional.setCondition(directive.getConditional().getCondition());
                        conditional.setType(directive.getConditional().getType());
                        addition.setIdentifier(directive.getIdentifier());
                        addition.setConditional(conditional);
                        addition.setParameters(map);
                        addition.setLineNumbers(directive.getLineNumbers());
                        result.add(addition);
                    }
                    continue;
                }
                throw new AraraException(messages.getMessage(Messages.ERROR_VALIDATE_FILES_IS_NOT_A_LIST, CommonUtils.getCollectionElements(directive.getLineNumbers(), "(", ")", ", ")));
            }
            File representation = (File)ConfigurationController.getInstance().get("execution.reference");
            parameters.put("file", representation.getName());
            parameters.put("reference", representation);
            directive.setParameters(parameters);
            result.add(directive);
        }
        logger.info(messages.getMessage(Messages.LOG_INFO_VALIDATED_DIRECTIVES));
        logger.info(DisplayUtils.displayOutputSeparator(messages.getMessage(Messages.LOG_INFO_DIRECTIVES_BLOCK)));
        for (Directive directive : result) {
            logger.info(directive.toString());
        }
        logger.info(DisplayUtils.displaySeparator());
        return result;
    }

    private static boolean checkLinePattern(Pattern pattern, String line) {
        return CommonUtils.checkEmptyString(line.trim()) || pattern.matcher(line).find();
    }
}

