/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.tools.jconsole.JConsolePlugin;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.Messages;

final class ExceptionSafePlugin
extends JConsolePlugin {
    private static boolean ignoreExceptions;
    private final JConsolePlugin plugin;

    public ExceptionSafePlugin(JConsolePlugin jConsolePlugin) {
        this.plugin = jConsolePlugin;
    }

    @Override
    public Map<String, JPanel> getTabs() {
        try {
            return this.plugin.getTabs();
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
            return new HashMap<String, JPanel>();
        }
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        try {
            return this.plugin.newSwingWorker();
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
            return null;
        }
    }

    @Override
    public void dispose() {
        try {
            this.plugin.dispose();
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
        }
    }

    public void executeSwingWorker(SwingWorker<?, ?> swingWorker) {
        try {
            swingWorker.execute();
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
        }
    }

    private void handleException(Exception exception) {
        if (JConsole.isDebug()) {
            System.err.println("Plug-in exception:");
            exception.printStackTrace();
        } else if (!ignoreExceptions) {
            this.showExceptionDialog(exception);
        }
    }

    private void showExceptionDialog(Exception exception) {
        Object[] objectArray = new Object[]{Messages.PLUGIN_EXCEPTION_DIALOG_BUTTON_OK, Messages.PLUGIN_EXCEPTION_DIALOG_BUTTON_EXIT, Messages.PLUGIN_EXCEPTION_DIALOG_BUTTON_IGNORE};
        String string = String.format(Messages.PLUGIN_EXCEPTION_DIALOG_MESSAGE, this.plugin.getClass().getSimpleName(), String.valueOf(exception.getMessage()));
        int n = JOptionPane.showOptionDialog(null, string, Messages.PLUGIN_EXCEPTION_DIALOG_TITLE, 1, 0, null, objectArray, objectArray[0]);
        if (n == 1) {
            System.exit(0);
        }
        ignoreExceptions = n == 2;
    }
}

