/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11KeyGenerator
extends KeyGeneratorSpi {
    private final Token token;
    private final String algorithm;
    private long mechanism;
    private int keySize;
    private int significantKeySize;
    private long keyType;
    private boolean supportBothKeySizes;

    static int checkKeySize(long keyGenMech, int keySize, Token token) throws InvalidAlgorithmParameterException, ProviderException {
        int sigKeySize;
        switch ((int)keyGenMech) {
            case 288: {
                if (keySize != 64 && keySize != 56) {
                    throw new InvalidAlgorithmParameterException("DES key length must be 56 bits");
                }
                sigKeySize = 56;
                break;
            }
            case 304: 
            case 305: {
                if (keySize == 112 || keySize == 128) {
                    sigKeySize = 112;
                    break;
                }
                if (keySize == 168 || keySize == 192) {
                    sigKeySize = 168;
                    break;
                }
                throw new InvalidAlgorithmParameterException("DESede key length must be 112, or 168 bits");
            }
            default: {
                CK_MECHANISM_INFO info = null;
                try {
                    info = token.getMechanismInfo(keyGenMech);
                }
                catch (PKCS11Exception p11e) {
                    throw new ProviderException("Cannot retrieve mechanism info", p11e);
                }
                if (info == null) {
                    return keySize;
                }
                int minKeySize = (int)info.ulMinKeySize;
                int maxKeySize = (int)info.ulMaxKeySize;
                if (keyGenMech != 272L || minKeySize < 8) {
                    minKeySize = (int)info.ulMinKeySize << 3;
                    maxKeySize = (int)info.ulMaxKeySize << 3;
                }
                if (minKeySize < 40) {
                    minKeySize = 40;
                }
                if (keySize < minKeySize || keySize > maxKeySize) {
                    throw new InvalidAlgorithmParameterException("Key length must be between " + minKeySize + " and " + maxKeySize + " bits");
                }
                if (keyGenMech == 4224L && keySize != 128 && keySize != 192 && keySize != 256) {
                    throw new InvalidAlgorithmParameterException("AES key length must be " + minKeySize + (maxKeySize >= 192 ? ", 192" : "") + (maxKeySize >= 256 ? ", or 256" : "") + " bits");
                }
                sigKeySize = keySize;
            }
        }
        return sigKeySize;
    }

    P11KeyGenerator(Token token, String algorithm, long mechanism) throws PKCS11Exception {
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = mechanism;
        if (this.mechanism == 305L) {
            this.supportBothKeySizes = token.provider.config.isEnabled(304L) && token.getMechanismInfo(304L) != null;
        }
        this.setDefaultKeySize();
    }

    private void setDefaultKeySize() {
        switch ((int)this.mechanism) {
            case 288: {
                this.keySize = 64;
                this.keyType = 19L;
                break;
            }
            case 304: {
                this.keySize = 128;
                this.keyType = 20L;
                break;
            }
            case 305: {
                this.keySize = 192;
                this.keyType = 21L;
                break;
            }
            case 4224: {
                this.keySize = 128;
                this.keyType = 31L;
                break;
            }
            case 272: {
                this.keySize = 128;
                this.keyType = 18L;
                break;
            }
            case 4240: {
                this.keySize = 128;
                this.keyType = 32L;
                break;
            }
            default: {
                throw new ProviderException("Unknown mechanism " + this.mechanism);
            }
        }
        try {
            this.significantKeySize = P11KeyGenerator.checkKeySize(this.mechanism, this.keySize, this.token);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new ProviderException("Unsupported default key size", iape);
        }
    }

    @Override
    protected void engineInit(SecureRandom random) {
        this.token.ensureValid();
        this.setDefaultKeySize();
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not supported");
    }

    @Override
    protected void engineInit(int keySize, SecureRandom random) {
        int newSignificantKeySize;
        this.token.ensureValid();
        try {
            newSignificantKeySize = P11KeyGenerator.checkKeySize(this.mechanism, keySize, this.token);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw (InvalidParameterException)new InvalidParameterException().initCause(iape);
        }
        if (this.mechanism == 304L || this.mechanism == 305L) {
            long newMechanism;
            long l = newMechanism = newSignificantKeySize == 112 ? 304L : 305L;
            if (this.mechanism != newMechanism) {
                if (this.supportBothKeySizes) {
                    this.mechanism = newMechanism;
                    this.keyType = this.mechanism == 304L ? 20L : 21L;
                } else {
                    throw new InvalidParameterException("Only " + this.significantKeySize + "-bit DESede is supported");
                }
            }
        }
        this.keySize = keySize;
        this.significantKeySize = newSignificantKeySize;
    }

    @Override
    protected SecretKey engineGenerateKey() {
        Session session = null;
        try {
            CK_ATTRIBUTE[] attributes;
            session = this.token.getObjSession();
            switch ((int)this.keyType) {
                case 19: 
                case 20: 
                case 21: {
                    attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L)};
                    break;
                }
                default: {
                    attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(353L, this.keySize >> 3)};
                }
            }
            attributes = this.token.getAttributes("generate", 4L, this.keyType, attributes);
            long keyID = this.token.p11.C_GenerateKey(session.id(), new CK_MECHANISM(this.mechanism), attributes);
            SecretKey secretKey = P11Key.secretKey(session, keyID, this.algorithm, this.significantKeySize, attributes);
            return secretKey;
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("Could not generate key", e);
        }
        finally {
            this.token.releaseSession(session);
        }
    }
}

