/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import com.headius.backport9.modules.Module;
import com.headius.backport9.modules.Modules;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.AbstractRubyMethod;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.java.invokers.InstanceFieldGetter;
import org.jruby.java.invokers.InstanceFieldSetter;
import org.jruby.java.invokers.InstanceMethodInvoker;
import org.jruby.java.invokers.MethodInvoker;
import org.jruby.java.invokers.StaticFieldGetter;
import org.jruby.java.invokers.StaticFieldSetter;
import org.jruby.java.invokers.StaticMethodInvoker;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.ArrayJavaProxyCreator;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyObjectInputStream;

public class JavaProxy
extends RubyObject {
    private transient JavaObject javaObject;
    Object object;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
            return new JavaProxy(runtime2, klazz);
        }
    };
    private static final RubyHash.VisitorWithState<Map> MapPopulatorVisitor = new RubyHash.VisitorWithState<Map>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Map map2) {
            map2.put(key2.asString().toString(), value2.asString().toString());
        }
    };
    private static final String NONPERSISTENT_IVAR_MESSAGE = "instance vars on non-persistent Java type {0} (http://wiki.jruby.org/Persistence)";
    private static final String NONPERSISTENT_SINGLETON_MESSAGE = "singleton on non-persistent Java type {0} (http://wiki.jruby.org/Persistence)";

    public JavaProxy(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
    }

    public JavaProxy(Ruby runtime2, RubyClass klazz, Object object) {
        super(runtime2, klazz);
        this.object = object;
    }

    public static RubyClass createJavaProxy(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyClass JavaProxy2 = runtime2.defineClass("JavaProxy", runtime2.getObject(), ALLOCATOR);
        JavaProxy2.getSingletonClass().addReadWriteAttribute(context, "java_class");
        JavaProxy2.defineAnnotatedMethods(JavaProxy.class);
        JavaProxy2.includeModule(runtime2.getModule("JavaProxyMethods"));
        return JavaProxy2;
    }

    @Override
    public final Object dataGetStruct() {
        if (this.javaObject == null) {
            this.javaObject = this.asJavaObject(this.object);
        }
        return this.javaObject;
    }

    @Override
    public final void dataWrapStruct(Object object) {
        this.javaObject = (JavaObject)object;
        this.object = this.javaObject.getValue();
    }

    public final Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object unwrap() {
        return this.getObject();
    }

    protected JavaObject asJavaObject(Object object) {
        return JavaObject.wrap(this.getRuntime(), object);
    }

    @Override
    public Class<?> getJavaClass() {
        return this.getObject().getClass();
    }

    static JavaClass java_class(ThreadContext context, RubyModule module) {
        return (JavaClass)JavaClass.java_class(context, module);
    }

    @JRubyMethod(meta=true, frame=true)
    public static IRubyObject inherited(ThreadContext context, IRubyObject recv2, IRubyObject subclass) {
        IRubyObject subJavaClass = JavaClass.java_class(context, (RubyClass)subclass);
        if (subJavaClass.isNil()) {
            subJavaClass = JavaClass.java_class(context, (RubyClass)recv2);
            Helpers.invoke(context, subclass, "java_class=", subJavaClass);
        }
        return Helpers.invokeSuper(context, recv2, subclass, Block.NULL_BLOCK);
    }

    @JRubyMethod(meta=true)
    public static RubyClass singleton_class(IRubyObject self2) {
        return ((RubyClass)self2).getSingletonClass();
    }

    @JRubyMethod(name={"[]"}, meta=true, rest=true)
    public static IRubyObject op_aref(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        JavaClass javaClass = JavaProxy.java_class(context, (RubyModule)self2);
        if (args2.length > 0) {
            return new ArrayJavaProxyCreator(context, javaClass, args2);
        }
        return Java.get_proxy_class(javaClass, Helpers.invoke(context, javaClass, "array_class"));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject new_array(ThreadContext context, IRubyObject self2, IRubyObject len) {
        JavaClass javaClass = JavaProxy.java_class(context, (RubyModule)self2);
        Class componentType = javaClass.javaClass();
        int length2 = (int)len.convertToInteger().getLongValue();
        return ArrayJavaProxy.newArray(context.runtime, componentType, length2);
    }

    @JRubyMethod(name={"__persistent__="}, meta=true)
    public static IRubyObject persistent(IRubyObject clazz, IRubyObject value2) {
        ((RubyClass)clazz).getRealClass().setCacheProxy(value2.isTrue());
        return value2;
    }

    @JRubyMethod(name={"__persistent__"}, meta=true)
    public static IRubyObject persistent(ThreadContext context, IRubyObject clazz) {
        return context.runtime.newBoolean(((RubyClass)clazz).getRealClass().getCacheProxy());
    }

    @Override
    public IRubyObject initialize_copy(IRubyObject original) {
        super.initialize_copy(original);
        this.setObject(((JavaProxy)original).cloneObject());
        return this;
    }

    protected Object cloneObject() {
        Object object = this.getObject();
        if (object instanceof Cloneable) {
            Object clone2 = JavaUtil.clone(object);
            return clone2 == null ? object : clone2;
        }
        return object;
    }

    private static Map<String, String> getFieldListFromArgs(ThreadContext context, IRubyObject[] args2) {
        HashMap<String, String> map2 = new HashMap<String, String>(args2.length, 1.0f);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            IRubyObject arg2 = args2[i2];
            if (arg2 instanceof RubyHash) {
                ((RubyHash)arg2).visitAll(context, MapPopulatorVisitor, map2);
                continue;
            }
            String value2 = arg2.asString().toString();
            map2.put(value2, value2);
        }
        return map2;
    }

    private static void installField(ThreadContext context, Map<String, String> fieldMap, Field field2, RubyModule module, boolean asReader, boolean asWriter) {
        String fieldName = field2.getName();
        Iterator<Map.Entry<String, String>> iter = fieldMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!entry.getKey().equals(fieldName)) continue;
            JavaProxy.installField(context, entry.getValue(), field2, module, asReader, (Boolean)asWriter);
            iter.remove();
            break;
        }
    }

    private static void installField(ThreadContext context, String asName, Field field2, RubyModule target, boolean asReader, Boolean asWriter) {
        if (Ruby.isSecurityRestricted() && !Modifier.isPublic(field2.getModifiers())) {
            throw context.runtime.newSecurityError("Cannot change accessibility on field in restricted mode  '" + field2 + "'");
        }
        String fieldName = field2.getName();
        if (Modifier.isStatic(field2.getModifiers())) {
            if (asReader) {
                target.getSingletonClass().addMethod(asName, new StaticFieldGetter(fieldName, target, field2));
            }
            if (asWriter == null || asWriter.booleanValue()) {
                if (Modifier.isFinal(field2.getModifiers())) {
                    if (asWriter == null) {
                        return;
                    }
                    throw context.runtime.newSecurityError("Cannot change final field '" + field2 + "'");
                }
                target.getSingletonClass().addMethod(asName + '=', new StaticFieldSetter(fieldName, target, field2));
            }
        } else {
            if (asReader) {
                target.addMethod(asName, new InstanceFieldGetter(fieldName, target, field2));
            }
            if (asWriter == null || asWriter.booleanValue()) {
                if (Modifier.isFinal(field2.getModifiers())) {
                    if (asWriter == null) {
                        return;
                    }
                    throw context.runtime.newSecurityError("Cannot change final field '" + field2 + "'");
                }
                target.addMethod(asName + '=', new InstanceFieldSetter(fieldName, target, field2));
            }
        }
    }

    public static void installField(ThreadContext context, String asName, Field field2, RubyModule target) {
        JavaProxy.installField(context, asName, field2, target, true, null);
    }

    private static void findFields(ThreadContext context, RubyModule topModule, IRubyObject[] args2, boolean asReader, boolean asWriter) {
        Map<String, String> fieldMap = JavaProxy.getFieldListFromArgs(context, args2);
        for (RubyModule module = topModule; module != null; module = module.getSuperClass()) {
            Class<?> javaClass = JavaClass.getJavaClassIfProxy(context, module);
            if (javaClass == null) continue;
            Field[] fields2 = JavaClass.getDeclaredFields(javaClass);
            for (int j = 0; j < fields2.length; ++j) {
                JavaProxy.installField(context, fieldMap, fields2[j], module, asReader, asWriter);
            }
        }
        if (!fieldMap.isEmpty()) {
            throw JavaClass.undefinedFieldError(context.runtime, topModule.getName(), fieldMap.keySet().iterator().next());
        }
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_accessor(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)self2, args2, true, true);
        return context.nil;
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_reader(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)self2, args2, true, false);
        return context.nil;
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_writer(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)self2, args2, false, true);
        return context.nil;
    }

    @Override
    @JRubyMethod(name={"equal?"})
    public IRubyObject equal_p(ThreadContext context, IRubyObject other) {
        if (other instanceof JavaProxy) {
            boolean equal = this.getObject() == ((JavaProxy)other).getObject();
            return context.runtime.newBoolean(equal);
        }
        return context.fals;
    }

    @JRubyMethod
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName) {
        String name2 = rubyName.asJavaString();
        Ruby runtime2 = context.runtime;
        JavaMethod method2 = new JavaMethod(runtime2, this.getMethod(context, name2, new Class[0]));
        return method2.invokeDirect(context, this.getObject());
    }

    @JRubyMethod
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Ruby runtime2 = context.runtime;
        JavaProxy.checkArgSizeMismatch(runtime2, 0, argTypesAry);
        JavaMethod method2 = new JavaMethod(runtime2, this.getMethod(context, name2, new Class[0]));
        return method2.invokeDirect(context, this.getObject());
    }

    @JRubyMethod
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes, IRubyObject arg0) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Ruby runtime2 = context.runtime;
        JavaProxy.checkArgSizeMismatch(runtime2, 1, argTypesAry);
        Class argTypeClass = argTypesAry.eltInternal(0).toJava(Class.class);
        JavaMethod method2 = new JavaMethod(runtime2, this.getMethod(context, name2, argTypeClass));
        return method2.invokeDirect(context, this.getObject(), arg0.toJava(argTypeClass));
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject java_send(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        String name2 = args2[0].asJavaString();
        RubyArray argTypesAry = args2[1].convertToArray();
        int argsLen = args2.length - 2;
        JavaProxy.checkArgSizeMismatch(runtime2, argsLen, argTypesAry);
        Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argsLen]);
        Object[] javaArgs = new Object[argsLen];
        for (int i2 = 0; i2 < argsLen; ++i2) {
            javaArgs[i2] = args2[i2 + 2].toJava(argTypesClasses[i2]);
        }
        JavaMethod method2 = new JavaMethod(runtime2, this.getMethod(context, name2, argTypesClasses));
        return method2.invokeDirect(context, this.getObject(), javaArgs);
    }

    private static void checkArgSizeMismatch(Ruby runtime2, int expected, RubyArray argTypes) {
        if (argTypes.size() != expected) {
            Class[] argTypesClasses = (Class[])argTypes.toArray(new Class[argTypes.size()]);
            throw JavaMethod.newArgSizeMismatchError(runtime2, argTypesClasses);
        }
    }

    @JRubyMethod
    public IRubyObject java_method(ThreadContext context, IRubyObject rubyName) {
        String name2 = rubyName.asJavaString();
        return this.getRubyMethod(context, name2, new Class[0]);
    }

    @JRubyMethod
    public IRubyObject java_method(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
        return this.getRubyMethod(context, name2, argTypesClasses);
    }

    @JRubyMethod
    public IRubyObject marshal_dump() {
        if (!Serializable.class.isAssignableFrom(this.object.getClass())) {
            throw this.getRuntime().newTypeError("Java type is not serializable, cannot be marshaled " + this.getJavaClass());
        }
        try {
            ByteArrayOutputStream bytes2 = new ByteArrayOutputStream();
            new ObjectOutputStream(bytes2).writeObject(this.object);
            return this.getRuntime().newString(new ByteList(bytes2.toByteArray(), false));
        }
        catch (IOException ex) {
            throw this.getRuntime().newTypeError("Java type is not serializable: " + ex.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject marshal_load(ThreadContext context, IRubyObject str) {
        try {
            ByteList byteList = str.convertToString().getByteList();
            ByteArrayInputStream bytes2 = new ByteArrayInputStream(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize());
            this.object = new JRubyObjectInputStream(context.runtime, bytes2).readObject();
            return this;
        }
        catch (IOException ex) {
            throw context.runtime.newIOErrorFromException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw context.runtime.newTypeError("Class not found unmarshaling Java type: " + ex.getLocalizedMessage());
        }
    }

    @Override
    protected int inspectHashCode() {
        return System.identityHashCode(this.object);
    }

    private Method getMethod(ThreadContext context, String name2, Class ... argTypes) {
        Class<?> originalClass = this.getObject().getClass();
        try {
            for (Class<?> clazz = originalClass; clazz != null; clazz = clazz.getSuperclass()) {
                Method method2;
                Module module = Modules.getModule(clazz);
                Package pkg = clazz.getPackage();
                if (pkg != null && !module.isExported(pkg.getName()) || !Modifier.isPublic((method2 = clazz.getMethod(name2, argTypes)).getModifiers())) continue;
                return method2;
            }
        }
        catch (NoSuchMethodException nsme) {
            throw JavaMethod.newMethodNotFoundError(context.runtime, originalClass, name2 + CodegenUtils.prettyParams(argTypes), name2);
        }
        throw JavaMethod.newMethodNotFoundError(context.runtime, originalClass, name2 + CodegenUtils.prettyParams(argTypes), name2);
    }

    private MethodInvoker getMethodInvoker(Method method2) {
        if (Modifier.isStatic(method2.getModifiers())) {
            return new StaticMethodInvoker((RubyModule)this.metaClass.getMetaClass(), method2, method2.getName());
        }
        return new InstanceMethodInvoker((RubyModule)this.metaClass, method2, method2.getName());
    }

    private RubyMethod getRubyMethod(ThreadContext context, String name2, Class ... argTypes) {
        Method jmethod = this.getMethod(context, name2, argTypes);
        if (Modifier.isStatic(jmethod.getModifiers())) {
            RubyClass sourceModule = this.metaClass.getSingletonClass();
            return RubyMethod.newMethod(sourceModule, CodegenUtils.prettyParams(argTypes).toString(), sourceModule, name2, new CacheEntry(this.getMethodInvoker(jmethod), sourceModule, this.metaClass.getGeneration()), this.getMetaClass());
        }
        RubyClass sourceModule = this.metaClass;
        return RubyMethod.newMethod(sourceModule, CodegenUtils.prettyParams(argTypes).toString(), sourceModule, name2, new CacheEntry(this.getMethodInvoker(jmethod), sourceModule, this.metaClass.getGeneration()), this);
    }

    @Override
    public <T> T toJava(Class<T> type2) {
        Object object = this.getObject();
        Class<?> clazz = object.getClass();
        if (type2.isAssignableFrom(clazz)) {
            return type2.cast(object);
        }
        if (type2.isAssignableFrom(this.getClass())) {
            return type2.cast(this);
        }
        throw this.getRuntime().newTypeError("failed to coerce " + clazz.getName() + " to " + type2.getName());
    }

    @Override
    public Object getVariable(int index2) {
        this.confirmCachedProxy(NONPERSISTENT_IVAR_MESSAGE);
        return super.getVariable(index2);
    }

    @Override
    public void setVariable(int index2, Object value2) {
        this.confirmCachedProxy(NONPERSISTENT_IVAR_MESSAGE);
        super.setVariable(index2, value2);
    }

    @Override
    public RubyClass getSingletonClass() {
        this.confirmCachedProxy(NONPERSISTENT_SINGLETON_MESSAGE);
        return super.getSingletonClass();
    }

    private void confirmCachedProxy(String message2) {
        RubyClass realClass = this.metaClass.getRealClass();
        if (!realClass.getCacheProxy()) {
            Ruby runtime2 = this.getRuntime();
            if (Java.OBJECT_PROXY_CACHE) {
                runtime2.getWarnings().warnOnce(IRubyWarnings.ID.NON_PERSISTENT_JAVA_PROXY, MessageFormat.format(message2, realClass));
            } else {
                runtime2.getWarnings().warn(MessageFormat.format(message2, realClass));
                realClass.setCacheProxy(true);
                runtime2.getJavaSupport().getObjectProxyCache().put(this.getObject(), this);
            }
        }
    }

    public static class ClassMethods {
        @JRubyMethod(name={"const_missing"}, required=1, meta=true, visibility=Visibility.PRIVATE, frame=true)
        public static IRubyObject const_missing(ThreadContext context, IRubyObject self2, IRubyObject name2) {
            return Java.get_inner_class(context, (RubyModule)self2, name2);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_method(ThreadContext context, IRubyObject proxyClass, IRubyObject rubyName) {
            String name2 = rubyName.asJavaString();
            return ClassMethods.getRubyMethod(context, proxyClass, name2, new Class[0]);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_method(ThreadContext context, IRubyObject proxyClass, IRubyObject rubyName, IRubyObject argTypes) {
            String name2 = rubyName.asJavaString();
            RubyArray argTypesAry = argTypes.convertToArray();
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
            return ClassMethods.getRubyMethod(context, proxyClass, name2, argTypesClasses);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject rubyName) {
            String name2 = rubyName.asJavaString();
            Ruby runtime2 = context.runtime;
            JavaMethod method2 = new JavaMethod(runtime2, ClassMethods.getMethodFromClass(context, recv2, name2, new Class[0]));
            return method2.invokeStaticDirect(context);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject rubyName, IRubyObject argTypes) {
            String name2 = rubyName.asJavaString();
            RubyArray argTypesAry = argTypes.convertToArray();
            Ruby runtime2 = context.runtime;
            JavaProxy.checkArgSizeMismatch(runtime2, 0, argTypesAry);
            JavaMethod method2 = new JavaMethod(runtime2, ClassMethods.getMethodFromClass(context, recv2, name2, new Class[0]));
            return method2.invokeStaticDirect(context);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject rubyName, IRubyObject argTypes, IRubyObject arg0) {
            String name2 = rubyName.asJavaString();
            RubyArray argTypesAry = argTypes.convertToArray();
            Ruby runtime2 = context.runtime;
            JavaProxy.checkArgSizeMismatch(runtime2, 1, argTypesAry);
            Class argTypeClass = argTypesAry.eltInternal(0).toJava(Class.class);
            JavaMethod method2 = new JavaMethod(runtime2, ClassMethods.getMethodFromClass(context, recv2, name2, argTypeClass));
            return method2.invokeStaticDirect(context, arg0.toJava(argTypeClass));
        }

        @JRubyMethod(required=1, rest=true, meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
            switch (args2.length) {
                case 1: {
                    return ClassMethods.java_send(context, recv2, args2[0]);
                }
                case 2: {
                    return ClassMethods.java_send(context, recv2, args2[0], args2[1]);
                }
                case 3: {
                    return ClassMethods.java_send(context, recv2, args2[0], args2[1], args2[2]);
                }
            }
            Ruby runtime2 = context.runtime;
            String name2 = args2[0].asJavaString();
            RubyArray argTypesAry = args2[1].convertToArray();
            int argsLen = args2.length - 2;
            JavaProxy.checkArgSizeMismatch(runtime2, argsLen, argTypesAry);
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argsLen]);
            Object[] javaArgs = new Object[argsLen];
            for (int i2 = 0; i2 < argsLen; ++i2) {
                javaArgs[i2] = args2[i2 + 2].toJava(argTypesClasses[i2]);
            }
            JavaMethod method2 = new JavaMethod(runtime2, ClassMethods.getMethodFromClass(context, recv2, name2, argTypesClasses));
            return method2.invokeStaticDirect(context, javaArgs);
        }

        @JRubyMethod(meta=true, visibility=Visibility.PRIVATE)
        public static IRubyObject java_alias(ThreadContext context, IRubyObject clazz, IRubyObject newName, IRubyObject rubyName) {
            return ClassMethods.java_alias(context, clazz, newName, rubyName, context.runtime.newEmptyArray());
        }

        @JRubyMethod(meta=true, visibility=Visibility.PRIVATE)
        public static IRubyObject java_alias(ThreadContext context, IRubyObject clazz, IRubyObject newName, IRubyObject rubyName, IRubyObject argTypes) {
            Ruby runtime2 = context.runtime;
            if (!(clazz instanceof RubyClass)) {
                throw runtime2.newTypeError(clazz, runtime2.getModule());
            }
            RubyClass proxyClass = (RubyClass)clazz;
            String name2 = rubyName.asJavaString();
            String newNameStr = newName.asJavaString();
            RubyArray argTypesAry = argTypes.convertToArray();
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
            Method method2 = ClassMethods.getMethodFromClass(context, clazz, name2, argTypesClasses);
            if (Modifier.isStatic(method2.getModifiers())) {
                StaticMethodInvoker invoker = new StaticMethodInvoker((RubyModule)proxyClass.getMetaClass(), method2, newNameStr);
                proxyClass.getSingletonClass().addMethod(newNameStr, invoker);
            } else {
                InstanceMethodInvoker invoker = new InstanceMethodInvoker((RubyModule)proxyClass, method2, newNameStr);
                proxyClass.addMethod(newNameStr, invoker);
            }
            return context.nil;
        }

        private static AbstractRubyMethod getRubyMethod(ThreadContext context, IRubyObject clazz, String name2, Class ... argTypesClasses) {
            Ruby runtime2 = context.runtime;
            if (!(clazz instanceof RubyModule)) {
                throw runtime2.newTypeError(clazz, runtime2.getModule());
            }
            RubyModule proxyClass = (RubyModule)clazz;
            Method method2 = ClassMethods.getMethodFromClass(context, clazz, name2, argTypesClasses);
            String prettyName = name2 + CodegenUtils.prettyParams(argTypesClasses);
            if (Modifier.isStatic(method2.getModifiers())) {
                StaticMethodInvoker invoker = new StaticMethodInvoker(proxyClass, method2, name2);
                return RubyMethod.newMethod(proxyClass, prettyName, proxyClass, name2, new CacheEntry(invoker, proxyClass, proxyClass.getGeneration()), clazz);
            }
            InstanceMethodInvoker invoker = new InstanceMethodInvoker(proxyClass, method2, name2);
            return RubyUnboundMethod.newUnboundMethod(proxyClass, prettyName, proxyClass, name2, new CacheEntry(invoker, proxyClass, proxyClass.getGeneration()));
        }

        private static Method getMethodFromClass(ThreadContext context, IRubyObject proxyClass, String name2, Class ... argTypes) {
            Class<?> clazz = JavaClass.getJavaClass(context, (RubyModule)proxyClass);
            try {
                return clazz.getMethod(name2, argTypes);
            }
            catch (NoSuchMethodException nsme) {
                String prettyName = name2 + CodegenUtils.prettyParams(argTypes);
                String errorName = clazz.getName() + '.' + prettyName;
                throw context.runtime.newNameError("Java method not found: " + errorName, name2);
            }
        }
    }
}

