# Do not edit this file. This file is auto generated from rna_manual_reference_updater.py

import bpy

url_manual_prefix = "https://docs.blender.org/manual/en/dev/"

language = ""
if bpy.context.user_preferences.system.use_international_fonts:
    language = bpy.context.user_preferences.system.language
    if language == 'DEFAULT':
        import os
        language = os.getenv('LANG', '').split('.')[0]

LANG = {
    "de_DE":        "de",
    "ru_RU":        "ru",
    "es":           "es",
    "fr_FR":        "fr",
    "it_IT":        "it",
    "ja_JP":        "ja",
    "ko_KR":        "ko",
    "pt_PT":        "pt",
    "pt_BR":        "pt",
    "zh_CN":        "zh.cn",
    "zh_TW":        "zh.tw",
}.get(language)

if LANG is not None:
    url_manual_prefix = url_manual_prefix.replace("manual/en", "manual/" + LANG)

url_manual_mapping = (
	("bpy.types.cyclesobjectsettings.use_adaptive_subdivision*", "render/cycles/settings/objects/adaptive_subsurf.html#bpy-types-cyclesobjectsettings-use-adaptive-subdivision"),
	("bpy.types.toolsettings.gpencil_stroke_placement_view3d*", "interface/grease_pencil/drawing/introduction.html#bpy-types-toolsettings-gpencil-stroke-placement-view3d"),
	("bpy.types.cyclesrendersettings.offscreen_dicing_scale*", "render/cycles/settings/scene/render/geometry.html#bpy-types-cyclesrendersettings-offscreen-dicing-scale"),
	("bpy.types.linestylegeometrymodifier_backbonestretcher*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-backbonestretcher"),
	("bpy.types.linestylegeometrymodifier_sinusdisplacement*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-sinusdisplacement"),
	("bpy.types.toolsettings.use_gpencil_continuous_drawing*", "interface/grease_pencil/drawing/introduction.html#bpy-types-toolsettings-use-gpencil-continuous-drawing"),
	("bpy.types.linestylegeometrymodifier_polygonalization*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-polygonalization"),
	("bpy.types.cyclesrendersettings.distance_cull_margin*", "render/cycles/settings/scene/introduction.html#bpy-types-cyclesrendersettings-distance-cull-margin"),
	("bpy.types.toolsettings.use_gpencil_additive_drawing*", "interface/grease_pencil/drawing/introduction.html#bpy-types-toolsettings-use-gpencil-additive-drawing"),
	("bpy.types.toolsettings.use_gpencil_stroke_endpoints*", "interface/grease_pencil/drawing/introduction.html#bpy-types-toolsettings-use-gpencil-stroke-endpoints"),
	("bpy.types.linestylegeometrymodifier_simplification*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-simplification"),
	("bpy.types.cyclesrendersettings.camera_cull_margin*", "render/cycles/settings/scene/introduction.html#bpy-types-cyclesrendersettings-camera-cull-margin"),
	("bpy.types.linestylegeometrymodifier_perlinnoise1d*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-perlinnoise1d"),
	("bpy.types.linestylegeometrymodifier_perlinnoise2d*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-perlinnoise2d"),
	("bpy.types.cyclesrendersettings.use_distance_cull*", "render/cycles/settings/scene/introduction.html#bpy-types-cyclesrendersettings-use-distance-cull"),
	("bpy.types.linestylegeometrymodifier_guidinglines*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-guidinglines"),
	("bpy.types.linestylegeometrymodifier_spatialnoise*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-spatialnoise"),
	("bpy.types.linestylethicknessmodifier_calligraphy*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestylethicknessmodifier-calligraphy"),
	("bpy.types.cyclesrendersettings.max_subdivisions*", "render/cycles/settings/scene/render/geometry.html#bpy-types-cyclesrendersettings-max-subdivisions"),
	("bpy.types.linestyle*modifier_distancefromcamera*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-distancefromcamera"),
	("bpy.types.linestyle*modifier_distancefromobject*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-distancefromobject"),
	("bpy.types.linestylegeometrymodifier_2dtransform*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-2dtransform"),
	("bpy.types.linestylegeometrymodifier_beziercurve*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-beziercurve"),
	("bpy.types.cyclesrendersettings.use_camera_cull*", "render/cycles/settings/scene/introduction.html#bpy-types-cyclesrendersettings-use-camera-cull"),
	("bpy.types.linestylegeometrymodifier_tipremover*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-tipremover"),
	("bpy.types.toolsettings.use_gpencil_draw_onback*", "interface/grease_pencil/drawing/introduction.html#bpy-types-toolsettings-use-gpencil-draw-onback"),
	("bpy.types.cyclesmaterialsettings.displacement*", "render/cycles/materials/settings.html#bpy-types-cyclesmaterialsettings-displacement"),
	("bpy.types.linestylegeometrymodifier_blueprint*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-blueprint"),
	("bpy.types.rendersettings.simplify_subdivision*", "data_system/scenes/properties.html#bpy-types-rendersettings-simplify-subdivision"),
	("bpy.types.cyclesrendersettings.dicing_camera*", "render/cycles/settings/scene/render/geometry.html#bpy-types-cyclesrendersettings-dicing-camera"),
	("bpy.types.cyclesrendersettings.texture_limit*", "render/cycles/settings/scene/introduction.html#bpy-types-cyclesrendersettings-texture-limit"),
	("bpy.types.linestylegeometrymodifier_2doffset*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-2doffset"),
	("bpy.types.linestylegeometrymodifier_sampling*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-sampling"),
	("bpy.types.spaceview3d.show_background_images*", "editors/3dview/properties/background_images.html#bpy-types-spaceview3d-show-background-images"),
	("bpy.types.cyclesrendersettings.*dicing_rate*", "render/cycles/settings/scene/render/geometry.html#bpy-types-cyclesrendersettings-dicing-rate"),
	("bpy.types.rendersettings.use_file_extension*", "render/output/output.html#bpy-types-rendersettings-use-file-extension"),
	("bpy.types.spaceview3d.transform_orientation*", "editors/3dview/object/editing/transform/control/orientations.html#bpy-types-spaceview3d-transform-orientation"),
	("bpy.ops.object.constraint_add_with_targets*", "rigging/constraints/interface/adding_removing.html#bpy-ops-object-constraint-add-with-targets"),
	("bpy.types.cyclesobjectsettings.dicing_rate*", "render/cycles/settings/objects/adaptive_subsurf.html#bpy-types-cyclesobjectsettings-dicing-rate"),
	("bpy.types.spaceuveditor.use_snap_to_pixels*", "editors/uv_image/uv/editing/layout.html#bpy-types-spaceuveditor-use-snap-to-pixels"),
	("bpy.types.linestyle*modifier_curvature_3d*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-curvature-3d"),
	("bpy.types.rendersettings.use_render_cache*", "render/output/output.html#bpy-types-rendersettings-use-render-cache"),
	("bpy.ops.object.anim_transforms_to_deltas*", "editors/3dview/object/editing/transform/clear_apply.html#bpy-ops-object-anim-transforms-to-deltas"),
	("bpy.types.compositornodeplanetrackdeform*", "compositing/types/distort/plane_track_deform.html#bpy-types-compositornodeplanetrackdeform"),
	("bpy.types.gpencilsculptsettings.lockaxis*", "interface/grease_pencil/drawing/introduction.html#bpy-types-gpencilsculptsettings-lockaxis"),
	("bpy.types.linestyle*modifier_alongstroke*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-alongstroke"),
	("bpy.types.linestyle*modifier_creaseangle*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-creaseangle"),
	("bpy.types.rendersettings.use_placeholder*", "render/output/output.html#bpy-types-rendersettings-use-placeholder"),
	("bpy.types.shadernodesubsurfacescattering*", "render/cycles/nodes/types/shaders/sss.html#bpy-types-shadernodesubsurfacescattering"),
	("bpy.types.compositornodecolorcorrection*", "compositing/types/color/color_correction.html#bpy-types-compositornodecolorcorrection"),
	("bpy.types.compositornodemoviedistortion*", "compositing/types/distort/movie_distortion.html#bpy-types-compositornodemoviedistortion"),
	("bpy.types.ffmpegsettings.audio_channels*", "data_system/scenes/properties.html#bpy-types-ffmpegsettings-audio-channels"),
	("bpy.types.fmodifierenvelopecontrolpoint*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifierenvelopecontrolpoint"),
	("bpy.types.spaceuveditor.use_live_unwrap*", "editors/uv_image/uv/editing/layout.html#bpy-types-spaceuveditor-use-live-unwrap"),
	("bpy.types.vertexweightproximitymodifier*", "modeling/modifiers/modify/weight_proximity.html#bpy-types-vertexweightproximitymodifier"),
	("bpy.types.compositornodebrightcontrast*", "compositing/types/color/bright_contrast.html#bpy-types-compositornodebrightcontrast"),
	("bpy.types.compositornodedoubleedgemask*", "compositing/types/matte/double_edge_mask.html#bpy-types-compositornodedoubleedgemask"),
	("bpy.types.ffmpegsettings.audio_mixrate*", "data_system/scenes/properties.html#bpy-types-ffmpegsettings-audio-mixrate"),
	("bpy.types.material.preview_render_type*", "render/blender_render/materials/properties/preview.html#bpy-types-material-preview-render-type"),
	("bpy.types.materialraytracetransparency*", "render/blender_render/materials/properties/transparency.html#bpy-types-materialraytracetransparency"),
	("bpy.types.materialsubsurfacescattering*", "render/blender_render/materials/properties/subsurface_scattering.html#bpy-types-materialsubsurfacescattering"),
	("bpy.types.rendersettings.use_overwrite*", "render/output/output.html#bpy-types-rendersettings-use-overwrite"),
	("bpy.types.shadernodevectordisplacement*", "render/cycles/nodes/types/vector/vector_displacement.html#bpy-types-shadernodevectordisplacement"),
	("bpy.ops.object.visual_transform_apply*", "editors/3dview/object/editing/transform/clear_apply.html#bpy-ops-object-visual-transform-apply"),
	("bpy.types.compositornodebilateralblur*", "compositing/types/filter/bilateral_blur.html#bpy-types-compositornodebilateralblur"),
	("bpy.types.compositornodedistancematte*", "compositing/types/matte/distance_key.html#bpy-types-compositornodedistancematte"),
	("bpy.types.linestyle*modifier_material*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-material"),
	("bpy.types.particlesettingstextureslot*", "render/blender_render/textures/properties/influence/particles.html#bpy-types-particlesettingstextureslot"),
	("bpy.types.rendersettings.display_mode*", "render/output/render_panel.html#bpy-types-rendersettings-display-mode"),
	("bpy.types.spaceview3d.cursor_location*", "editors/3dview/3d_cursor.html#bpy-types-spaceview3d-cursor-location"),
	("bpy.ops.object.duplicate_move_linked*", "editors/3dview/object/editing/duplication.html#bpy-ops-object-duplicate-move-linked"),
	("bpy.types.compositornodechannelmatte*", "compositing/types/matte/channel_key.html#bpy-types-compositornodechannelmatte"),
	("bpy.types.compositornodecolorbalance*", "compositing/types/color/color_balance.html#bpy-types-compositornodecolorbalance"),
	("bpy.types.compositornodekeyingscreen*", "compositing/types/matte/keying_screen.html#bpy-types-compositornodekeyingscreen"),
	("bpy.types.dynamicpaintcanvassettings*", "physics/dynamic_paint/canvas.html#bpy-types-dynamicpaintcanvassettings"),
	("bpy.types.fmodifierfunctiongenerator*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifierfunctiongenerator"),
	("bpy.types.linestyle*modifier_tangent*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-tangent"),
	("bpy.types.movietrackingstabilization*", "editors/movie_clip_editor/tracking/clip/properties/stabilization/index.html#bpy-types-movietrackingstabilization"),
	("bpy.types.shadernodeambientocclusion*", "render/cycles/nodes/types/shaders/ao.html#bpy-types-shadernodeambientocclusion"),
	("bpy.types.shadernodevolumeabsorption*", "render/cycles/nodes/types/shaders/volume_absorption.html#bpy-types-shadernodevolumeabsorption"),
	("bpy.types.shadernodevolumeprincipled*", "render/cycles/nodes/types/shaders/volume_principled.html#bpy-types-shadernodevolumeprincipled"),
	("bpy.types.toolsettings.use_uv_sculpt*", "editors/uv_image/uv/editing/uv_sculpt.html#bpy-types-toolsettings-use-uv-sculpt"),
	("bpy.ops.object.duplicates_make_real*", "editors/3dview/object/editing/transform/clear_apply.html#bpy-ops-object-duplicates-make-real"),
	("bpy.ops.object.transforms_to_deltas*", "editors/3dview/object/editing/transform/clear_apply.html#bpy-ops-object-transforms-to-deltas"),
	("bpy.types.compositornodechromamatte*", "compositing/types/matte/chroma_key.html#bpy-types-compositornodechromamatte"),
	("bpy.types.compositornodedilateerode*", "compositing/types/filter/dilate_erode.html#bpy-types-compositornodedilateerode"),
	("bpy.types.compositornodeellipsemask*", "compositing/types/matte/ellipse_mask.html#bpy-types-compositornodeellipsemask"),
	("bpy.types.compositornodesplitviewer*", "compositing/types/output/split_viewer.html#bpy-types-compositornodesplitviewer"),
	("bpy.types.dynamicpaintbrushsettings*", "physics/dynamic_paint/brush.html#bpy-types-dynamicpaintbrushsettings"),
	("bpy.types.object.slow_parent_offset*", "editors/3dview/object/properties/relations/extras.html#bpy-types-object-slow-parent-offset"),
	("bpy.types.object.use_dupli_vertices*", "editors/3dview/object/properties/duplication/dupliverts.html#bpy-types-object-use-dupli-vertices"),
	("bpy.types.rendersettings.use_border*", "render/output/output.html#bpy-types-rendersettings-use-border"),
	("bpy.types.shadernodebsdfanisotropic*", "render/cycles/nodes/types/shaders/anisotropic.html#bpy-types-shadernodebsdfanisotropic"),
	("bpy.types.shadernodebsdftranslucent*", "render/cycles/nodes/types/shaders/translucent.html#bpy-types-shadernodebsdftranslucent"),
	("bpy.types.shadernodebsdftransparent*", "render/cycles/nodes/types/shaders/transparent.html#bpy-types-shadernodebsdftransparent"),
	("bpy.types.shadernodevectortransform*", "render/cycles/nodes/types/vector/transform.html#bpy-types-shadernodevectortransform"),
	("bpy.types.spaceuveditor.lock_bounds*", "editors/uv_image/uv/editing/layout.html#bpy-types-spaceuveditor-lock-bounds"),
	("bpy.ops.object.datalayout_transfer*", "modeling/meshes/editing/data_transfer.html#bpy-ops-object-datalayout-transfer"),
	("bpy.ops.object.randomize_transform*", "editors/3dview/object/editing/transform/tools.html#bpy-ops-object-randomize-transform"),
	("bpy.types.compositornodebokehimage*", "compositing/types/input/bokeh_image.html#bpy-types-compositornodebokehimage"),
	("bpy.types.compositornodecolormatte*", "compositing/types/matte/color_key.html#bpy-types-compositornodecolormatte"),
	("bpy.types.compositornodecolorspill*", "compositing/types/matte/color_spill.html#bpy-types-compositornodecolorspill"),
	("bpy.types.compositornodehuecorrect*", "compositing/types/color/hue_correct.html#bpy-types-compositornodehuecorrect"),
	("bpy.types.compositornodeoutputfile*", "compositing/types/output/file.html#bpy-types-compositornodeoutputfile"),
	("bpy.types.compositornodeswitchview*", "compositing/types/converter/switch_view.html#bpy-types-compositornodeswitchview"),
	("bpy.types.copytransformsconstraint*", "rigging/constraints/transform/copy_transforms.html#bpy-types-copytransformsconstraint"),
	("bpy.types.correctivesmoothmodifier*", "modeling/modifiers/deform/corrective_smooth.html#bpy-types-correctivesmoothmodifier"),
	("bpy.types.cyclesvisibilitysettings*", "render/cycles/settings/objects/object_data.html#bpy-types-cyclesvisibilitysettings"),
	("bpy.types.linestyle*modifier_noise*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-noise"),
	("bpy.types.maintainvolumeconstraint*", "rigging/constraints/transform/maintain_volume.html#bpy-types-maintainvolumeconstraint"),
	("bpy.types.particleinstancemodifier*", "modeling/modifiers/simulate/particle_instance.html#bpy-types-particleinstancemodifier"),
	("bpy.types.rigidbodyjointconstraint*", "rigging/constraints/relationship/rigid_body_joint.html#bpy-types-rigidbodyjointconstraint"),
	("bpy.types.shadernodebrightcontrast*", "render/cycles/nodes/types/color/bright_contrast.html#bpy-types-shadernodebrightcontrast"),
	("bpy.types.shadernodebsdfprincipled*", "render/cycles/nodes/types/shaders/principled.html#bpy-types-shadernodebsdfprincipled"),
	("bpy.types.shadernodebsdfrefraction*", "render/cycles/nodes/types/shaders/refraction.html#bpy-types-shadernodebsdfrefraction"),
	("bpy.types.shadernodeoutputmaterial*", "render/cycles/nodes/types/output/material.html#bpy-types-shadernodeoutputmaterial"),
	("bpy.types.shadernodetexenvironment*", "render/cycles/nodes/types/textures/environment.html#bpy-types-shadernodetexenvironment"),
	("bpy.types.transformcacheconstraint*", "rigging/constraints/transform/transform_cache.html#bpy-types-transformcacheconstraint"),
	("bpy.types.userpreferencesfilepaths*", "preferences/file.html#bpy-types-userpreferencesfilepaths"),
	("bpy.types.vertexweighteditmodifier*", "modeling/modifiers/modify/weight_edit.html#bpy-types-vertexweighteditmodifier"),
	("bpy.ops.render.play-rendered-anim*", "render/output/animation_player.html#bpy-ops-render-play-rendered-anim"),
	("bpy.types.compositornodealphaover*", "compositing/types/color/alpha_over.html#bpy-types-compositornodealphaover"),
	("bpy.types.compositornodebokehblur*", "compositing/types/filter/bokeh_blur.html#bpy-types-compositornodebokehblur"),
	("bpy.types.compositornodecomposite*", "compositing/types/output/composite.html#bpy-types-compositornodecomposite"),
	("bpy.types.compositornodedespeckle*", "compositing/types/filter/despeckle.html#bpy-types-compositornodedespeckle"),
	("bpy.types.compositornodediffmatte*", "compositing/types/matte/difference_key.html#bpy-types-compositornodediffmatte"),
	("bpy.types.compositornodelumamatte*", "compositing/types/matte/luminance_key.html#bpy-types-compositornodelumamatte"),
	("bpy.types.compositornodemovieclip*", "compositing/types/input/movie_clip.html#bpy-types-compositornodemovieclip"),
	("bpy.types.compositornodenormalize*", "compositing/types/vector/normalize.html#bpy-types-compositornodenormalize"),
	("bpy.types.compositornodepremulkey*", "compositing/types/converter/alpha_convert.html#bpy-types-compositornodepremulkey"),
	("bpy.types.compositornodestabilize*", "compositing/types/distort/stabilize_2d.html#bpy-types-compositornodestabilize"),
	("bpy.types.compositornodetransform*", "compositing/types/distort/transform.html#bpy-types-compositornodetransform"),
	("bpy.types.compositornodetranslate*", "compositing/types/distort/translate.html#bpy-types-compositornodetranslate"),
	("bpy.types.fluidsimulationmodifier*", "physics/fluid/index.html#bpy-types-fluidsimulationmodifier"),
	("bpy.types.freestylemodulesettings*", "render/freestyle/python.html#bpy-types-freestylemodulesettings"),
	("bpy.types.laplaciandeformmodifier*", "modeling/modifiers/deform/laplacian_deform.html#bpy-types-laplaciandeformmodifier"),
	("bpy.types.laplaciansmoothmodifier*", "modeling/modifiers/deform/laplacian_smooth.html#bpy-types-laplaciansmoothmodifier"),
	("bpy.types.limitdistanceconstraint*", "rigging/constraints/transform/limit_distance.html#bpy-types-limitdistanceconstraint"),
	("bpy.types.limitlocationconstraint*", "rigging/constraints/transform/limit_location.html#bpy-types-limitlocationconstraint"),
	("bpy.types.limitrotationconstraint*", "rigging/constraints/transform/limit_rotation.html#bpy-types-limitrotationconstraint"),
	("bpy.types.rendersettings.filepath*", "render/output/output.html#bpy-types-rendersettings-filepath"),
	("bpy.types.shadernodehuesaturation*", "render/cycles/nodes/types/color/hue_saturation.html#bpy-types-shadernodehuesaturation"),
	("bpy.types.shadernodevolumescatter*", "render/cycles/nodes/types/shaders/volume_scatter.html#bpy-types-shadernodevolumescatter"),
	("bpy.types.vertexweightmixmodifier*", "modeling/modifiers/modify/weight_mix.html#bpy-types-vertexweightmixmodifier"),
	("bpy.ops.object.constraints_clear*", "rigging/constraints/interface/adding_removing.html#bpy-ops-object-constraints-clear"),
	("bpy.ops.uv.average_islands_scale*", "editors/uv_image/uv/editing/layout.html#bpy-ops-uv-average-islands-scale"),
	("bpy.ops.view3d.edit_mesh_extrude*", "modeling/meshes/editing/duplicating/extrude.html#bpy-ops-view3d-edit-mesh-extrude"),
	("bpy.types.brightcontrastmodifier*", "editors/vse/sequencer/properties/modifiers.html#bpy-types-brightcontrastmodifier"),
	("bpy.types.camerasolverconstraint*", "rigging/constraints/motion_tracking/camera_solver.html#bpy-types-camerasolverconstraint"),
	("bpy.types.clothcollisionsettings*", "physics/cloth/settings/collisions.html#bpy-types-clothcollisionsettings"),
	("bpy.types.compositornodecurvergb*", "compositing/types/color/rgb_curves.html#bpy-types-compositornodecurvergb"),
	("bpy.types.compositornodecurvevec*", "compositing/types/vector/vector_curves.html#bpy-types-compositornodecurvevec"),
	("bpy.types.compositornodedisplace*", "compositing/types/distort/displace.html#bpy-types-compositornodedisplace"),
	("bpy.types.compositornodelensdist*", "compositing/types/distort/lens_distortion.html#bpy-types-compositornodelensdist"),
	("bpy.types.compositornodemaprange*", "compositing/types/vector/map_range.html#bpy-types-compositornodemaprange"),
	("bpy.types.compositornodemapvalue*", "compositing/types/vector/map_value.html#bpy-types-compositornodemapvalue"),
	("bpy.types.compositornodepixelate*", "compositing/types/filter/pixelate.html#bpy-types-compositornodepixelate"),
	("bpy.types.compositornodesetalpha*", "compositing/types/converter/set_alpha.html#bpy-types-compositornodesetalpha"),
	("bpy.types.compositornodesunbeams*", "compositing/types/filter/sun_beams.html#bpy-types-compositornodesunbeams"),
	("bpy.types.compositornodetrackpos*", "compositing/types/input/track_position.html#bpy-types-compositornodetrackpos"),
	("bpy.types.compositornodezcombine*", "compositing/types/color/z_combine.html#bpy-types-compositornodezcombine"),
	("bpy.types.copylocationconstraint*", "rigging/constraints/transform/copy_location.html#bpy-types-copylocationconstraint"),
	("bpy.types.copyrotationconstraint*", "rigging/constraints/transform/copy_rotation.html#bpy-types-copyrotationconstraint"),
	("bpy.types.cyclesmaterialsettings*", "render/cycles/materials/settings.html#bpy-types-cyclesmaterialsettings"),
	("bpy.types.materialraytracemirror*", "render/blender_render/materials/properties/mirror.html#bpy-types-materialraytracemirror"),
	("bpy.types.object.use_dupli_faces*", "editors/3dview/object/properties/duplication/duplifaces.html#bpy-types-object-use-dupli-faces"),
	("bpy.types.object.use_slow_parent*", "editors/3dview/object/properties/relations/extras.html#bpy-types-object-use-slow-parent"),
	("bpy.types.objectsolverconstraint*", "rigging/constraints/motion_tracking/object_solver.html#bpy-types-objectsolverconstraint"),
	("bpy.types.particlesystemmodifier*", "physics/particles/index.html#bpy-types-particlesystemmodifier"),
	("bpy.types.shadernodedisplacement*", "render/cycles/nodes/types/vector/displacement.html#bpy-types-shadernodedisplacement"),
	("bpy.types.shadernodelightfalloff*", "render/cycles/nodes/types/color/light_falloff.html#bpy-types-shadernodelightfalloff"),
	("bpy.types.shadernodeparticleinfo*", "render/cycles/nodes/types/input/particle_info.html#bpy-types-shadernodeparticleinfo"),
	("bpy.ops.object.constraints_copy*", "rigging/constraints/interface/adding_removing.html#bpy-ops-object-constraints-copy"),
	("bpy.ops.object.make_single_user*", "data_system/data_blocks.html#bpy-ops-object-make-single-user"),
	("bpy.ops.object.select_hierarchy*", "editors/3dview/object/selecting/tools.html#bpy-ops-object-select-hierarchy"),
	("bpy.ops.screen.screen_full_area*", "interface/window_system/areas.html#bpy-ops-screen-screen-full-area"),
	("bpy.ops.transform.shrink_fatten*", "modeling/meshes/editing/transform/shrink-fatten.html#bpy-ops-transform-shrink-fatten"),
	("bpy.ops.view3d.background_image*", "editors/3dview/properties/background_images.html#bpy-ops-view3d-background-image"),
	("bpy.types.compositornodeboxmask*", "compositing/types/matte/box_mask.html#bpy-types-compositornodeboxmask"),
	("bpy.types.compositornodedefocus*", "compositing/types/filter/defocus.html#bpy-types-compositornodedefocus"),
	("bpy.types.compositornodeinpaint*", "compositing/types/filter/inpaint.html#bpy-types-compositornodeinpaint"),
	("bpy.types.compositornodergbtobw*", "compositing/types/converter/rgb_to_bw.html#bpy-types-compositornodergbtobw"),
	("bpy.types.compositornoderlayers*", "compositing/types/input/render_layers.html#bpy-types-compositornoderlayers"),
	("bpy.types.compositornodetexture*", "compositing/types/input/texture.html#bpy-types-compositornodetexture"),
	("bpy.types.compositornodetonemap*", "compositing/types/color/tone_map.html#bpy-types-compositornodetonemap"),
	("bpy.types.compositornodevecblur*", "compositing/types/filter/vector_blur.html#bpy-types-compositornodevecblur"),
	("bpy.types.dampedtrackconstraint*", "rigging/constraints/tracking/damped_track.html#bpy-types-dampedtrackconstraint"),
	("bpy.types.distortednoisetexture*", "render/blender_render/textures/types/procedural/distorted_noise.html#bpy-types-distortednoisetexture"),
	("bpy.types.environmentmaptexture*", "render/blender_render/textures/types/environment.html#bpy-types-environmentmaptexture"),
	("bpy.types.followtrackconstraint*", "rigging/constraints/motion_tracking/follow_track.html#bpy-types-followtrackconstraint"),
	("bpy.types.gpencilsculptsettings*", "interface/grease_pencil/stroke_edit.html#bpy-types-gpencilsculptsettings"),
	("bpy.types.lockedtrackconstraint*", "rigging/constraints/tracking/locked_track.html#bpy-types-lockedtrackconstraint"),
	("bpy.types.obstaclefluidsettings*", "physics/fluid/types/obstacle.html#bpy-types-obstaclefluidsettings"),
	("bpy.types.particlefluidsettings*", "physics/particles/emitter/physics/fluid.html#bpy-types-particlefluidsettings"),
	("bpy.types.rendersettings.engine*", "render/introduction.html#bpy-types-rendersettings-engine"),
	("bpy.types.shadernodebsdfdiffuse*", "render/cycles/nodes/types/shaders/diffuse.html#bpy-types-shadernodebsdfdiffuse"),
	("bpy.types.shadernodelayerweight*", "render/cycles/nodes/types/input/layer_weight.html#bpy-types-shadernodelayerweight"),
	("bpy.types.shadernodeoutputworld*", "render/cycles/nodes/types/output/world.html#bpy-types-shadernodeoutputworld"),
	("bpy.types.shadernodetexgradient*", "render/cycles/nodes/types/textures/gradient.html#bpy-types-shadernodetexgradient"),
	("bpy.types.shadernodetexmusgrave*", "render/cycles/nodes/types/textures/musgrave.html#bpy-types-shadernodetexmusgrave"),
	("bpy.types.shadernodevectorcurve*", "render/cycles/nodes/types/vector/curves.html#bpy-types-shadernodevectorcurve"),
	("bpy.types.userpreferencessystem*", "preferences/system.html#bpy-types-userpreferencessystem"),
	("bpy.ops.mesh.bridge-edge-loops*", "modeling/meshes/editing/edges.html#bpy-ops-mesh-bridge-edge-loops"),
	("bpy.ops.object.make_dupli_face*", "editors/3dview/object/properties/duplication/duplifaces.html#bpy-ops-object-make-dupli-face"),
	("bpy.ops.object.paths_calculate*", "animation/motion_paths.html#bpy-ops-object-paths-calculate"),
	("bpy.ops.object.select_by_layer*", "editors/3dview/object/selecting/tools.html#bpy-ops-object-select-by-layer"),
	("bpy.ops.object.transform_apply*", "editors/3dview/object/editing/transform/clear_apply.html#bpy-ops-object-transform-apply"),
	("bpy.ops.screen.region_quadview*", "editors/3dview/navigate/views.html#bpy-ops-screen-region-quadview"),
	("bpy.types.colorbalancemodifier*", "editors/vse/sequencer/properties/modifiers.html#bpy-types-colorbalancemodifier"),
	("bpy.types.compositornodefilter*", "compositing/types/filter/filter_node.html#bpy-types-compositornodefilter"),
	("bpy.types.compositornodehuesat*", "compositing/types/color/hue_saturation.html#bpy-types-compositornodehuesat"),
	("bpy.types.compositornodeidmask*", "compositing/types/converter/id_mask.html#bpy-types-compositornodeidmask"),
	("bpy.types.compositornodeinvert*", "compositing/types/color/invert.html#bpy-types-compositornodeinvert"),
	("bpy.types.compositornodekeying*", "compositing/types/matte/keying.html#bpy-types-compositornodekeying"),
	("bpy.types.compositornodelevels*", "compositing/types/output/levels.html#bpy-types-compositornodelevels"),
	("bpy.types.compositornodemixrgb*", "compositing/types/color/mix.html#bpy-types-compositornodemixrgb"),
	("bpy.types.compositornodenormal*", "compositing/types/vector/normal.html#bpy-types-compositornodenormal"),
	("bpy.types.compositornoderotate*", "compositing/types/distort/rotate.html#bpy-types-compositornoderotate"),
	("bpy.types.compositornodeviewer*", "compositing/types/output/viewer.html#bpy-types-compositornodeviewer"),
	("bpy.types.constraint.influence*", "rigging/constraints/interface/common.html#bpy-types-constraint-influence"),
	("bpy.types.controlfluidsettings*", "physics/fluid/types/control.html#bpy-types-controlfluidsettings"),
	("bpy.types.cyclesrendersettings*", "render/cycles/settings/index.html#bpy-types-cyclesrendersettings"),
	("bpy.types.datatransfermodifier*", "modeling/modifiers/modify/data_transfer.html#bpy-types-datatransfermodifier"),
	("bpy.types.dynamicpaintmodifier*", "physics/dynamic_paint/index.html#bpy-types-dynamicpaintmodifier"),
	("bpy.types.expressioncontroller*", "game_engine/logic/controllers/types/expression.html#bpy-types-expressioncontroller"),
	("bpy.types.ffmpegsettings.audio*", "render/output/video.html#bpy-types-ffmpegsettings-audio"),
	("bpy.types.followpathconstraint*", "rigging/constraints/relationship/follow_path.html#bpy-types-followpathconstraint"),
	("bpy.types.gaussianblursequence*", "editors/vse/sequencer/strips/effects/blur.html#bpy-types-gaussianblursequence"),
	("bpy.types.limitscaleconstraint*", "rigging/constraints/transform/limit_scale.html#bpy-types-limitscaleconstraint"),
	("bpy.types.outflowfluidsettings*", "physics/fluid/types/flow.html#bpy-types-outflowfluidsettings"),
	("bpy.types.scene.background_set*", "data_system/scenes/properties.html#bpy-types-scene-background-set"),
	("bpy.types.shadernodebackground*", "render/cycles/nodes/types/shaders/background.html#bpy-types-shadernodebackground"),
	("bpy.types.shadernodebsdfglossy*", "render/cycles/nodes/types/shaders/glossy.html#bpy-types-shadernodebsdfglossy"),
	("bpy.types.shadernodebsdfvelvet*", "render/cycles/nodes/types/shaders/velvet.html#bpy-types-shadernodebsdfvelvet"),
	("bpy.types.shadernodecameradata*", "render/cycles/nodes/types/input/camera_data.html#bpy-types-shadernodecameradata"),
	("bpy.types.shadernodeobjectinfo*", "render/cycles/nodes/types/input/object_info.html#bpy-types-shadernodeobjectinfo"),
	("bpy.types.shadernodeoutputlamp*", "render/cycles/nodes/types/output/lamp.html#bpy-types-shadernodeoutputlamp"),
	("bpy.types.shadernodetexchecker*", "render/cycles/nodes/types/textures/checker.html#bpy-types-shadernodetexchecker"),
	("bpy.types.shadernodetexvoronoi*", "render/cycles/nodes/types/textures/voronoi.html#bpy-types-shadernodetexvoronoi"),
	("bpy.types.shadernodevectormath*", "render/cycles/nodes/types/converter/vector_math.html#bpy-types-shadernodevectormath"),
	("bpy.types.shadernodewavelength*", "render/cycles/nodes/types/converter/wavelength.html#bpy-types-shadernodewavelength"),
	("bpy.types.shrinkwrapconstraint*", "rigging/constraints/relationship/shrinkwrap.html#bpy-types-shrinkwrapconstraint"),
	("bpy.types.simpledeformmodifier*", "modeling/modifiers/deform/simple_deform.html#bpy-types-simpledeformmodifier"),
	("bpy.types.spacedopesheeteditor*", "editors/dope_sheet/index.html#bpy-types-spacedopesheeteditor"),
	("bpy.types.spaceuserpreferences*", "preferences/index.html#bpy-types-spaceuserpreferences"),
	("bpy.types.speedcontrolsequence*", "editors/vse/sequencer/strips/effects/speed_control.html#bpy-types-speedcontrolsequence"),
	("bpy.types.texturenodecurvetime*", "render/blender_render/textures/nodes/types/input/time.html#bpy-types-texturenodecurvetime"),
	("bpy.types.transformorientation*", "editors/3dview/object/editing/transform/control/orientations.html#bpy-types-transformorientation"),
	("bpy.types.userpreferencesinput*", "preferences/input.html#bpy-types-userpreferencesinput"),
	("bpy.types.whitebalancemodifier*", "editors/vse/sequencer/properties/modifiers.html#bpy-types-whitebalancemodifier"),
	("bpy.ops.object.duplicate_move*", "editors/3dview/object/editing/duplication.html#bpy-ops-object-duplicate-move"),
	("bpy.ops.object.select_by_type*", "editors/3dview/object/selecting/tools.html#bpy-ops-object-select-by-type"),
	("bpy.ops.object.select_grouped*", "editors/3dview/object/selecting/tools.html#bpy-ops-object-select-grouped"),
	("bpy.ops.object.select_pattern*", "editors/3dview/object/selecting/tools.html#bpy-ops-object-select-pattern"),
	("bpy.ops.screen.repeat_history*", "interface/undo_redo.html#bpy-ops-screen-repeat-history"),
	("bpy.ops.uv.seams_from_islands*", "editors/uv_image/uv/editing/unwrapping/seams.html#bpy-ops-uv-seams-from-islands"),
	("bpy.types.compositornodedblur*", "compositing/types/filter/directional_blur.html#bpy-types-compositornodedblur"),
	("bpy.types.compositornodegamma*", "compositing/types/color/gamma.html#bpy-types-compositornodegamma"),
	("bpy.types.compositornodeglare*", "compositing/types/filter/glare.html#bpy-types-compositornodeglare"),
	("bpy.types.compositornodegroup*", "compositing/types/groups.html#bpy-types-compositornodegroup"),
	("bpy.types.compositornodeimage*", "compositing/types/input/image.html#bpy-types-compositornodeimage"),
	("bpy.types.compositornodemapuv*", "compositing/types/distort/map_uv.html#bpy-types-compositornodemapuv"),
	("bpy.types.compositornodescale*", "compositing/types/distort/scale.html#bpy-types-compositornodescale"),
	("bpy.types.compositornodevalue*", "compositing/types/input/value.html#bpy-types-compositornodevalue"),
	("bpy.types.copyscaleconstraint*", "rigging/constraints/transform/copy_scale.html#bpy-types-copyscaleconstraint"),
	("bpy.types.cyclesworldsettings*", "render/cycles/world.html#bpy-types-cyclesworldsettings"),
	("bpy.types.domainfluidsettings*", "physics/fluid/types/domain.html#bpy-types-domainfluidsettings"),
	("bpy.types.imageformatsettings*", "data_system/files/media/image_formats.html#bpy-types-imageformatsettings"),
	("bpy.types.inflowfluidsettings*", "physics/fluid/types/flow.html#bpy-types-inflowfluidsettings"),
	("bpy.types.kinematicconstraint*", "rigging/constraints/tracking/ik_solver.html#bpy-types-kinematicconstraint"),
	("bpy.types.movietrackingcamera*", "editors/movie_clip_editor/tracking/clip/properties/camera_data.html#bpy-types-movietrackingcamera"),
	("bpy.types.object.dupli_frames*", "editors/3dview/object/properties/duplication/dupliframes.html#bpy-types-object-dupli-frames"),
	("bpy.types.particledupliweight*", "physics/particles/emitter/vertex_groups.html#bpy-types-particledupliweight"),
	("bpy.types.poseboneconstraints*", "rigging/armatures/posing/bone_constraints/index.html#bpy-types-poseboneconstraints"),
	("bpy.types.rigidbodyconstraint*", "physics/rigid_body/constraints/index.html#bpy-types-rigidbodyconstraint"),
	("bpy.types.shadernodeaddshader*", "render/cycles/nodes/types/shaders/add.html#bpy-types-shadernodeaddshader"),
	("bpy.types.shadernodeattribute*", "render/cycles/nodes/types/input/attribute.html#bpy-types-shadernodeattribute"),
	("bpy.types.shadernodeblackbody*", "render/cycles/nodes/types/converter/blackbody.html#bpy-types-shadernodeblackbody"),
	("bpy.types.shadernodebsdfglass*", "render/cycles/nodes/types/shaders/glass.html#bpy-types-shadernodebsdfglass"),
	("bpy.types.shadernodelightpath*", "render/cycles/nodes/types/input/light_path.html#bpy-types-shadernodelightpath"),
	("bpy.types.shadernodemixshader*", "render/cycles/nodes/types/shaders/mix.html#bpy-types-shadernodemixshader"),
	("bpy.types.shadernodenormalmap*", "render/cycles/nodes/types/vector/normal_map.html#bpy-types-shadernodenormalmap"),
	("bpy.types.shadernodewireframe*", "render/cycles/nodes/types/input/wireframe.html#bpy-types-shadernodewireframe"),
	("bpy.types.smokedomainsettings*", "physics/smoke/types/domain.html#bpy-types-smokedomainsettings"),
	("bpy.types.spacesequenceeditor*", "editors/vse/index.html#bpy-types-spacesequenceeditor"),
	("bpy.types.stretchtoconstraint*", "rigging/constraints/tracking/stretch_to.html#bpy-types-stretchtoconstraint"),
	("bpy.types.texturenodecurvergb*", "render/blender_render/textures/nodes/types/color/rgb_curves.html#bpy-types-texturenodecurvergb"),
	("bpy.types.texturenodevaltorgb*", "render/blender_render/textures/nodes/types/converter/rgb_to_bw.html#bpy-types-texturenodevaltorgb"),
	("bpy.types.transformconstraint*", "rigging/constraints/transform/transformation.html#bpy-types-transformconstraint"),
	("bpy.types.triangulatemodifier*", "modeling/modifiers/generate/triangulate.html#bpy-types-triangulatemodifier"),
	("bpy.types.userpreferencesedit*", "preferences/editing.html#bpy-types-userpreferencesedit"),
	("bpy.types.userpreferencesview*", "preferences/interface.html#bpy-types-userpreferencesview"),
	("bpy.ops.anim.keyframe_delete*", "animation/keyframes/editing.html#bpy-ops-anim-keyframe-delete"),
	("bpy.ops.anim.keyframe_insert*", "animation/keyframes/editing.html#bpy-ops-anim-keyframe-insert"),
	("bpy.ops.mesh.vertices_smooth*", "modeling/meshes/editing/transform/smooth.html#bpy-ops-mesh-vertices-smooth"),
	("bpy.ops.object.data_transfer*", "modeling/meshes/editing/data_transfer.html#bpy-ops-object-data-transfer"),
	("bpy.ops.object.move_to_layer*", "editors/3dview/object/properties/relations/layers.html#bpy-ops-object-move-to-layer"),
	("bpy.ops.object.select_camera*", "editors/3dview/object/selecting/tools.html#bpy-ops-object-select-camera"),
	("bpy.ops.object.select_linked*", "editors/3dview/object/selecting/tools.html#bpy-ops-object-select-linked"),
	("bpy.ops.object.select_mirror*", "editors/3dview/object/selecting/tools.html#bpy-ops-object-select-mirror"),
	("bpy.ops.object.select_random*", "editors/3dview/object/selecting/tools.html#bpy-ops-object-select-random"),
	("bpy.ops.sound.bake_animation*", "data_system/scenes/properties.html#bpy-ops-sound-bake-animation"),
	("bpy.ops.transform.edge_slide*", "modeling/meshes/editing/edges.html#bpy-ops-transform-edge-slide"),
	("bpy.ops.transform.vert_slide*", "modeling/meshes/editing/vertices.html#bpy-ops-transform-vert-slide"),
	("bpy.ops.view3d.select_border*", "editors/3dview/object/selecting/tools.html#bpy-ops-view3d-select-border"),
	("bpy.ops.view3d.select_circle*", "editors/3dview/object/selecting/tools.html#bpy-ops-view3d-select-circle"),
	("bpy.types.adjustmentsequence*", "editors/vse/sequencer/strips/effects/adjustment.html#bpy-types-adjustmentsequence"),
	("bpy.types.alphaundersequence*", "editors/vse/sequencer/strips/effects/alpha_over_under_overdrop.html#bpy-types-alphaundersequence"),
	("bpy.types.compositornodeblur*", "compositing/types/filter/blur_node.html#bpy-types-compositornodeblur"),
	("bpy.types.compositornodecomb*", "render/blender_render/textures/nodes/types/color/combine_separate.html#bpy-types-compositornodecomb"),
	("bpy.types.compositornodecrop*", "compositing/types/distort/crop.html#bpy-types-compositornodecrop"),
	("bpy.types.compositornodeflip*", "compositing/types/distort/flip.html#bpy-types-compositornodeflip"),
	("bpy.types.compositornodemask*", "compositing/types/input/mask.html#bpy-types-compositornodemask"),
	("bpy.types.compositornodemath*", "compositing/types/converter/math.html#bpy-types-compositornodemath"),
	("bpy.types.compositornodetime*", "compositing/types/input/time.html#bpy-types-compositornodetime"),
	("bpy.types.constraintactuator*", "game_engine/logic/actuators/types/constraint.html#bpy-types-constraintactuator"),
	("bpy.types.editobjectactuator*", "game_engine/logic/actuators/types/edit_object.html#bpy-types-editobjectactuator"),
	("bpy.types.fluidfluidsettings*", "physics/fluid/types/fluid_object.html#bpy-types-fluidfluidsettings"),
	("bpy.types.fmodifiergenerator*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifiergenerator"),
	("bpy.types.freestylelinestyle*", "render/freestyle/parameter_editor/line_style/index.html#bpy-types-freestylelinestyle"),
	("bpy.types.gammacrosssequence*", "editors/vse/sequencer/strips/effects/cross.html#bpy-types-gammacrosssequence"),
	("bpy.types.huecorrectmodifier*", "editors/vse/sequencer/properties/modifiers.html#bpy-types-huecorrectmodifier"),
	("bpy.types.meshdeformmodifier*", "modeling/modifiers/deform/mesh_deform.html#bpy-types-meshdeformmodifier"),
	("bpy.types.movietrackingtrack*", "editors/movie_clip_editor/tracking/clip/properties/introduction.html#bpy-types-movietrackingtrack"),
	("bpy.types.nodeoutputfileslot*", "compositing/types/output/file.html#bpy-types-nodeoutputfileslot"),
	("bpy.types.normaleditmodifier*", "modeling/modifiers/modify/normal_edit.html#bpy-types-normaleditmodifier"),
	("bpy.types.object.dupli_group*", "editors/3dview/object/properties/duplication/dupligroup.html#bpy-types-object-dupli-group"),
	("bpy.types.scene.audio_volume*", "data_system/scenes/properties.html#bpy-types-scene-audio-volume"),
	("bpy.types.shadernodebsdfhair*", "render/cycles/nodes/types/shaders/hair.html#bpy-types-shadernodebsdfhair"),
	("bpy.types.shadernodebsdftoon*", "render/cycles/nodes/types/shaders/toon.html#bpy-types-shadernodebsdftoon"),
	("bpy.types.shadernodeemission*", "render/cycles/nodes/types/shaders/emission.html#bpy-types-shadernodeemission"),
	("bpy.types.shadernodegeometry*", "render/cycles/nodes/types/input/geometry.html#bpy-types-shadernodegeometry"),
	("bpy.types.shadernodehairinfo*", "render/cycles/nodes/types/input/hair_info.html#bpy-types-shadernodehairinfo"),
	("bpy.types.shadernodergbcurve*", "render/cycles/nodes/types/color/rgb_curves.html#bpy-types-shadernodergbcurve"),
	("bpy.types.shadernodeseparate*", "render/cycles/nodes/types/converter/combine_separate.html#bpy-types-shadernodeseparate"),
	("bpy.types.shadernodetexbrick*", "render/cycles/nodes/types/textures/brick.html#bpy-types-shadernodetexbrick"),
	("bpy.types.shadernodetexcoord*", "render/cycles/nodes/types/input/texture_coordinate.html#bpy-types-shadernodetexcoord"),
	("bpy.types.shadernodeteximage*", "render/cycles/nodes/types/textures/image.html#bpy-types-shadernodeteximage"),
	("bpy.types.shadernodetexmagic*", "render/cycles/nodes/types/textures/magic.html#bpy-types-shadernodetexmagic"),
	("bpy.types.shadernodetexnoise*", "render/cycles/nodes/types/textures/noise.html#bpy-types-shadernodetexnoise"),
	("bpy.types.shrinkwrapmodifier*", "modeling/modifiers/deform/shrinkwrap.html#bpy-types-shrinkwrapmodifier"),
	("bpy.types.splineikconstraint*", "rigging/constraints/tracking/spline_ik.html#bpy-types-splineikconstraint"),
	("bpy.types.texturenodetexture*", "render/blender_render/textures/nodes/types/input/texture.html#bpy-types-texturenodetexture"),
	("bpy.types.visibilityactuator*", "game_engine/logic/actuators/types/visibility.html#bpy-types-visibilityactuator"),
	("bpy.ops.anim.keyframe_clear*", "animation/keyframes/editing.html#bpy-ops-anim-keyframe-clear"),
	("bpy.ops.curve.primitive*add*", "modeling/curves/primitives.html#bpy-ops-curve-primitive-add"),
	("bpy.ops.mesh.duplicate_move*", "modeling/meshes/editing/duplicating/duplicate.html#bpy-ops-mesh-duplicate-move"),
	("bpy.ops.object.parent_clear*", "editors/3dview/object/properties/relations/parents.html#bpy-ops-object-parent-clear"),
	("bpy.ops.object.shade_smooth*", "modeling/meshes/editing/normals.html#bpy-ops-object-shade-smooth"),
	("bpy.ops.transform.push_pull*", "modeling/meshes/editing/transform/push_pull.html#bpy-ops-transform-push-pull"),
	("bpy.ops.transform.transform*", "editors/3dview/object/editing/transform/control/orientations.html#bpy-ops-transform-transform"),
	("bpy.ops.transform.translate*", "editors/3dview/object/editing/transform/basics.html#bpy-ops-transform-translate"),
	("bpy.ops.uv.minimize_stretch*", "editors/uv_image/uv/editing/layout.html#bpy-ops-uv-minimize-stretch"),
	("bpy.ops.view3d.select_lasso*", "editors/3dview/object/selecting/tools.html#bpy-ops-view3d-select-lasso"),
	("bpy.types.alphaoversequence*", "editors/vse/sequencer/strips/effects/alpha_over_under_overdrop.html#bpy-types-alphaoversequence"),
	("bpy.types.armatureeditbones*", "rigging/armatures/bones/editing/index.html#bpy-types-armatureeditbones"),
	("bpy.types.childofconstraint*", "rigging/constraints/relationship/child_of.html#bpy-types-childofconstraint"),
	("bpy.types.clamptoconstraint*", "rigging/constraints/tracking/clamp_to.html#bpy-types-clamptoconstraint"),
	("bpy.types.collisionmodifier*", "physics/collision.html#bpy-types-collisionmodifier"),
	("bpy.types.collisionsettings*", "physics/collision.html#bpy-types-collisionsettings"),
	("bpy.types.compositornodergb*", "compositing/types/input/rgb.html#bpy-types-compositornodergb"),
	("bpy.types.compositornodesep*", "render/blender_render/textures/nodes/types/color/combine_separate.html#bpy-types-compositornodesep"),
	("bpy.types.edgesplitmodifier*", "modeling/modifiers/generate/edge_split.html#bpy-types-edgesplitmodifier"),
	("bpy.types.fmodifierenvelope*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifierenvelope"),
	("bpy.types.freestylesettings*", "render/freestyle/view_map.html#bpy-types-freestylesettings"),
	("bpy.types.material.specular*", "render/blender_render/materials/properties/specular_shaders.html#bpy-types-material-specular"),
	("bpy.types.meshcachemodifier*", "modeling/modifiers/modify/mesh_cache.html#bpy-types-meshcachemodifier"),
	("bpy.types.movieclipsequence*", "editors/vse/sequencer/strips/clip_mask.html#bpy-types-movieclipsequence"),
	("bpy.types.object.dimensions*", "editors/3dview/object/properties/transforms.html#bpy-types-object-dimensions"),
	("bpy.types.object.dupli_type*", "editors/3dview/object/properties/duplication/index.html#bpy-types-object-dupli-type"),
	("bpy.types.object.track_axis*", "editors/3dview/object/properties/relations/extras.html#bpy-types-object-track-axis"),
	("bpy.types.scene.active_clip*", "data_system/scenes/properties.html#bpy-types-scene-active-clip"),
	("bpy.types.shadernodecombine*", "render/cycles/nodes/types/converter/combine_separate.html#bpy-types-shadernodecombine"),
	("bpy.types.shadernodefresnel*", "render/cycles/nodes/types/input/fresnel.html#bpy-types-shadernodefresnel"),
	("bpy.types.shadernodeholdout*", "render/cycles/nodes/types/shaders/holdout.html#bpy-types-shadernodeholdout"),
	("bpy.types.shadernodemapping*", "render/cycles/nodes/types/vector/mapping.html#bpy-types-shadernodemapping"),
	("bpy.types.shadernodergbtobw*", "render/cycles/nodes/types/converter/rgb_to_bw.html#bpy-types-shadernodergbtobw"),
	("bpy.types.shadernodetangent*", "render/cycles/nodes/types/input/tangent.html#bpy-types-shadernodetangent"),
	("bpy.types.shadernodetexwave*", "render/cycles/nodes/types/textures/wave.html#bpy-types-shadernodetexwave"),
	("bpy.types.smokecollsettings*", "physics/smoke/types/collision.html#bpy-types-smokecollsettings"),
	("bpy.types.smokeflowsettings*", "physics/smoke/types/flow_object.html#bpy-types-smokeflowsettings"),
	("bpy.types.texturenodebricks*", "render/blender_render/textures/nodes/types/patterns/bricks.html#bpy-types-texturenodebricks"),
	("bpy.types.texturenodemixrgb*", "render/blender_render/textures/nodes/types/color/mix_rgb.html#bpy-types-texturenodemixrgb"),
	("bpy.types.texturenodeoutput*", "render/blender_render/textures/nodes/types/output/output.html#bpy-types-texturenodeoutput"),
	("bpy.types.tracktoconstraint*", "rigging/constraints/tracking/track_to.html#bpy-types-tracktoconstraint"),
	("bpy.types.transformsequence*", "editors/vse/sequencer/strips/effects/transform.html#bpy-types-transformsequence"),
	("bpy.types.uvprojectmodifier*", "modeling/modifiers/modify/uv_project.html#bpy-types-uvprojectmodifier"),
	("bpy.types.wireframemodifier*", "modeling/modifiers/generate/wireframe.html#bpy-types-wireframemodifier"),
	("bpy.types.worldmistsettings*", "render/blender_render/world/mist.html#bpy-types-worldmistsettings"),
	("bpy.ops.mesh.loopcut_slide*", "modeling/meshes/editing/subdividing/loop.html#bpy-ops-mesh-loopcut-slide"),
	("bpy.ops.mesh.primitive*add*", "modeling/meshes/primitives.html#bpy-ops-mesh-primitive-add"),
	("bpy.ops.object.join_shapes*", "animation/shape_keys/shape_keys_panel.html#bpy-ops-object-join-shapes"),
	("bpy.ops.object.select_less*", "editors/3dview/object/selecting/tools.html#bpy-ops-object-select-less"),
	("bpy.ops.object.select_more*", "editors/3dview/object/selecting/tools.html#bpy-ops-object-select-more"),
	("bpy.ops.object.track_clear*", "rigging/constraints/interface/adding_removing.html#bpy-ops-object-track-clear"),
	("bpy.ops.screen.repeat_last*", "interface/undo_redo.html#bpy-ops-screen-repeat-last"),
	("bpy.ops.transform.tosphere*", "modeling/meshes/editing/transform/to_sphere.html#bpy-ops-transform-tosphere"),
	("bpy.types.actionconstraint*", "rigging/constraints/relationship/action.html#bpy-types-actionconstraint"),
	("bpy.types.addonpreferences*", "preferences/addons.html#bpy-types-addonpreferences"),
	("bpy.types.armatureactuator*", "game_engine/logic/actuators/types/armature.html#bpy-types-armatureactuator"),
	("bpy.types.armaturemodifier*", "modeling/modifiers/deform/armature.html#bpy-types-armaturemodifier"),
	("bpy.types.decimatemodifier*", "modeling/modifiers/generate/decimate.html#bpy-types-decimatemodifier"),
	("bpy.types.displacemodifier*", "modeling/modifiers/deform/displace.html#bpy-types-displacemodifier"),
	("bpy.types.displaysafeareas*", "render/blender_render/camera/object_data.html#bpy-types-displaysafeareas"),
	("bpy.types.filter2dactuator*", "game_engine/logic/actuators/types/filter_2d.html#bpy-types-filter2dactuator"),
	("bpy.types.fmodifierstepped*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifierstepped"),
	("bpy.types.freestylelineset*", "render/freestyle/parameter_editor/line_set.html#bpy-types-freestylelineset"),
	("bpy.types.material.ambient*", "render/blender_render/materials/properties/shading.html#bpy-types-material-ambient"),
	("bpy.types.material.diffuse*", "render/blender_render/materials/properties/diffuse_shaders.html#bpy-types-material-diffuse"),
	("bpy.types.multicamsequence*", "editors/vse/sequencer/strips/effects/multicam.html#bpy-types-multicamsequence"),
	("bpy.types.multiplysequence*", "editors/vse/sequencer/strips/effects/multiply.html#bpy-types-multiplysequence"),
	("bpy.types.multiresmodifier*", "modeling/modifiers/generate/multiresolution.html#bpy-types-multiresmodifier"),
	("bpy.types.object.draw_type*", "editors/3dview/object/properties/display.html#bpy-types-object-draw-type"),
	("bpy.types.object.use_extra*", "editors/3dview/object/properties/relations/extras.html#bpy-types-object-use-extra"),
	("bpy.types.overdropsequence*", "editors/vse/sequencer/strips/effects/alpha_over_under_overdrop.html#bpy-types-overdropsequence"),
	("bpy.types.particlesettings*", "physics/particles/index.html#bpy-types-particlesettings"),
	("bpy.types.propertyactuator*", "game_engine/logic/actuators/types/property.html#bpy-types-propertyactuator"),
	("bpy.types.pythoncontroller*", "game_engine/logic/controllers/types/python.html#bpy-types-pythoncontroller"),
	("bpy.types.scenerenderlayer*", "render/cycles/settings/scene/render_layers/layers.html#bpy-types-scenerenderlayer"),
	("bpy.types.sequencemodifier*", "editors/vse/sequencer/properties/modifiers.html#bpy-types-sequencemodifier"),
	("bpy.types.shadernodeinvert*", "render/cycles/nodes/types/color/invert.html#bpy-types-shadernodeinvert"),
	("bpy.types.shadernodemixrgb*", "render/cycles/nodes/types/color/mix.html#bpy-types-shadernodemixrgb"),
	("bpy.types.shadernodenormal*", "render/cycles/nodes/types/vector/normal.html#bpy-types-shadernodenormal"),
	("bpy.types.shadernodescript*", "render/cycles/nodes/types/script.html#bpy-types-shadernodescript"),
	("bpy.types.shadernodetexsky*", "render/cycles/nodes/types/textures/sky.html#bpy-types-shadernodetexsky"),
	("bpy.types.softbodymodifier*", "physics/soft_body/index.html#bpy-types-softbodymodifier"),
	("bpy.types.softbodysettings*", "physics/soft_body/settings.html#bpy-types-softbodysettings"),
	("bpy.types.solidifymodifier*", "modeling/modifiers/generate/solidify.html#bpy-types-solidifymodifier"),
	("bpy.types.spacefilebrowser*", "editors/file_browser/index.html#bpy-types-spacefilebrowser"),
	("bpy.types.spacegrapheditor*", "editors/graph_editor/index.html#bpy-types-spacegrapheditor"),
	("bpy.types.spaceimageeditor*", "editors/uv_image/image/index.html#bpy-types-spaceimageeditor"),
	("bpy.types.spacelogiceditor*", "editors/logic_editor.html#bpy-types-spacelogiceditor"),
	("bpy.types.sphfluidsettings*", "physics/fluid/index.html#bpy-types-sphfluidsettings"),
	("bpy.types.steeringactuator*", "game_engine/logic/actuators/types/steering.html#bpy-types-steeringactuator"),
	("bpy.types.subtractsequence*", "editors/vse/sequencer/strips/effects/subtract.html#bpy-types-subtractsequence"),
	("bpy.types.texturenodegroup*", "render/blender_render/textures/nodes/types/groups.html#bpy-types-texturenodegroup"),
	("bpy.types.texturenodeimage*", "render/blender_render/textures/nodes/types/input/image.html#bpy-types-texturenodeimage"),
	("bpy.types.voxeldatatexture*", "render/blender_render/textures/types/volume/voxel_data.html#bpy-types-voxeldatatexture"),
	("bpy.types.worldlighting.ao*", "render/blender_render/world/ambient_occlusion.html#bpy-types-worldlighting-ao"),
	("bpy.types.worldtextureslot*", "render/blender_render/world/world_panel.html#bpy-types-worldtextureslot"),
	("bpy.ops.object.*shape_key*", "animation/shape_keys/index.html#bpy-ops-object-shape-key"),
	("bpy.ops.object.make_links*", "data_system/linked_libraries.html#bpy-ops-object-make-links"),
	("bpy.ops.object.make_local*", "data_system/linked_libraries.html#bpy-ops-object-make-local"),
	("bpy.ops.object.origin_set*", "editors/3dview/object/origin.html#bpy-ops-object-origin-set"),
	("bpy.ops.object.parent_set*", "editors/3dview/object/properties/relations/parents.html#bpy-ops-object-parent-set"),
	("bpy.ops.object.proxy_make*", "data_system/linked_libraries.html#bpy-ops-object-proxy-make"),
	("bpy.ops.object.select_all*", "editors/3dview/object/selecting/tools.html#bpy-ops-object-select-all"),
	("bpy.ops.object.shade_flat*", "modeling/meshes/editing/normals.html#bpy-ops-object-shade-flat"),
	("bpy.ops.screen.area_dupli*", "interface/window_system/areas.html#bpy-ops-screen-area-dupli"),
	("bpy.ops.uv.remove_doubles*", "editors/uv_image/uv/editing/layout.html#bpy-ops-uv-remove-doubles"),
	("bpy.types.backgroundimage*", "editors/3dview/properties/background_images.html#bpy-types-backgroundimage"),
	("bpy.types.booleanmodifier*", "modeling/modifiers/generate/booleans.html#bpy-types-booleanmodifier"),
	("bpy.types.collisionsensor*", "game_engine/logic/sensors/types/collision.html#bpy-types-collisionsensor"),
	("bpy.types.constraint.mute*", "rigging/constraints/interface/header.html#bpy-types-constraint-mute"),
	("bpy.types.explodemodifier*", "modeling/modifiers/simulate/explode.html#bpy-types-explodemodifier"),
	("bpy.types.fcurvemodifiers*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fcurvemodifiers"),
	("bpy.types.floorconstraint*", "rigging/constraints/relationship/floor.html#bpy-types-floorconstraint"),
	("bpy.types.fluidmeshvertex*", "physics/fluid/index.html#bpy-types-fluidmeshvertex"),
	("bpy.types.fmodifiercycles*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifiercycles"),
	("bpy.types.fmodifierlimits*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifierlimits"),
	("bpy.types.gpussaosettings*", "editors/3dview/properties/shading.html#bpy-types-gpussaosettings"),
	("bpy.types.latticemodifier*", "modeling/modifiers/deform/lattice.html#bpy-types-latticemodifier"),
	("bpy.types.messageactuator*", "game_engine/logic/actuators/types/message.html#bpy-types-messageactuator"),
	("bpy.types.musgravetexture*", "render/blender_render/textures/types/procedural/musgrave.html#bpy-types-musgravetexture"),
	("bpy.types.object.location*", "editors/3dview/object/properties/transforms.html#bpy-types-object-location"),
	("bpy.types.object.rotation*", "editors/3dview/object/properties/transforms.html#bpy-types-object-rotation"),
	("bpy.types.particlehairkey*", "physics/particles/emitter/physics/keyed.html#bpy-types-particlehairkey"),
	("bpy.types.pivotconstraint*", "rigging/constraints/relationship/pivot.html#bpy-types-pivotconstraint"),
	("bpy.types.rigidbodyobject*", "physics/rigid_body/index.html#bpy-types-rigidbodyobject"),
	("bpy.types.shadernodebevel*", "render/cycles/nodes/types/input/bevel.html#bpy-types-shadernodebevel"),
	("bpy.types.shadernodegamma*", "render/cycles/nodes/types/color/gamma.html#bpy-types-shadernodegamma"),
	("bpy.types.shadernodegroup*", "render/cycles/nodes/types/groups.html#bpy-types-shadernodegroup"),
	("bpy.types.shadernodeuvmap*", "render/cycles/nodes/types/input/uv_map.html#bpy-types-shadernodeuvmap"),
	("bpy.types.shadernodevalue*", "render/cycles/nodes/types/input/value.html#bpy-types-shadernodevalue"),
	("bpy.types.spaceclipeditor*", "editors/movie_clip_editor/index.html#bpy-types-spaceclipeditor"),
	("bpy.types.spacenodeeditor*", "editors/node_editor/index.html#bpy-types-spacenodeeditor"),
	("bpy.types.spaceproperties*", "editors/properties_editor.html#bpy-types-spaceproperties"),
	("bpy.types.spacetexteditor*", "editors/text_editor.html#bpy-types-spacetexteditor"),
	("bpy.types.subsurfmodifier*", "modeling/modifiers/generate/subsurf.html#bpy-types-subsurfmodifier"),
	("bpy.types.texturenodemath*", "render/blender_render/textures/nodes/types/converter/math.html#bpy-types-texturenodemath"),
	("bpy.types.userpreferences*", "preferences/index.html#bpy-types-userpreferences"),
	("bpy.ops.object.hide_view*", "editors/3dview/object/editing/introduction.html#bpy-ops-object-hide-view"),
	("bpy.ops.object.track_set*", "rigging/constraints/interface/adding_removing.html#bpy-ops-object-track-set"),
	("bpy.ops.transform.mirror*", "editors/3dview/object/editing/transform/mirror.html#bpy-ops-transform-mirror"),
	("bpy.ops.transform.resize*", "editors/3dview/object/editing/transform/basics.html#bpy-ops-transform-resize"),
	("bpy.ops.transform.rotate*", "editors/3dview/object/editing/transform/basics.html#bpy-ops-transform-rotate"),
	("bpy.ops.view3d.localview*", "editors/3dview/navigate/views.html#bpy-ops-view3d-localview"),
	("bpy.types.actionactuator*", "game_engine/logic/actuators/types/action.html#bpy-types-actionactuator"),
	("bpy.types.actuatorsensor*", "game_engine/logic/sensors/types/actuator.html#bpy-types-actuatorsensor"),
	("bpy.types.armaturesensor*", "game_engine/logic/sensors/types/armature.html#bpy-types-armaturesensor"),
	("bpy.types.cameraactuator*", "game_engine/logic/actuators/types/camera.html#bpy-types-cameraactuator"),
	("bpy.types.curvesmodifier*", "editors/vse/sequencer/properties/modifiers.html#bpy-types-curvesmodifier"),
	("bpy.types.effectsequence*", "editors/vse/sequencer/properties/filter.html#bpy-types-effectsequence"),
	("bpy.types.ffmpegsettings*", "render/output/video.html#bpy-types-ffmpegsettings"),
	("bpy.types.fmodifiernoise*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifiernoise"),
	("bpy.types.gpudofsettings*", "editors/3dview/properties/shading.html#bpy-types-gpudofsettings"),
	("bpy.types.joysticksensor*", "game_engine/logic/sensors/types/joystick.html#bpy-types-joysticksensor"),
	("bpy.types.keyboardsensor*", "game_engine/logic/sensors/types/keyboard.html#bpy-types-keyboardsensor"),
	("bpy.types.materialstrand*", "render/blender_render/materials/properties/strands.html#bpy-types-materialstrand"),
	("bpy.types.materialvolume*", "render/blender_render/materials/special_effects/volume.html#bpy-types-materialvolume"),
	("bpy.types.mirrormodifier*", "modeling/modifiers/generate/mirror.html#bpy-types-mirrormodifier"),
	("bpy.types.movieclipproxy*", "editors/movie_clip_editor/properties/proxy.html#bpy-types-movieclipproxy"),
	("bpy.types.object.up_axis*", "editors/3dview/object/properties/relations/extras.html#bpy-types-object-up-axis"),
	("bpy.types.objectactuator*", "game_engine/logic/actuators/types/motion.html#bpy-types-objectactuator"),
	("bpy.types.parentactuator*", "game_engine/logic/actuators/types/parent.html#bpy-types-parentactuator"),
	("bpy.types.particlesystem*", "physics/particles/index.html#bpy-types-particlesystem"),
	("bpy.types.particletarget*", "physics/particles/emitter/physics/keyed.html#bpy-types-particletarget"),
	("bpy.types.propertysensor*", "game_engine/logic/sensors/types/property.html#bpy-types-propertysensor"),
	("bpy.types.randomactuator*", "game_engine/logic/actuators/types/random.html#bpy-types-randomactuator"),
	("bpy.types.remeshmodifier*", "modeling/modifiers/generate/remesh.html#bpy-types-remeshmodifier"),
	("bpy.types.rendersettings*", "render/index.html#bpy-types-rendersettings"),
	("bpy.types.rigidbodyworld*", "physics/rigid_body/world.html#bpy-types-rigidbodyworld"),
	("bpy.types.shadernodebump*", "render/cycles/nodes/types/vector/bump.html#bpy-types-shadernodebump"),
	("bpy.types.shadernodemath*", "render/cycles/nodes/types/converter/math.html#bpy-types-shadernodemath"),
	("bpy.types.smoothmodifier*", "modeling/modifiers/deform/smooth.html#bpy-types-smoothmodifier"),
	("bpy.types.timelinemarker*", "animation/markers.html#bpy-types-timelinemarker"),
	("bpy.types.usersolidlight*", "preferences/system.html#bpy-types-usersolidlight"),
	("bpy.types.uvwarpmodifier*", "modeling/modifiers/modify/uv_warp.html#bpy-types-uvwarpmodifier"),
	("bpy.types.voronoitexture*", "render/blender_render/textures/types/procedural/voronoi.html#bpy-types-voronoitexture"),
	("bpy.types.walknavigation*", "editors/3dview/navigate/walk_fly.html#bpy-types-walknavigation"),
	("bpy.ops.anim.keying_set*", "animation/keyframes/keying_sets.html#bpy-ops-anim-keying-set"),
	("bpy.ops.ed.undo_history*", "interface/undo_redo.html#bpy-ops-ed-undo-history"),
	("bpy.ops.gpencil.convert*", "interface/grease_pencil/convert_to_geometry.html#bpy-ops-gpencil-convert"),
	("bpy.ops.object.armature*", "rigging/armatures/index.html#bpy-ops-object-armature"),
	("bpy.ops.rigidbody.world*", "physics/rigid_body/world.html#bpy-ops-rigidbody-world"),
	("bpy.ops.transform.shear*", "modeling/meshes/editing/transform/shear.html#bpy-ops-transform-shear"),
	("bpy.ops.uv.pack_islands*", "editors/uv_image/uv/editing/layout.html#bpy-ops-uv-pack-islands"),
	("bpy.types.armaturebones*", "rigging/armatures/bones/index.html#bpy-types-armaturebones"),
	("bpy.types.arraymodifier*", "modeling/modifiers/generate/array.html#bpy-types-arraymodifier"),
	("bpy.types.bevelmodifier*", "modeling/modifiers/generate/bevel.html#bpy-types-bevelmodifier"),
	("bpy.types.buildmodifier*", "modeling/modifiers/generate/build.html#bpy-types-buildmodifier"),
	("bpy.types.clothmodifier*", "physics/cloth/index.html#bpy-types-clothmodifier"),
	("bpy.types.clothsettings*", "physics/cloth/settings/cloth_settings.html#bpy-types-clothsettings"),
	("bpy.types.cloudstexture*", "render/blender_render/textures/types/procedural/clouds.html#bpy-types-cloudstexture"),
	("bpy.types.colorsequence*", "editors/vse/sequencer/strips/effects/color.html#bpy-types-colorsequence"),
	("bpy.types.crosssequence*", "editors/vse/sequencer/strips/effects/cross.html#bpy-types-crosssequence"),
	("bpy.types.curvemodifier*", "modeling/modifiers/deform/curve.html#bpy-types-curvemodifier"),
	("bpy.types.fieldsettings*", "physics/force_fields/index.html#bpy-types-fieldsettings"),
	("bpy.types.fluidsettings*", "physics/fluid/index.html#bpy-types-fluidsettings"),
	("bpy.types.gpufxsettings*", "editors/3dview/properties/shading.html#bpy-types-gpufxsettings"),
	("bpy.types.imagesequence*", "editors/vse/sequencer/strips/movie_image.html#bpy-types-imagesequence"),
	("bpy.types.marbletexture*", "render/blender_render/textures/types/procedural/marble.html#bpy-types-marbletexture"),
	("bpy.types.messagesensor*", "game_engine/logic/sensors/types/message.html#bpy-types-messagesensor"),
	("bpy.types.modifier.show*", "modeling/modifiers/introduction.html#bpy-types-modifier-show"),
	("bpy.types.mouseactuator*", "game_engine/logic/actuators/types/mouse.html#bpy-types-mouseactuator"),
	("bpy.types.moviesequence*", "editors/vse/sequencer/strips/movie_image.html#bpy-types-moviesequence"),
	("bpy.types.movietracking*", "editors/movie_clip_editor/tracking/index.html#bpy-types-movietracking"),
	("bpy.types.object.layers*", "editors/3dview/object/properties/relations/layers.html#bpy-types-object-layers"),
	("bpy.types.object.parent*", "editors/3dview/object/properties/relations/parents.html#bpy-types-object-parent"),
	("bpy.types.oceanmodifier*", "modeling/modifiers/simulate/ocean.html#bpy-types-oceanmodifier"),
	("bpy.types.particlebrush*", "physics/particles/mode.html#bpy-types-particlebrush"),
	("bpy.types.scene.gravity*", "physics/gravity.html#bpy-types-scene-gravity"),
	("bpy.types.sceneactuator*", "game_engine/logic/actuators/types/scene.html#bpy-types-sceneactuator"),
	("bpy.types.scenesequence*", "editors/vse/sequencer/strips/scene.html#bpy-types-scenesequence"),
	("bpy.types.screwmodifier*", "modeling/modifiers/generate/screw.html#bpy-types-screwmodifier"),
	("bpy.types.sequenceproxy*", "editors/vse/sequencer/properties/proxy_timecode.html#bpy-types-sequenceproxy"),
	("bpy.types.shadernodergb*", "render/cycles/nodes/types/input/rgb.html#bpy-types-shadernodergb"),
	("bpy.types.smokemodifier*", "physics/smoke/index.html#bpy-types-smokemodifier"),
	("bpy.types.soundactuator*", "game_engine/logic/actuators/types/sound.html#bpy-types-soundactuator"),
	("bpy.types.soundsequence*", "editors/vse/sequencer/strips/sound.html#bpy-types-soundsequence"),
	("bpy.types.spaceoutliner*", "editors/outliner.html#bpy-types-spaceoutliner"),
	("bpy.types.spacetimeline*", "editors/timeline.html#bpy-types-spacetimeline"),
	("bpy.types.spaceuveditor*", "editors/uv_image/uv/index.html#bpy-types-spaceuveditor"),
	("bpy.types.stateactuator*", "game_engine/logic/actuators/types/state.html#bpy-types-stateactuator"),
	("bpy.types.stuccitexture*", "render/blender_render/textures/types/procedural/stucci.html#bpy-types-stuccitexture"),
	("bpy.types.windowmanager*", "interface/index.html#bpy-types-windowmanager"),
	("bpy.types.worldlighting*", "render/blender_render/world/ambient_occlusion.html#bpy-types-worldlighting"),
	("bpy.ops.mesh.subdivide*", "modeling/meshes/editing/subdividing/subdivide.html#bpy-ops-mesh-subdivide"),
	("bpy.ops.object.convert*", "editors/3dview/object/editing/introduction.html#bpy-ops-object-convert"),
	("bpy.ops.object.speaker*", "render/audio/speaker.html#bpy-ops-object-speaker"),
	("bpy.ops.transform.bend*", "modeling/meshes/editing/transform/bend.html#bpy-ops-transform-bend"),
	("bpy.types.alwayssensor*", "game_engine/logic/sensors/types/always.html#bpy-types-alwayssensor"),
	("bpy.types.bakesettings*", "render/cycles/baking.html#bpy-types-bakesettings"),
	("bpy.types.blendtexture*", "render/blender_render/textures/types/procedural/blend.html#bpy-types-blendtexture"),
	("bpy.types.castmodifier*", "modeling/modifiers/deform/cast.html#bpy-types-castmodifier"),
	("bpy.types.colormanaged*", "render/post_process/color_management.html#bpy-types-colormanaged"),
	("bpy.types.gameactuator*", "game_engine/logic/actuators/types/game.html#bpy-types-gameactuator"),
	("bpy.types.glowsequence*", "editors/vse/sequencer/strips/effects/glow.html#bpy-types-glowsequence"),
	("bpy.types.gpencilbrush*", "interface/grease_pencil/drawing/brushes.html#bpy-types-gpencilbrush"),
	("bpy.types.greasepencil*", "interface/grease_pencil/index.html#bpy-types-greasepencil"),
	("bpy.types.hookmodifier*", "modeling/modifiers/deform/hooks.html#bpy-types-hookmodifier"),
	("bpy.types.imagetexture*", "render/blender_render/textures/types/image/index.html#bpy-types-imagetexture"),
	("bpy.types.latticepoint*", "rigging/lattice.html#bpy-types-latticepoint"),
	("bpy.types.magictexture*", "render/blender_render/textures/types/procedural/magic.html#bpy-types-magictexture"),
	("bpy.types.maskmodifier*", "modeling/modifiers/generate/mask.html#bpy-types-maskmodifier"),
	("bpy.types.masksequence*", "editors/vse/sequencer/strips/clip_mask.html#bpy-types-masksequence"),
	("bpy.types.materialhalo*", "render/blender_render/materials/special_effects/halo.html#bpy-types-materialhalo"),
	("bpy.types.metasequence*", "editors/vse/sequencer/meta.html#bpy-types-metasequence"),
	("bpy.types.object.color*", "editors/3dview/object/properties/display.html#bpy-types-object-color"),
	("bpy.types.object.delta*", "editors/3dview/object/properties/transforms.html#bpy-types-object-delta"),
	("bpy.types.object.empty*", "modeling/empties.html#bpy-types-object-empty"),
	("bpy.types.object.scale*", "editors/3dview/object/properties/transforms.html#bpy-types-object-scale"),
	("bpy.types.oceantexture*", "render/blender_render/textures/types/procedural/ocean.html#bpy-types-oceantexture"),
	("bpy.types.particleedit*", "physics/particles/mode.html#bpy-types-particleedit"),
	("bpy.types.randomsensor*", "game_engine/logic/sensors/types/random.html#bpy-types-randomsensor"),
	("bpy.types.scene.camera*", "data_system/scenes/properties.html#bpy-types-scene-camera"),
	("bpy.types.sequencecrop*", "editors/vse/sequencer/properties/input.html#bpy-types-sequencecrop"),
	("bpy.types.skinmodifier*", "modeling/modifiers/generate/skin.html#bpy-types-skinmodifier"),
	("bpy.types.spaceconsole*", "editors/python_console.html#bpy-types-spaceconsole"),
	("bpy.types.textsequence*", "editors/vse/sequencer/strips/effects/text.html#bpy-types-textsequence"),
	("bpy.types.unitsettings*", "data_system/scenes/properties.html#bpy-types-unitsettings"),
	("bpy.types.vertexcolors*", "sculpt_paint/painting/vertex_paint/index.html#bpy-types-vertexcolors"),
	("bpy.types.warpmodifier*", "modeling/modifiers/deform/warp.html#bpy-types-warpmodifier"),
	("bpy.types.wavemodifier*", "modeling/modifiers/deform/wave.html#bpy-types-wavemodifier"),
	("bpy.types.wipesequence*", "editors/vse/sequencer/strips/effects/wipe.html#bpy-types-wipesequence"),
	("bpy.ops.object.*clear*", "editors/3dview/object/editing/transform/clear_apply.html#bpy-ops-object-clear"),
	("bpy.ops.object.camera*", "render/blender_render/camera/index.html#bpy-ops-object-camera"),
	("bpy.ops.object.delete*", "editors/3dview/object/editing/introduction.html#bpy-ops-object-delete"),
	("bpy.ops.object.select*", "editors/3dview/object/selecting/index.html#bpy-ops-object-select"),
	("bpy.ops.wm.properties*", "data_system/custom_properties.html#bpy-ops-wm-properties"),
	("bpy.types.addsequence*", "editors/vse/sequencer/strips/effects/add.html#bpy-types-addsequence"),
	("bpy.types.consoleline*", "editors/python_console.html#bpy-types-consoleline"),
	("bpy.types.delaysensor*", "game_engine/logic/sensors/types/delay.html#bpy-types-delaysensor"),
	("bpy.types.meshstatvis*", "modeling/meshes/mesh_analysis.html#bpy-types-meshstatvis"),
	("bpy.types.mousesensor*", "game_engine/logic/sensors/types/mouse.html#bpy-types-mousesensor"),
	("bpy.types.nodesetting*", "editors/node_editor/nodes/parts.html#bpy-types-nodesetting"),
	("bpy.types.object.lock*", "editors/3dview/object/properties/transforms.html#bpy-types-object-lock"),
	("bpy.types.object.show*", "editors/3dview/object/properties/display.html#bpy-types-object-show"),
	("bpy.types.particlekey*", "physics/particles/emitter/physics/keyed.html#bpy-types-particlekey"),
	("bpy.types.radarsensor*", "game_engine/logic/sensors/types/radar.html#bpy-types-radarsensor"),
	("bpy.types.renderlayer*", "render/post_process/layers.html#bpy-types-renderlayer"),
	("bpy.types.spaceview3d*", "editors/3dview/index.html#bpy-types-spaceview3d"),
	("bpy.types.uipopupmenu*", "interface/controls/buttons/menus.html#bpy-types-uipopupmenu"),
	("bpy.types.vertexpaint*", "sculpt_paint/painting/vertex_paint/index.html#bpy-types-vertexpaint"),
	("bpy.types.woodtexture*", "render/blender_render/textures/types/procedural/wood.html#bpy-types-woodtexture"),
	("bpy.ops.gpencil.draw*", "interface/grease_pencil/drawing/introduction.html#bpy-ops-gpencil-draw"),
	("bpy.ops.material.new*", "render/blender_render/materials/assigning_a_material.html#bpy-ops-material-new"),
	("bpy.ops.object.align*", "editors/3dview/object/editing/transform/tools.html#bpy-ops-object-align"),
	("bpy.ops.object.empty*", "modeling/empties.html#bpy-ops-object-empty"),
	("bpy.ops.object.quick*", "physics/introduction.html#bpy-ops-object-quick"),
	("bpy.ops.uv.mark_seam*", "editors/uv_image/uv/editing/unwrapping/seams.html#bpy-ops-uv-mark-seam"),
	("bpy.ops.view3d.ruler*", "interface/ruler_protractor.html#bpy-ops-view3d-ruler"),
	("bpy.types.areaspaces*", "interface/window_system/areas.html#bpy-types-areaspaces"),
	("bpy.types.bpy_struct*", "data_system/custom_properties.html#bpy-types-bpy-struct"),
	("bpy.types.compositor*", "compositing/index.html#bpy-types-compositor"),
	("bpy.types.constraint*", "rigging/constraints/index.html#bpy-types-constraint"),
	("bpy.types.controller*", "game_engine/logic/controllers/index.html#bpy-types-controller"),
	("bpy.types.nearsensor*", "game_engine/logic/sensors/types/near.html#bpy-types-nearsensor"),
	("bpy.types.nodesocket*", "editors/node_editor/nodes/parts.html#bpy-types-nodesocket"),
	("bpy.types.pointcache*", "physics/baking.html#bpy-types-pointcache"),
	("bpy.types.renderpass*", "render/blender_render/settings/passes.html#bpy-types-renderpass"),
	("bpy.types.renderview*", "render/workflows/multiview/index.html#bpy-types-renderview"),
	("bpy.types.shadernode*", "render/cycles/nodes/index.html#bpy-types-shadernode"),
	("bpy.types.vectorfont*", "modeling/texts/index.html#bpy-types-vectorfont"),
	("bpy.ops.mesh.bisect*", "modeling/meshes/editing/subdividing/bisect.html#bpy-ops-mesh-bisect"),
	("bpy.ops.object.join*", "editors/3dview/object/editing/introduction.html#bpy-ops-object-join"),
	("bpy.ops.object.text*", "modeling/texts/index.html#bpy-ops-object-text"),
	("bpy.ops.view3d.snap*", "editors/3dview/object/editing/transform/control/snap.html#bpy-ops-view3d-snap"),
	("bpy.ops.view3d.view*", "editors/3dview/navigate/introduction.html#bpy-ops-view3d-view"),
	("bpy.types.blenddata*", "data_system/data_blocks.html#bpy-types-blenddata"),
	("bpy.types.colorramp*", "interface/controls/templates/color_ramp.html#bpy-types-colorramp"),
	("bpy.types.dopesheet*", "editors/dope_sheet/index.html#bpy-types-dopesheet"),
	("bpy.types.fmodifier*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifier"),
	("bpy.types.freestyle*", "render/freestyle/index.html#bpy-types-freestyle"),
	("bpy.types.movieclip*", "editors/movie_clip_editor/index.html#bpy-types-movieclip"),
	("bpy.types.nodeframe*", "editors/node_editor/nodes/frame.html#bpy-types-nodeframe"),
	("bpy.types.nodegroup*", "editors/node_editor/nodes/groups.html#bpy-types-nodegroup"),
	("bpy.types.pointlamp*", "render/blender_render/lighting/lamps/point.html#bpy-types-pointlamp"),
	("bpy.types.raysensor*", "game_engine/logic/sensors/types/ray.html#bpy-types-raysensor"),
	("bpy.types.spaceinfo*", "editors/info/index.html#bpy-types-spaceinfo"),
	("bpy.types.textcurve*", "modeling/texts/index.html#bpy-types-textcurve"),
	("bpy.types.uipiemenu*", "interface/controls/buttons/menus.html#bpy-types-uipiemenu"),
	("bpy.ops.constraint*", "rigging/constraints/index.html#bpy-ops-constraint"),
	("bpy.ops.curve.draw*", "modeling/curves/editing/draw.html#bpy-ops-curve-draw"),
	("bpy.ops.mesh.knife*", "modeling/meshes/editing/subdividing/knife.html#bpy-ops-mesh-knife"),
	("bpy.ops.mesh.noise*", "modeling/meshes/editing/transform/noise.html#bpy-ops-mesh-noise"),
	("bpy.ops.mesh.screw*", "modeling/meshes/editing/duplicating/screw.html#bpy-ops-mesh-screw"),
	("bpy.ops.safe_areas*", "render/blender_render/camera/object_data.html#bpy-ops-safe-areas"),
	("bpy.types.actuator*", "game_engine/logic/actuators/index.html#bpy-types-actuator"),
	("bpy.types.arealamp*", "render/blender_render/lighting/lamps/area/index.html#bpy-types-arealamp"),
	("bpy.types.armature*", "rigging/armatures/index.html#bpy-types-armature"),
	("bpy.types.editbone*", "rigging/armatures/bones/editing/index.html#bpy-types-editbone"),
	("bpy.types.hemilamp*", "render/blender_render/lighting/lamps/hemi.html#bpy-types-hemilamp"),
	("bpy.types.keyframe*", "animation/keyframes/index.html#bpy-types-keyframe"),
	("bpy.types.linesets*", "render/freestyle/parameter_editor/line_set.html#bpy-types-linesets"),
	("bpy.types.lodlevel*", "game_engine/settings/object.html#bpy-types-lodlevel"),
	("bpy.types.material*", "render/blender_render/materials/index.html#bpy-types-material"),
	("bpy.types.metaball*", "modeling/metas/index.html#bpy-types-metaball"),
	("bpy.types.modifier*", "modeling/modifiers/index.html#bpy-types-modifier"),
	("bpy.types.nlastrip*", "editors/nla/strips.html#bpy-types-nlastrip"),
	("bpy.types.nlatrack*", "editors/nla/tracks.html#bpy-types-nlatrack"),
	("bpy.types.nodelink*", "editors/node_editor/nodes/parts.html#bpy-types-nodelink"),
	("bpy.types.nodetree*", "editors/node_editor/nodes/parts.html#bpy-types-nodetree"),
	("bpy.types.particle*", "physics/particles/index.html#bpy-types-particle"),
	("bpy.types.sequence*", "editors/vse/index.html#bpy-types-sequence"),
	("bpy.types.shapekey*", "animation/shape_keys/index.html#bpy-types-shapekey"),
	("bpy.types.spacenla*", "editors/nla/index.html#bpy-types-spacenla"),
	("bpy.types.spotlamp*", "render/blender_render/lighting/lamps/spot/index.html#bpy-types-spotlamp"),
	("bpy.ops.mesh.spin*", "modeling/meshes/editing/duplicating/spin.html#bpy-ops-mesh-spin"),
	("bpy.ops.rigidbody*", "physics/rigid_body/index.html#bpy-ops-rigidbody"),
	("bpy.ops.sequencer*", "editors/vse/index.html#bpy-ops-sequencer"),
	("bpy.ops.transform*", "editors/3dview/object/editing/transform/index.html#bpy-ops-transform"),
	("bpy.ops.uv.stitch*", "editors/uv_image/uv/editing/layout.html#bpy-ops-uv-stitch"),
	("bpy.ops.uv.unwrap*", "editors/uv_image/uv/editing/unwrapping/mapping_types.html#bpy-ops-uv-unwrap"),
	("bpy.types.animviz*", "animation/motion_paths.html#bpy-types-animviz"),
	("bpy.types.lattice*", "rigging/lattice.html#bpy-types-lattice"),
	("bpy.types.library*", "data_system/linked_libraries.html#bpy-types-library"),
	("bpy.types.speaker*", "render/audio/speaker.html#bpy-types-speaker"),
	("bpy.types.sunlamp*", "render/blender_render/lighting/lamps/sun/index.html#bpy-types-sunlamp"),
	("bpy.types.textbox*", "modeling/texts/properties.html#bpy-types-textbox"),
	("bpy.types.texture*", "render/blender_render/textures/index.html#bpy-types-texture"),
	("bpy.ops.armature*", "rigging/armatures/index.html#bpy-ops-armature"),
	("bpy.ops.material*", "render/blender_render/materials/index.html#bpy-ops-material"),
	("bpy.ops.nla.bake*", "animation/actions.html#bpy-ops-nla-bake"),
	("bpy.ops.outliner*", "editors/outliner.html#bpy-ops-outliner"),
	("bpy.ops.particle*", "physics/particles/index.html#bpy-ops-particle"),
	("bpy.ops.uv.align*", "editors/uv_image/uv/editing/layout.html#bpy-ops-uv-align"),
	("bpy.ops.wm.addon*", "preferences/addons.html#bpy-ops-wm-addon"),
	("bpy.types.action*", "animation/actions.html#bpy-types-action"),
	("bpy.types.camera*", "render/blender_render/camera/index.html#bpy-types-camera"),
	("bpy.types.cycles*", "render/cycles/index.html#bpy-types-cycles"),
	("bpy.types.driver*", "animation/drivers/index.html#bpy-types-driver"),
	("bpy.types.fcurve*", "editors/graph_editor/fcurves/index.html#bpy-types-fcurve"),
	("bpy.types.header*", "interface/window_system/regions.html#bpy-types-header"),
	("bpy.types.object*", "editors/3dview/object/index.html#bpy-types-object"),
	("bpy.types.region*", "interface/window_system/regions.html#bpy-types-region"),
	("bpy.types.render*", "render/index.html#bpy-types-render"),
	("bpy.types.screen*", "interface/window_system/screens.html#bpy-types-screen"),
	("bpy.types.sculpt*", "sculpt_paint/sculpting/index.html#bpy-types-sculpt"),
	("bpy.types.sensor*", "game_engine/logic/sensors/index.html#bpy-types-sensor"),
	("bpy.types.shader*", "render/cycles/nodes/types/shaders/index.html#bpy-types-shader"),
	("bpy.types.window*", "interface/index.html#bpy-types-window"),
	("bpy.ops.buttons*", "interface/index.html#bpy-ops-buttons"),
	("bpy.ops.console*", "editors/python_console.html#bpy-ops-console"),
	("bpy.ops.ed.redo*", "interface/undo_redo.html#bpy-ops-ed-redo"),
	("bpy.ops.ed.undo*", "interface/undo_redo.html#bpy-ops-ed-undo"),
	("bpy.ops.gpencil*", "interface/grease_pencil/index.html#bpy-ops-gpencil"),
	("bpy.ops.lattice*", "rigging/lattice.html#bpy-ops-lattice"),
	("bpy.ops.poselib*", "rigging/armatures/properties/pose_library.html#bpy-ops-poselib"),
	("bpy.ops.ptcache*", "physics/baking.html#bpy-ops-ptcache"),
	("bpy.ops.surface*", "modeling/surfaces/index.html#bpy-ops-surface"),
	("bpy.ops.texture*", "render/blender_render/textures/index.html#bpy-ops-texture"),
	("bpy.ops.uv.weld*", "editors/uv_image/uv/editing/layout.html#bpy-ops-uv-weld"),
	("bpy.types.addon*", "preferences/addons.html#bpy-types-addon"),
	("bpy.types.brush*", "sculpt_paint/brush.html#bpy-types-brush"),
	("bpy.types.curve*", "modeling/curves/index.html#bpy-types-curve"),
	("bpy.types.group*", "editors/3dview/object/properties/relations/groups.html#bpy-types-group"),
	("bpy.types.image*", "data_system/files/media/image_formats.html#bpy-types-image"),
	("bpy.types.nodes*", "editors/node_editor/nodes/index.html#bpy-types-nodes"),
	("bpy.types.panel*", "interface/window_system/tabs_panels.html#bpy-types-panel"),
	("bpy.types.scene*", "data_system/scenes/index.html#bpy-types-scene"),
	("bpy.types.sound*", "render/audio/index.html#bpy-types-sound"),
	("bpy.types.space*", "editors/index.html#bpy-types-space"),
	("bpy.types.theme*", "preferences/themes.html#bpy-types-theme"),
	("bpy.types.world*", "render/blender_render/world/index.html#bpy-types-world"),
	("bpy.ops.action*", "animation/actions.html#bpy-ops-action"),
	("bpy.ops.camera*", "render/blender_render/camera/index.html#bpy-ops-camera"),
	("bpy.ops.cycles*", "render/cycles/index.html#bpy-ops-cycles"),
	("bpy.ops.dpaint*", "physics/dynamic_paint/index.html#bpy-ops-dpaint"),
	("bpy.ops.export*", "data_system/files/import_export.html#bpy-ops-export"),
	("bpy.ops.import*", "data_system/files/import_export.html#bpy-ops-import"),
	("bpy.ops.marker*", "animation/markers.html#bpy-ops-marker"),
	("bpy.ops.object*", "editors/3dview/object/index.html#bpy-ops-object"),
	("bpy.ops.render*", "render/index.html#bpy-ops-render"),
	("bpy.ops.screen*", "interface/window_system/screens.html#bpy-ops-screen"),
	("bpy.ops.script*", "advanced/scripting/index.html#bpy-ops-script"),
	("bpy.ops.sculpt*", "sculpt_paint/sculpting/index.html#bpy-ops-sculpt"),
	("bpy.ops.sketch*", "rigging/armatures/bones/editing/sketching/index.html#bpy-ops-sketch"),
	("bpy.ops.uv.pin*", "editors/uv_image/uv/editing/layout.html#bpy-ops-uv-pin"),
	("bpy.ops.view3d*", "editors/3dview/index.html#bpy-ops-view3d"),
	("bpy.types.area*", "interface/window_system/areas.html#bpy-types-area"),
	("bpy.types.boid*", "physics/particles/emitter/physics/boids.html#bpy-types-boid"),
	("bpy.types.bone*", "rigging/armatures/bones/index.html#bpy-types-bone"),
	("bpy.types.lamp*", "render/blender_render/lighting/index.html#bpy-types-lamp"),
	("bpy.types.mask*", "editors/movie_clip_editor/masking/index.html#bpy-types-mask"),
	("bpy.types.menu*", "interface/controls/buttons/menus.html#bpy-types-menu"),
	("bpy.types.mesh*", "modeling/meshes/index.html#bpy-types-mesh"),
	("bpy.types.pose*", "rigging/armatures/posing/index.html#bpy-types-pose"),
	("bpy.types.text*", "modeling/texts/index.html#bpy-types-text"),
	("bpy.ops.brush*", "sculpt_paint/brush.html#bpy-ops-brush"),
	("bpy.ops.cloth*", "physics/cloth/index.html#bpy-ops-cloth"),
	("bpy.ops.curve*", "modeling/curves/index.html#bpy-ops-curve"),
	("bpy.ops.fluid*", "physics/fluid/index.html#bpy-ops-fluid"),
	("bpy.ops.graph*", "editors/graph_editor/index.html#bpy-ops-graph"),
	("bpy.ops.group*", "editors/3dview/object/properties/relations/groups.html#bpy-ops-group"),
	("bpy.ops.image*", "data_system/files/media/image_formats.html#bpy-ops-image"),
	("bpy.ops.logic*", "game_engine/logic/index.html#bpy-ops-logic"),
	("bpy.ops.mball*", "modeling/metas/index.html#bpy-ops-mball"),
	("bpy.ops.paint*", "sculpt_paint/index.html#bpy-ops-paint"),
	("bpy.ops.scene*", "data_system/scenes/index.html#bpy-ops-scene"),
	("bpy.ops.sound*", "render/audio/index.html#bpy-ops-sound"),
	("bpy.ops.world*", "render/blender_render/world/index.html#bpy-ops-world"),
	("bpy.types.key*", "animation/shape_keys/index.html#bpy-types-key"),
	("bpy.ops.anim*", "animation/index.html#bpy-ops-anim"),
	("bpy.ops.boid*", "physics/particles/emitter/physics/boids.html#bpy-ops-boid"),
	("bpy.ops.clip*", "editors/movie_clip_editor/index.html#bpy-ops-clip"),
	("bpy.ops.file*", "editors/file_browser/index.html#bpy-ops-file"),
	("bpy.ops.font*", "modeling/texts/index.html#bpy-ops-font"),
	("bpy.ops.info*", "editors/info/index.html#bpy-ops-info"),
	("bpy.ops.lamp*", "render/blender_render/lighting/index.html#bpy-ops-lamp"),
	("bpy.ops.mask*", "editors/movie_clip_editor/masking/index.html#bpy-ops-mask"),
	("bpy.ops.mesh*", "modeling/meshes/index.html#bpy-ops-mesh"),
	("bpy.ops.node*", "editors/node_editor/nodes/index.html#bpy-ops-node"),
	("bpy.ops.pose*", "rigging/armatures/posing/index.html#bpy-ops-pose"),
	("bpy.ops.text*", "editors/text_editor.html#bpy-ops-text"),
	("bpy.ops.time*", "editors/timeline.html#bpy-ops-time"),
	("bpy.types.id*", "data_system/data_blocks.html#bpy-types-id"),
	("bpy.ops.nla*", "editors/nla/index.html#bpy-ops-nla"),
	("bpy.ops.ed*", "interface/undo_redo.html#bpy-ops-ed"),
	("bpy.ops.ui*", "interface/index.html#bpy-ops-ui"),
	("bpy.ops.uv*", "editors/uv_image/uv/index.html#bpy-ops-uv"),
	("bpy.ops.wm*", "interface/index.html#bpy-ops-wm"),
	("bpy.types*", "index.html#bpy-types"),
	("bpy.ops*", "index.html#bpy-ops"),
)
