/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.parsers;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.GeoJsonParser;
import org.elasticsearch.common.geo.parsers.GeoWKTParser;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.mapper.BaseGeoShapeFieldMapper;

public interface ShapeParser {
    public static final ParseField FIELD_TYPE = new ParseField("type", new String[0]);
    public static final ParseField FIELD_COORDINATES = new ParseField("coordinates", new String[0]);
    public static final ParseField FIELD_GEOMETRIES = new ParseField("geometries", new String[0]);
    public static final ParseField FIELD_ORIENTATION = new ParseField("orientation", new String[0]);

    public static ShapeBuilder parse(XContentParser parser, BaseGeoShapeFieldMapper shapeMapper) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            return GeoJsonParser.parse(parser, shapeMapper);
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return GeoWKTParser.parse(parser, shapeMapper);
        }
        throw new ElasticsearchParseException("shape must be an object consisting of type and coordinates", new Object[0]);
    }

    public static ShapeBuilder parse(XContentParser parser) throws IOException {
        return ShapeParser.parse(parser, null);
    }

    public static ShapeBuilder parse(Object value) throws IOException {
        XContentBuilder content = JsonXContent.contentBuilder();
        content.startObject();
        content.field("value", value);
        content.endObject();
        try (StreamInput stream = BytesReference.bytes(content).streamInput();){
            ShapeBuilder shapeBuilder;
            block12: {
                XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                try {
                    parser.nextToken();
                    parser.nextToken();
                    parser.nextToken();
                    shapeBuilder = ShapeParser.parse(parser);
                    if (parser == null) break block12;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return shapeBuilder;
        }
    }
}

