/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportStats;

public interface Transport
extends LifecycleComponent {
    public <Request extends TransportRequest> void registerRequestHandler(RequestHandlerRegistry<Request> var1);

    public RequestHandlerRegistry<? extends TransportRequest> getRequestHandler(String var1);

    public void setMessageListener(TransportMessageListener var1);

    public BoundTransportAddress boundAddress();

    public Map<String, BoundTransportAddress> profileBoundAddresses();

    public TransportAddress[] addressesFromString(String var1) throws UnknownHostException;

    public List<String> getDefaultSeedAddresses();

    default public CircuitBreaker getInFlightRequestBreaker() {
        return new NoopCircuitBreaker("in-flight-noop");
    }

    public Releasable openConnection(DiscoveryNode var1, ConnectionProfile var2, ActionListener<Connection> var3);

    public TransportStats getStats();

    public ResponseHandlers getResponseHandlers();

    public static final class ResponseHandlers {
        private final ConcurrentMapLong<ResponseContext<? extends TransportResponse>> handlers = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
        private final AtomicLong requestIdGenerator = new AtomicLong();

        public boolean contains(long requestId) {
            return this.handlers.containsKey(requestId);
        }

        public ResponseContext remove(long requestId) {
            return this.handlers.remove(requestId);
        }

        public long add(ResponseContext<? extends TransportResponse> holder) {
            long requestId = this.newRequestId();
            ResponseContext<? extends TransportResponse> existing = this.handlers.put(requestId, holder);
            assert (existing == null) : "request ID already in use: " + requestId;
            return requestId;
        }

        long newRequestId() {
            return this.requestIdGenerator.incrementAndGet();
        }

        public List<ResponseContext<? extends TransportResponse>> prune(Predicate<ResponseContext> predicate) {
            ArrayList<ResponseContext<? extends TransportResponse>> holders = new ArrayList<ResponseContext<? extends TransportResponse>>();
            for (Map.Entry entry : this.handlers.entrySet()) {
                ResponseContext remove;
                ResponseContext holder = (ResponseContext)entry.getValue();
                if (!predicate.test(holder) || (remove = (ResponseContext)this.handlers.remove(entry.getKey())) == null) continue;
                holders.add(holder);
            }
            return holders;
        }

        public TransportResponseHandler<? extends TransportResponse> onResponseReceived(long requestId, TransportMessageListener listener) {
            ResponseContext<? extends TransportResponse> context = this.handlers.remove(requestId);
            listener.onResponseReceived(requestId, context);
            if (context == null) {
                return null;
            }
            return context.handler();
        }
    }

    public static final class ResponseContext<T extends TransportResponse> {
        private final TransportResponseHandler<T> handler;
        private final Connection connection;
        private final String action;

        ResponseContext(TransportResponseHandler<T> handler, Connection connection, String action) {
            this.handler = handler;
            this.connection = connection;
            this.action = action;
        }

        public TransportResponseHandler<T> handler() {
            return this.handler;
        }

        public Connection connection() {
            return this.connection;
        }

        public String action() {
            return this.action;
        }
    }

    public static interface Connection
    extends Closeable {
        public DiscoveryNode getNode();

        public void sendRequest(long var1, String var3, TransportRequest var4, TransportRequestOptions var5) throws IOException, TransportException;

        public void addCloseListener(ActionListener<Void> var1);

        public boolean isClosed();

        default public Version getVersion() {
            return this.getNode().getVersion();
        }

        default public Object getCacheKey() {
            return this;
        }

        @Override
        public void close();
    }
}

