/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.util.ArrayList;
import java.util.List;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.tooling.internal.provider.BuildClientSubscriptions;
import org.gradle.tooling.internal.provider.SubscribableBuildAction;
import org.gradle.tooling.internal.provider.SubscribableBuildActionRunnerRegistration;

public class SubscribableBuildActionExecuter
implements BuildActionExecuter<BuildActionParameters> {
    private final BuildActionExecuter<BuildActionParameters> delegate;
    private final ListenerManager listenerManager;
    private final BuildOperationListenerManager buildOperationListenerManager;
    private final List<Object> listeners = new ArrayList<Object>();
    private final List<? extends SubscribableBuildActionRunnerRegistration> registrations;

    public SubscribableBuildActionExecuter(BuildActionExecuter<BuildActionParameters> delegate, ListenerManager listenerManager, BuildOperationListenerManager buildOperationListenerManager, List<? extends SubscribableBuildActionRunnerRegistration> registrations) {
        this.delegate = delegate;
        this.listenerManager = listenerManager;
        this.buildOperationListenerManager = buildOperationListenerManager;
        this.registrations = registrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionResult execute(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, ServiceRegistry contextServices) {
        boolean subscribable = action instanceof SubscribableBuildAction;
        if (subscribable) {
            BuildEventConsumer eventConsumer = requestContext.getEventConsumer();
            SubscribableBuildAction subscribableBuildAction = (SubscribableBuildAction)action;
            this.registerListenersForClientSubscriptions(subscribableBuildAction.getClientSubscriptions(), eventConsumer);
        }
        try {
            BuildActionResult buildActionResult = this.delegate.execute(action, requestContext, actionParameters, contextServices);
            return buildActionResult;
        }
        finally {
            for (Object listener : this.listeners) {
                this.listenerManager.removeListener(listener);
                if (!(listener instanceof BuildOperationListener)) continue;
                this.buildOperationListenerManager.removeListener((BuildOperationListener)listener);
            }
            this.listeners.clear();
        }
    }

    private void registerListenersForClientSubscriptions(BuildClientSubscriptions clientSubscriptions, BuildEventConsumer eventConsumer) {
        for (SubscribableBuildActionRunnerRegistration subscribableBuildActionRunnerRegistration : this.registrations) {
            for (Object listener : subscribableBuildActionRunnerRegistration.createListeners(clientSubscriptions, eventConsumer)) {
                this.registerListener(listener);
            }
        }
    }

    private void registerListener(Object listener) {
        this.listeners.add(listener);
        this.listenerManager.addListener(listener);
        if (listener instanceof BuildOperationListener) {
            this.buildOperationListenerManager.addListener((BuildOperationListener)listener);
        }
    }
}

