/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.parameters;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.internal.util.Options;

public class ZonedDateTimeParameter
implements Cloneable,
ParameterHolder {
    private final ZonedDateTime tz;
    private final boolean fractionalSeconds;

    public ZonedDateTimeParameter(ZonedDateTime tz, ZoneId serverZoneId, boolean fractionalSeconds, Options options) {
        ZoneId zoneId = options.useLegacyDatetimeCode ? ZoneOffset.systemDefault() : serverZoneId;
        this.tz = tz.withZoneSameInstant(zoneId);
        this.fractionalSeconds = fractionalSeconds;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.fractionalSeconds ? "yyyy-MM-dd HH:mm:ss.SSSSSS" : "yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        pos.write(39);
        pos.write(formatter.format(this.tz).getBytes());
        pos.write(39);
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        return 27L;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        pos.write((byte)(this.fractionalSeconds ? 11 : 7));
        pos.writeShort((short)this.tz.getYear());
        pos.write((byte)(this.tz.getMonth().getValue() & 0xFF));
        pos.write((byte)(this.tz.getDayOfMonth() & 0xFF));
        pos.write((byte)this.tz.getHour());
        pos.write((byte)this.tz.getMinute());
        pos.write((byte)this.tz.getSecond());
        if (this.fractionalSeconds) {
            pos.writeInt(this.tz.getNano() / 1000);
        }
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.DATETIME;
    }

    @Override
    public String toString() {
        return "'" + this.tz.toString() + "'";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

