/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.zone.ZoneOffsetTransition;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.MultiBucketAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.DateIntervalConsumer;
import org.elasticsearch.search.aggregations.bucket.histogram.DateIntervalWrapper;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;

public class DateHistogramAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.Numeric, DateHistogramAggregationBuilder>
implements MultiBucketAggregationBuilder,
DateIntervalConsumer {
    public static final String NAME = "date_histogram";
    private static DateMathParser EPOCH_MILLIS_PARSER = DateFormatter.forPattern("epoch_millis").toDateMathParser();
    public static final Map<String, Rounding.DateTimeUnit> DATE_FIELD_UNITS;
    private static final ObjectParser<DateHistogramAggregationBuilder, Void> PARSER;
    private DateIntervalWrapper dateHistogramInterval = new DateIntervalWrapper();
    private long offset = 0L;
    private ExtendedBounds extendedBounds;
    private BucketOrder order = BucketOrder.key(true);
    private boolean keyed = false;
    private long minDocCount = 0L;

    public static DateHistogramAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return (DateHistogramAggregationBuilder)PARSER.parse(parser, (Object)new DateHistogramAggregationBuilder(aggregationName), null);
    }

    public DateHistogramAggregationBuilder(String name) {
        super(name, ValuesSourceType.NUMERIC, ValueType.DATE);
    }

    protected DateHistogramAggregationBuilder(DateHistogramAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.dateHistogramInterval = clone.dateHistogramInterval;
        this.offset = clone.offset;
        this.extendedBounds = clone.extendedBounds;
        this.order = clone.order;
        this.keyed = clone.keyed;
        this.minDocCount = clone.minDocCount;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new DateHistogramAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public DateHistogramAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.NUMERIC, ValueType.DATE);
        this.order = InternalOrder.Streams.readHistogramOrder(in, true);
        this.keyed = in.readBoolean();
        this.minDocCount = in.readVLong();
        this.dateHistogramInterval = new DateIntervalWrapper(in);
        this.offset = in.readLong();
        this.extendedBounds = in.readOptionalWriteable(ExtendedBounds::new);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        InternalOrder.Streams.writeHistogramOrder(this.order, out, true);
        out.writeBoolean(this.keyed);
        out.writeVLong(this.minDocCount);
        this.dateHistogramInterval.writeTo(out);
        out.writeLong(this.offset);
        out.writeOptionalWriteable(this.extendedBounds);
    }

    @Override
    @Deprecated
    public long interval() {
        return this.dateHistogramInterval.interval();
    }

    @Deprecated
    public DateHistogramAggregationBuilder interval(long interval) {
        this.dateHistogramInterval.interval(interval);
        return this;
    }

    @Override
    @Deprecated
    public DateHistogramInterval dateHistogramInterval() {
        return this.dateHistogramInterval.dateHistogramInterval();
    }

    @Deprecated
    public DateHistogramAggregationBuilder dateHistogramInterval(DateHistogramInterval interval) {
        this.dateHistogramInterval.dateHistogramInterval(interval);
        return this;
    }

    public DateHistogramAggregationBuilder calendarInterval(DateHistogramInterval interval) {
        this.dateHistogramInterval.calendarInterval(interval);
        return this;
    }

    public DateHistogramAggregationBuilder fixedInterval(DateHistogramInterval interval) {
        this.dateHistogramInterval.fixedInterval(interval);
        return this;
    }

    public DateHistogramInterval getCalendarInterval() {
        if (this.dateHistogramInterval.getIntervalType().equals(DateIntervalWrapper.IntervalTypeEnum.CALENDAR)) {
            return this.dateHistogramInterval.getAsCalendarInterval();
        }
        return null;
    }

    public DateHistogramInterval getFixedInterval() {
        if (this.dateHistogramInterval.getIntervalType().equals(DateIntervalWrapper.IntervalTypeEnum.FIXED)) {
            return this.dateHistogramInterval.getAsFixedInterval();
        }
        return null;
    }

    public long offset() {
        return this.offset;
    }

    public DateHistogramAggregationBuilder offset(long offset) {
        this.offset = offset;
        return this;
    }

    public DateHistogramAggregationBuilder offset(String offset) {
        if (offset == null) {
            throw new IllegalArgumentException("[offset] must not be null: [" + this.name + "]");
        }
        return this.offset(DateHistogramAggregationBuilder.parseStringOffset(offset));
    }

    static long parseStringOffset(String offset) {
        if (offset.charAt(0) == '-') {
            return -TimeValue.parseTimeValue((String)offset.substring(1), null, (String)(DateHistogramAggregationBuilder.class.getSimpleName() + ".parseOffset")).millis();
        }
        int beginIndex = offset.charAt(0) == '+' ? 1 : 0;
        return TimeValue.parseTimeValue((String)offset.substring(beginIndex), null, (String)(DateHistogramAggregationBuilder.class.getSimpleName() + ".parseOffset")).millis();
    }

    public ExtendedBounds extendedBounds() {
        return this.extendedBounds;
    }

    public DateHistogramAggregationBuilder extendedBounds(ExtendedBounds extendedBounds) {
        if (extendedBounds == null) {
            throw new IllegalArgumentException("[extendedBounds] must not be null: [" + this.name + "]");
        }
        this.extendedBounds = extendedBounds;
        return this;
    }

    public BucketOrder order() {
        return this.order;
    }

    public DateHistogramAggregationBuilder order(BucketOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null: [" + this.name + "]");
        }
        this.order = order instanceof InternalOrder.CompoundOrder || InternalOrder.isKeyOrder(order) ? order : BucketOrder.compound(order);
        return this;
    }

    public DateHistogramAggregationBuilder order(List<BucketOrder> orders) {
        if (orders == null) {
            throw new IllegalArgumentException("[orders] must not be null: [" + this.name + "]");
        }
        this.order(orders.size() > 1 ? BucketOrder.compound(orders) : orders.get(0));
        return this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    public DateHistogramAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    public DateHistogramAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 0L) {
            throw new IllegalArgumentException("[minDocCount] must be greater than or equal to 0. Found [" + minDocCount + "] in [" + this.name + "]");
        }
        this.minDocCount = minDocCount;
        return this;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.dateHistogramInterval.toXContent(builder, params);
        builder.field(Histogram.OFFSET_FIELD.getPreferredName(), this.offset);
        if (this.order != null) {
            builder.field(Histogram.ORDER_FIELD.getPreferredName());
            this.order.toXContent(builder, params);
        }
        builder.field(Histogram.KEYED_FIELD.getPreferredName(), this.keyed);
        builder.field(Histogram.MIN_DOC_COUNT_FIELD.getPreferredName(), this.minDocCount);
        if (this.extendedBounds != null) {
            this.extendedBounds.toXContent(builder, params);
        }
        return builder;
    }

    @Override
    public String getType() {
        return NAME;
    }

    ZoneId rewriteTimeZone(QueryShardContext context) throws IOException {
        ZoneId tz = this.timeZone();
        if (this.field() != null && tz != null && !tz.getRules().isFixedOffset() && this.field() != null && this.script() == null) {
            MappedFieldType ft = context.fieldMapper(this.field());
            IndexReader reader = context.getIndexReader();
            if (ft != null && reader != null) {
                Long anyInstant = null;
                IndexNumericFieldData fieldData = (IndexNumericFieldData)context.getForField(ft);
                for (LeafReaderContext ctx : reader.leaves()) {
                    AtomicNumericFieldData leafFD = (AtomicNumericFieldData)fieldData.load(ctx);
                    SortedNumericDocValues values = leafFD.getLongValues();
                    if (values.nextDoc() == Integer.MAX_VALUE) continue;
                    anyInstant = values.nextValue();
                    break;
                }
                if (anyInstant != null) {
                    Rounding.DateTimeUnit intervalAsUnit;
                    long low;
                    Instant instant = Instant.ofEpochMilli(anyInstant);
                    ZoneOffsetTransition prevOffsetTransition = tz.getRules().previousTransition(instant);
                    long prevTransition = prevOffsetTransition != null ? prevOffsetTransition.getInstant().toEpochMilli() : instant.toEpochMilli();
                    ZoneOffsetTransition nextOffsetTransition = tz.getRules().nextTransition(instant);
                    long nextTransition = nextOffsetTransition != null ? nextOffsetTransition.getInstant().toEpochMilli() : instant.toEpochMilli();
                    DateIntervalWrapper.IntervalTypeEnum intervalType = this.dateHistogramInterval.getIntervalType();
                    if (intervalType.equals(DateIntervalWrapper.IntervalTypeEnum.FIXED)) {
                        low = Math.addExact(prevTransition, this.dateHistogramInterval.tryIntervalAsFixedUnit().millis());
                    } else if (intervalType.equals(DateIntervalWrapper.IntervalTypeEnum.CALENDAR)) {
                        intervalAsUnit = this.dateHistogramInterval.tryIntervalAsCalendarUnit();
                        Rounding rounding = Rounding.builder(intervalAsUnit).timeZone(this.timeZone()).build();
                        low = rounding.nextRoundingValue(prevTransition);
                    } else {
                        intervalAsUnit = this.dateHistogramInterval.tryIntervalAsCalendarUnit();
                        if (intervalAsUnit != null) {
                            Rounding rounding = Rounding.builder(intervalAsUnit).timeZone(this.timeZone()).build();
                            low = rounding.nextRoundingValue(prevTransition);
                        } else {
                            TimeValue intervalAsMillis = this.dateHistogramInterval.tryIntervalAsFixedUnit();
                            low = Math.addExact(prevTransition, intervalAsMillis.millis());
                        }
                    }
                    long high = nextTransition;
                    if (ft.isFieldWithinQuery(reader, low, high, true, false, ZoneOffset.UTC, EPOCH_MILLIS_PARSER, context) == MappedFieldType.Relation.WITHIN) {
                        return ZoneOffset.ofTotalSeconds(tz.getRules().getOffset(instant).getTotalSeconds());
                    }
                }
            }
        }
        return tz;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.Numeric, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.Numeric> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        ZoneId tz = this.timeZone();
        Rounding rounding = this.dateHistogramInterval.createRounding(tz);
        ZoneId rewrittenTimeZone = this.rewriteTimeZone(context.getQueryShardContext());
        Rounding shardRounding = tz == rewrittenTimeZone ? rounding : this.dateHistogramInterval.createRounding(rewrittenTimeZone);
        ExtendedBounds roundedBounds = null;
        if (this.extendedBounds != null) {
            roundedBounds = this.extendedBounds.parseAndValidate(this.name, context, config.format()).round(rounding);
        }
        return new DateHistogramAggregatorFactory(this.name, config, this.offset, this.order, this.keyed, this.minDocCount, rounding, shardRounding, roundedBounds, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.order, this.keyed, this.minDocCount, this.dateHistogramInterval, this.minDocCount, this.extendedBounds);
    }

    @Override
    protected boolean innerEquals(Object obj) {
        DateHistogramAggregationBuilder other = (DateHistogramAggregationBuilder)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.minDocCount, other.minDocCount) && Objects.equals(this.dateHistogramInterval, other.dateHistogramInterval) && Objects.equals(this.offset, other.offset) && Objects.equals(this.extendedBounds, other.extendedBounds);
    }

    static {
        HashMap<String, Rounding.DateTimeUnit> dateFieldUnits = new HashMap<String, Rounding.DateTimeUnit>();
        dateFieldUnits.put("year", Rounding.DateTimeUnit.YEAR_OF_CENTURY);
        dateFieldUnits.put("1y", Rounding.DateTimeUnit.YEAR_OF_CENTURY);
        dateFieldUnits.put("quarter", Rounding.DateTimeUnit.QUARTER_OF_YEAR);
        dateFieldUnits.put("1q", Rounding.DateTimeUnit.QUARTER_OF_YEAR);
        dateFieldUnits.put("month", Rounding.DateTimeUnit.MONTH_OF_YEAR);
        dateFieldUnits.put("1M", Rounding.DateTimeUnit.MONTH_OF_YEAR);
        dateFieldUnits.put("week", Rounding.DateTimeUnit.WEEK_OF_WEEKYEAR);
        dateFieldUnits.put("1w", Rounding.DateTimeUnit.WEEK_OF_WEEKYEAR);
        dateFieldUnits.put("day", Rounding.DateTimeUnit.DAY_OF_MONTH);
        dateFieldUnits.put("1d", Rounding.DateTimeUnit.DAY_OF_MONTH);
        dateFieldUnits.put("hour", Rounding.DateTimeUnit.HOUR_OF_DAY);
        dateFieldUnits.put("1h", Rounding.DateTimeUnit.HOUR_OF_DAY);
        dateFieldUnits.put("minute", Rounding.DateTimeUnit.MINUTES_OF_HOUR);
        dateFieldUnits.put("1m", Rounding.DateTimeUnit.MINUTES_OF_HOUR);
        dateFieldUnits.put("second", Rounding.DateTimeUnit.SECOND_OF_MINUTE);
        dateFieldUnits.put("1s", Rounding.DateTimeUnit.SECOND_OF_MINUTE);
        DATE_FIELD_UNITS = Collections.unmodifiableMap(dateFieldUnits);
        PARSER = new ObjectParser(NAME);
        ValuesSourceParserHelper.declareNumericFields(PARSER, true, true, true);
        DateIntervalWrapper.declareIntervalFields(PARSER);
        PARSER.declareField(DateHistogramAggregationBuilder::offset, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.longValue();
            }
            return DateHistogramAggregationBuilder.parseStringOffset(p.text());
        }, Histogram.OFFSET_FIELD, ObjectParser.ValueType.LONG);
        PARSER.declareBoolean(DateHistogramAggregationBuilder::keyed, Histogram.KEYED_FIELD);
        PARSER.declareLong(DateHistogramAggregationBuilder::minDocCount, Histogram.MIN_DOC_COUNT_FIELD);
        PARSER.declareField(DateHistogramAggregationBuilder::extendedBounds, parser -> (ExtendedBounds)ExtendedBounds.PARSER.apply(parser, null), ExtendedBounds.EXTENDED_BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareObjectArray(DateHistogramAggregationBuilder::order, (p, c) -> InternalOrder.Parser.parseOrderParam(p), Histogram.ORDER_FIELD);
    }
}

