/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.menus;

import com.topografix.gpx._1._0.Gpx;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.fibs.geotag.Settings;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.dcraw.Dcraw;
import org.fibs.geotag.exif.Exiftool;
import org.fibs.geotag.gpsbabel.GPSBabel;
import org.fibs.geotag.gui.MainWindow;
import org.fibs.geotag.gui.menus.MenuConstants;
import org.fibs.geotag.gui.menus.SaveLocationsMenu;
import org.fibs.geotag.gui.settings.SettingsDialog;
import org.fibs.geotag.image.FileTypes;
import org.fibs.geotag.image.ImageFileFilter;
import org.fibs.geotag.table.ImagesTable;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.ExifReaderTask;
import org.fibs.geotag.tasks.GPSBabelTask;
import org.fibs.geotag.tasks.GpxReadFileTask;
import org.fibs.geotag.tasks.TaskExecutor;
import org.fibs.geotag.track.GpxFileFilter;
import org.fibs.geotag.track.GpxWriter;
import org.fibs.geotag.track.TrackStore;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class FileMenu
extends JMenu
implements MenuConstants {
    private static final I18n i18n = I18nFactory.getI18n(FileMenu.class);
    private JMenuItem addFileItem;
    private JMenuItem addDirectoryItem;
    SaveLocationsMenu saveLocationsMenu;
    private JMenuItem addTrackItem;
    JMenuItem saveTrackItem;
    JMenuItem loadTrackFromGpsItem;
    private JMenuItem settingsItem;
    private ImagesTable imagesTable;
    private JProgressBar progressBar;

    public FileMenu(ImagesTable imagesTable, JProgressBar progressBar) {
        super(FILE_MENU_NAME);
        this.imagesTable = imagesTable;
        this.progressBar = progressBar;
        this.addFileItem = new JMenuItem(String.valueOf(ADD_FILE) + "...");
        this.addFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenu.this.addFile();
            }
        });
        this.add(this.addFileItem);
        this.addDirectoryItem = new JMenuItem(String.valueOf(ADD_FILES) + "...");
        this.addDirectoryItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenu.this.addDirectory();
            }
        });
        this.add(this.addDirectoryItem);
        this.saveLocationsMenu = new SaveLocationsMenu(false, imagesTable, null);
        this.add(this.saveLocationsMenu);
        this.addTrackItem = new JMenuItem(String.valueOf(LOAD_TRACKS_FROM_FILE) + "...");
        this.addTrackItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenu.this.addTrackFromFile();
            }
        });
        this.add(this.addTrackItem);
        this.saveTrackItem = new JMenuItem(String.valueOf(SAVE_TRACK) + "...");
        this.saveTrackItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenu.this.saveTrack();
            }
        });
        this.saveTrackItem.setEnabled(false);
        this.add(this.saveTrackItem);
        this.loadTrackFromGpsItem = new JMenuItem(LOAD_TRACK_FROM_GPS);
        this.loadTrackFromGpsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenu.this.loadTracksFromGps();
            }
        });
        this.loadTrackFromGpsItem.setEnabled(GPSBabel.isAvailable());
        this.add(this.loadTrackFromGpsItem);
        this.settingsItem = new JMenuItem(String.valueOf(SETTINGS) + "...");
        this.settingsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean dcrawAvailable = Dcraw.isAvailable();
                JFrame mainWindow = MainWindow.getMainWindow(FileMenu.this);
                SettingsDialog settingsDialog = new SettingsDialog(mainWindow);
                settingsDialog.openDialog();
                Exiftool.checkExiftoolAvailable();
                GPSBabel.checkGPSBabelAvailable();
                Dcraw.checkDcrawAvailable();
                if (!dcrawAvailable && Dcraw.isAvailable()) {
                    int row = 0;
                    while (row < FileMenu.this.getTableModel().getRowCount()) {
                        if (FileMenu.this.getTableModel().getImageInfo(row).getThumbNailStatus() == ImageInfo.THUMBNAIL_STATUS.FAI1LED) {
                            FileMenu.this.getTableModel().getImageInfo(row).setThumbNailStatus(ImageInfo.THUMBNAIL_STATUS.UNKNOWN);
                        }
                        ++row;
                    }
                }
                FileMenu.this.loadTrackFromGpsItem.setEnabled(GPSBabel.isAvailable());
                FileMenu.this.getTable().usePreferredFont();
                FileMenu.this.getTableModel().fireTableDataChanged();
            }
        });
        this.add(this.settingsItem);
        this.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                FileMenu.this.saveLocationsMenu.populate(false, FileMenu.this.getTable(), null);
            }
        });
    }

    ImagesTable getTable() {
        return this.imagesTable;
    }

    ImagesTableModel getTableModel() {
        return (ImagesTableModel)this.imagesTable.getModel();
    }

    JProgressBar getProgressBar() {
        return this.progressBar;
    }

    void addFile() {
        File file;
        JFileChooser chooser = new JFileChooser();
        String fileName = Settings.get(Settings.SETTING.LAST_FILE_OPENED, null);
        if (fileName != null && (file = new File(fileName)).exists()) {
            chooser.setSelectedFile(file);
        }
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.addChoosableFileFilter(ImageFileFilter.getFilter(ImageFileFilter.Type.ALL_IMAGES));
        chooser.addChoosableFileFilter(ImageFileFilter.getFilter(ImageFileFilter.Type.JPEG));
        chooser.addChoosableFileFilter(ImageFileFilter.getFilter(ImageFileFilter.Type.RAW));
        chooser.addChoosableFileFilter(ImageFileFilter.getFilter(ImageFileFilter.Type.TIFF));
        if (FileTypes.getFileTypesSupportedByXmp().size() > 0) {
            chooser.addChoosableFileFilter(ImageFileFilter.getFilter(ImageFileFilter.Type.CUSTOM_FILE_WITH_XMP));
        }
        chooser.setFileFilter(ImageFileFilter.getLastFilterUsed());
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showOpenDialog(MainWindow.getMainWindow(this)) == 0) {
            File[] files = chooser.getSelectedFiles();
            Settings.put(Settings.SETTING.LAST_FILE_OPENED, files[0].getPath());
            Settings.flush();
            ImageFileFilter filter = (ImageFileFilter)chooser.getFileFilter();
            ImageFileFilter.storeLastFilterUsed(filter);
            ExifReaderTask task = new ExifReaderTask(ADD_FILE, this.getTableModel(), files);
            TaskExecutor.execute(task);
        }
    }

    void addDirectory() {
        File directory;
        JFileChooser chooser = new JFileChooser();
        String directoryName = Settings.get(Settings.SETTING.LAST_DIRECTORY_OPENED, null);
        if (directoryName != null && (directory = new File(directoryName)).exists() && directory.isDirectory()) {
            chooser.setCurrentDirectory(directory);
        }
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.addChoosableFileFilter(ImageFileFilter.getFilter(ImageFileFilter.Type.ALL_IMAGES));
        chooser.addChoosableFileFilter(ImageFileFilter.getFilter(ImageFileFilter.Type.JPEG));
        chooser.addChoosableFileFilter(ImageFileFilter.getFilter(ImageFileFilter.Type.RAW));
        chooser.addChoosableFileFilter(ImageFileFilter.getFilter(ImageFileFilter.Type.TIFF));
        if (FileTypes.getFileTypesSupportedByXmp().size() > 0) {
            chooser.addChoosableFileFilter(ImageFileFilter.getFilter(ImageFileFilter.Type.CUSTOM_FILE_WITH_XMP));
        }
        chooser.setFileFilter(ImageFileFilter.getLastFilterUsed());
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(MainWindow.getMainWindow(this)) == 0) {
            directory = chooser.getSelectedFile();
            Settings.put(Settings.SETTING.LAST_DIRECTORY_OPENED, directory.getPath());
            Settings.flush();
            ImageFileFilter filter = (ImageFileFilter)chooser.getFileFilter();
            ImageFileFilter.storeLastFilterUsed(filter);
            File[] files = directory.listFiles(filter);
            ExifReaderTask task = new ExifReaderTask(ADD_FILES, this.getTableModel(), files);
            TaskExecutor.execute(task);
        }
    }

    void addTrackFromFile() {
        File file;
        JFileChooser chooser = new JFileChooser();
        String lastFile = Settings.get(Settings.SETTING.LAST_GPX_FILE_OPENED, null);
        if (lastFile != null && (file = new File(lastFile)).exists()) {
            chooser.setSelectedFile(file);
        }
        chooser.setFileFilter(new GpxFileFilter());
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showOpenDialog(MainWindow.getMainWindow(this)) == 0) {
            File[] files = chooser.getSelectedFiles();
            Settings.put(Settings.SETTING.LAST_GPX_FILE_OPENED, files[0].getPath());
            Settings.flush();
            TaskExecutor.execute(new GpxReadFileTask(LOAD_TRACKS_FROM_FILE, files){

                @Override
                protected void process(List<Gpx> chunks) {
                    super.process(chunks);
                    for (Gpx gpx : chunks) {
                        if (gpx != null) {
                            TrackStore.getTrackStore().addGPX(gpx);
                            continue;
                        }
                        JOptionPane.showMessageDialog(MainWindow.getMainWindow(FileMenu.this), i18n.tr("Could not read GPX file"), i18n.tr("Error"), 0);
                    }
                }

                @Override
                protected void done() {
                    super.done();
                    FileMenu.this.saveTrackItem.setEnabled(true);
                }
            });
        }
    }

    void saveTrack() {
        File file;
        JFileChooser chooser = new JFileChooser();
        String lastFile = Settings.get(Settings.SETTING.LAST_GPX_FILE_OPENED, null);
        if (lastFile != null && (file = new File(lastFile)).exists() && file.getParentFile() != null) {
            chooser.setCurrentDirectory(file.getParentFile());
        }
        GpxFileFilter gpxFileFilter = new GpxFileFilter();
        chooser.setFileFilter(gpxFileFilter);
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showSaveDialog(MainWindow.getMainWindow(this)) == 0) {
            try {
                File outputFile = chooser.getSelectedFile();
                if (!gpxFileFilter.accept(outputFile)) {
                    outputFile = new File(String.valueOf(chooser.getSelectedFile().getPath()) + ".gpx");
                }
                if (outputFile.exists()) {
                    String title = i18n.tr("File exists");
                    String message = String.format(i18n.tr("Overwrite existing file %s?"), outputFile.getName());
                    if (JOptionPane.showConfirmDialog(MainWindow.getMainWindow(this), message, title, 0, 3) == 1) {
                        return;
                    }
                }
                new GpxWriter().write(TrackStore.getTrackStore().getGpx(), outputFile);
                String message = String.format(i18n.tr("Tracks saved to %s."), outputFile.getPath());
                this.progressBar.setString(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void loadTracksFromGps() {
        GPSBabelTask task = new GPSBabelTask(LOAD_TRACK_FROM_GPS){

            @Override
            protected void process(List<Gpx> chunks) {
                int numTrackpoints = 0;
                for (Gpx gpx : chunks) {
                    TrackStore.getTrackStore().addGPX(gpx);
                    List<Gpx.Trk> tracks = gpx.getTrk();
                    for (Gpx.Trk trk : tracks) {
                        List<Gpx.Trk.Trkseg> segments = trk.getTrkseg();
                        for (Gpx.Trk.Trkseg segment : segments) {
                            numTrackpoints += segment.getTrkpt().size();
                        }
                    }
                }
                String message = "" + numTrackpoints + ' ' + i18n.tr("locations loaded");
                FileMenu.this.getProgressBar().setString(message);
                FileMenu.this.saveTrackItem.setEnabled(true);
            }

            @Override
            protected void done() {
                List<String> errorMessages = this.getErrorMessages();
                if (errorMessages.size() > 0) {
                    StringBuilder message = new StringBuilder();
                    for (String string : errorMessages) {
                        message.append(string).append('\n');
                    }
                    JOptionPane.showMessageDialog(MainWindow.getMainWindow(FileMenu.this), message, i18n.tr("GPSBabel error"), 0);
                }
            }
        };
        TaskExecutor.execute(task);
    }

    public void updateMenuAvailability(boolean enable) {
        this.addFileItem.setEnabled(enable);
        this.addDirectoryItem.setEnabled(enable);
        this.addTrackItem.setEnabled(enable);
        this.loadTrackFromGpsItem.setEnabled(enable);
        this.settingsItem.setEnabled(enable);
    }
}

