/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils;

import java.awt.Font;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import org.gephi.graph.api.GraphModel;
import org.gephi.utils.NumberUtils;

public class Serialization {
    private final GraphModel graphModel;
    private static final Serialization INSTANCE_WITHOUT_GRAPH_MODEL = new Serialization();

    public Serialization() {
        this(null);
    }

    public Serialization(GraphModel graphModel) {
        this.graphModel = graphModel;
    }

    public String toText(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return this.toText(value, value.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toText(Object value, Class valueClass) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (valueClass.equals(Font.class)) {
            Font f = (Font)value;
            return String.format("%s-%d-%d", f.getName(), f.getStyle(), f.getSize());
        }
        if (Serialization.isPrimitiveOrPrimitiveWrapper(valueClass) || Number.class.isAssignableFrom(valueClass) && !Number.class.equals((Object)valueClass)) {
            return String.valueOf(value);
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(valueClass);
        if (editor != null) {
            Method setGraphModelMethod = null;
            try {
                setGraphModelMethod = editor.getClass().getMethod("setGraphModel", GraphModel.class);
                if (setGraphModelMethod != null) {
                    setGraphModelMethod.invoke((Object)editor, this.graphModel);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                editor.setValue(value);
                String string = editor.getAsText();
                return string;
            }
            finally {
                if (setGraphModelMethod != null) {
                    try {
                        setGraphModelMethod.invoke((Object)editor, (Object[])null);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fromText(String valueStr, Class valueClass) {
        if (String.class.equals((Object)valueClass)) {
            return valueStr;
        }
        if (valueClass.equals(Font.class)) {
            try {
                String[] parts = valueStr.split("-");
                return new Font(parts[0], Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
            }
            catch (Exception e) {
                return null;
            }
        }
        if (Serialization.isPrimitiveOrPrimitiveWrapper(valueClass)) {
            return Serialization.parsePrimitiveOrWrapper(valueClass, valueStr);
        }
        if (Number.class.isAssignableFrom(valueClass) && !Number.class.equals((Object)valueClass)) {
            return NumberUtils.parseNumber(valueStr, valueClass);
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(valueClass);
        if (editor != null) {
            Method setGraphModelMethod = null;
            try {
                setGraphModelMethod = editor.getClass().getMethod("setGraphModel", GraphModel.class);
                if (setGraphModelMethod != null) {
                    setGraphModelMethod.invoke((Object)editor, this.graphModel);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                editor.setAsText(valueStr);
                Object object = editor.getValue();
                return object;
            }
            finally {
                if (setGraphModelMethod != null) {
                    try {
                        setGraphModelMethod.invoke((Object)editor, (Object[])null);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return null;
    }

    public static String getValueAsText(Object value) {
        return INSTANCE_WITHOUT_GRAPH_MODEL.toText(value);
    }

    public static String getValueAsText(Object value, Class valueClass) {
        return INSTANCE_WITHOUT_GRAPH_MODEL.toText(value, valueClass);
    }

    public static Object readValueFromText(String valueStr, Class valueClass) {
        return INSTANCE_WITHOUT_GRAPH_MODEL.fromText(valueStr, valueClass);
    }

    public static Object readValueFromText(String valueStr, String valueClassStr) {
        try {
            return Serialization.readValueFromText(valueStr, Class.forName(valueClassStr));
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static boolean isPrimitiveOrPrimitiveWrapper(Class<?> type) {
        return type.isPrimitive() && !Void.TYPE.equals(type) || Double.class.equals(type) || Float.class.equals(type) || Long.class.equals(type) || Integer.class.equals(type) || Short.class.equals(type) || Character.class.equals(type) || Byte.class.equals(type) || Boolean.class.equals(type);
    }

    public static Object parsePrimitiveOrWrapper(Class valueClass, String value) {
        if (Boolean.class.equals((Object)valueClass) || Boolean.TYPE == valueClass) {
            return Boolean.parseBoolean(value);
        }
        if (Character.class.equals((Object)valueClass) || Character.TYPE == valueClass) {
            return Character.valueOf(value.charAt(0));
        }
        if (Byte.class.equals((Object)valueClass) || Byte.TYPE == valueClass) {
            return Byte.parseByte(value);
        }
        if (Short.class.equals((Object)valueClass) || Short.TYPE == valueClass) {
            return Short.parseShort(value);
        }
        if (Integer.class.equals((Object)valueClass) || Integer.TYPE == valueClass) {
            return Integer.parseInt(value);
        }
        if (Long.class.equals((Object)valueClass) || Long.TYPE == valueClass) {
            return Long.parseLong(value);
        }
        if (Float.class.equals((Object)valueClass) || Float.TYPE == valueClass) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class.equals((Object)valueClass) || Double.TYPE == valueClass) {
            return Double.parseDouble(value);
        }
        throw new IllegalArgumentException("Unknown class " + valueClass.getName());
    }
}

