/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

class DataConsistentFileOutputStream
extends BufferedOutputStream {
    private FileOutputStream fos;
    private long lastConsistentLength;

    public DataConsistentFileOutputStream(File file, boolean append) throws FileNotFoundException {
        this(file, append, new FileOutputStream[]{null});
    }

    private DataConsistentFileOutputStream(File file, boolean append, FileOutputStream[] fosPtr) throws FileNotFoundException {
        fosPtr[0] = new FileOutputStream(file, append);
        super(fosPtr[0]);
        this.fos = fosPtr[0];
        this.lastConsistentLength = append ? file.length() : 0L;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        super.write(b);
        ++this.lastConsistentLength;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        try {
            super.write(b, off, len);
            this.lastConsistentLength += (long)len;
        }
        catch (IOException ioex) {
            DataConsistentFileOutputStream.truncateFileToConsistentSize(this.fos, this.lastConsistentLength);
            throw ioex;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        super.flush();
        FileChannel fch = this.fos.getChannel();
        fch.force(true);
    }

    static void truncateFileToConsistentSize(FileOutputStream fos, long size) {
        try {
            FileChannel fch = fos.getChannel();
            fch.truncate(size);
            fch.force(true);
        }
        catch (IOException ex) {
            Logger.getLogger(DataConsistentFileOutputStream.class.getName()).log(Level.INFO, "Not able to truncate file to the data consistent size of " + size + " bytes.", ex);
        }
    }
}

