/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.jpeg.drew;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import tim.prune.jpeg.JpegData;
import tim.prune.jpeg.drew.ByteArrayReader;
import tim.prune.jpeg.drew.ExifException;
import tim.prune.jpeg.drew.ExifTiffHandler;
import tim.prune.jpeg.drew.Rational;
import tim.prune.jpeg.drew.TiffDataFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TiffProcessor {
    public static void processTiff(ByteArrayReader byteArrayReader, JpegData jpegData, int n) throws ExifException, IOException {
        short s = byteArrayReader.getInt16(n);
        if (s == 19789) {
            byteArrayReader.setMotorolaByteOrder(true);
        } else if (s == 18761) {
            byteArrayReader.setMotorolaByteOrder(false);
        } else {
            throw new ExifException("Unclear distinction between Motorola/Intel byte ordering: " + s);
        }
        int n2 = byteArrayReader.getInt32(4 + n) + n;
        if ((long)n2 >= byteArrayReader.getLength() - 1L) {
            n2 = n + 2 + 2 + 4;
        }
        ExifTiffHandler exifTiffHandler = new ExifTiffHandler(jpegData);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        TiffProcessor.processDirectory(exifTiffHandler, byteArrayReader, hashSet, n2, n, 0);
        exifTiffHandler.completed(byteArrayReader, n);
    }

    private static void processDirectory(ExifTiffHandler exifTiffHandler, ByteArrayReader byteArrayReader, Set<Integer> set, int n, int n2, int n3) throws ExifException {
        int n4;
        if (set.contains(n)) {
            return;
        }
        set.add(n);
        if ((long)n >= byteArrayReader.getLength() || n < 0) {
            return;
        }
        int n5 = byteArrayReader.getUInt16(n);
        int n6 = 2 + 12 * n5 + 4;
        if ((long)(n6 + n) > byteArrayReader.getLength()) {
            return;
        }
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            block13: {
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                block15: {
                    block14: {
                        int n15;
                        block12: {
                            n4 = TiffProcessor.calculateTagOffset(n, n8);
                            n14 = byteArrayReader.getUInt16(n4);
                            n13 = byteArrayReader.getUInt16(n4 + 2);
                            n15 = TiffDataFormat.getComponentSize(n13);
                            if (n15 != 0) break block12;
                            if (++n7 > 5) {
                                return;
                            }
                            break block13;
                        }
                        n12 = byteArrayReader.getInt32(n4 + 4);
                        if (n12 < 0) break block13;
                        n11 = n12 * n15;
                        if (n11 <= 4) break block14;
                        n10 = byteArrayReader.getInt32(n4 + 8);
                        if ((long)(n10 + n11) > byteArrayReader.getLength()) break block13;
                        n9 = n2 + n10;
                        break block15;
                    }
                    n9 = n4 + 8;
                }
                if (n9 >= 0 && (long)n9 <= byteArrayReader.getLength() && n11 >= 0 && (long)(n9 + n11) <= byteArrayReader.getLength()) {
                    if (n11 == 4 && exifTiffHandler.isTagIfdPointer(n14)) {
                        n10 = n2 + byteArrayReader.getInt32(n9);
                        TiffProcessor.processDirectory(exifTiffHandler, byteArrayReader, set, n10, n2, n14);
                    } else if (exifTiffHandler.isInterestingTag(n3, n14)) {
                        TiffProcessor.processTag(exifTiffHandler, n14, n9, n12, n13, byteArrayReader);
                    }
                }
            }
            ++n8;
        }
        n8 = TiffProcessor.calculateTagOffset(n, n5);
        n4 = byteArrayReader.getInt32(n8);
        if (n4 != 0) {
            if ((long)(n4 += n2) >= byteArrayReader.getLength()) {
                return;
            }
            if (n4 < n) {
                return;
            }
            TiffProcessor.processDirectory(exifTiffHandler, byteArrayReader, set, n4, n2, n3);
        }
    }

    private static void processTag(ExifTiffHandler exifTiffHandler, int n, int n2, int n3, int n4, ByteArrayReader byteArrayReader) throws ExifException {
        switch (n4) {
            case 2: {
                exifTiffHandler.setString(n, byteArrayReader.getNullTerminatedString(n2, n3));
                break;
            }
            case 10: {
                if (n3 == 1) {
                    exifTiffHandler.setRational(n, new Rational(byteArrayReader.getInt32(n2), byteArrayReader.getInt32(n2 + 4)));
                    break;
                }
                if (n3 <= 1) break;
                Rational[] rationalArray = new Rational[n3];
                int n5 = 0;
                while (n5 < n3) {
                    rationalArray[n5] = new Rational(byteArrayReader.getInt32(n2 + 8 * n5), byteArrayReader.getInt32(n2 + 4 + 8 * n5));
                    ++n5;
                }
                exifTiffHandler.setRationalArray(n, rationalArray);
                break;
            }
            case 5: {
                if (n3 == 1) {
                    exifTiffHandler.setRational(n, new Rational(byteArrayReader.getUInt32(n2), byteArrayReader.getUInt32(n2 + 4)));
                    break;
                }
                if (n3 <= 1) break;
                Rational[] rationalArray = new Rational[n3];
                int n6 = 0;
                while (n6 < n3) {
                    rationalArray[n6] = new Rational(byteArrayReader.getUInt32(n2 + 8 * n6), byteArrayReader.getUInt32(n2 + 4 + 8 * n6));
                    ++n6;
                }
                exifTiffHandler.setRationalArray(n, rationalArray);
                break;
            }
            case 6: {
                if (n3 != 1) break;
                exifTiffHandler.setIntegerValue(n, byteArrayReader.getInt8(n2));
                break;
            }
            case 1: {
                if (n3 != 1) break;
                exifTiffHandler.setIntegerValue(n, byteArrayReader.getUInt8(n2));
                break;
            }
            case 8: {
                if (n3 != 1) break;
                exifTiffHandler.setIntegerValue(n, byteArrayReader.getInt16(n2));
                break;
            }
            case 3: {
                if (n3 != 1) break;
                exifTiffHandler.setIntegerValue(n, byteArrayReader.getUInt16(n2));
                break;
            }
            case 9: {
                if (n3 != 1) break;
                exifTiffHandler.setIntegerValue(n, byteArrayReader.getInt32(n2));
                break;
            }
            case 4: {
                if (n3 != 1) break;
                exifTiffHandler.setRational(n, new Rational(byteArrayReader.getUInt32(n2), 1L));
                break;
            }
        }
    }

    private static int calculateTagOffset(int n, int n2) {
        return n + 2 + 12 * n2;
    }
}

