/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationTask;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class CreateMultipolygonAction
extends JosmAction {
    private final boolean update;
    private static final List<String> DEFAULT_LINEAR_TAGS = Arrays.asList("barrier", "fence_type", "source");

    public CreateMultipolygonAction(boolean update) {
        super(CreateMultipolygonAction.getName(update), "multipoly_create", CreateMultipolygonAction.getName(update), update ? Shortcut.registerShortcut("tools:multipoly_update", I18n.tr("Tool: {0}", CreateMultipolygonAction.getName(true)), 66, 5009) : Shortcut.registerShortcut("tools:multipoly_create", I18n.tr("Tool: {0}", CreateMultipolygonAction.getName(false)), 66, 5006), true, update ? "multipoly_update" : "multipoly_create", true);
        this.update = update;
    }

    private static String getName(boolean update) {
        return update ? I18n.tr("Update multipolygon", new Object[0]) : I18n.tr("Create multipolygon", new Object[0]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation multipolygonRelation;
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (dataSet == null) {
            new Notification(I18n.tr("No data loaded.", new Object[0])).setIcon(2).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        Collection<Way> selectedWays = dataSet.getSelectedWays();
        if (selectedWays.isEmpty()) {
            new Notification(I18n.tr("You must select at least one way.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        Collection<Relation> selectedRelations = dataSet.getSelectedRelations();
        Relation relation = multipolygonRelation = this.update ? CreateMultipolygonAction.getSelectedMultipolygonRelation(selectedWays, selectedRelations) : null;
        if (this.update && multipolygonRelation == null) {
            return;
        }
        OsmDataLayer editLayer = this.getLayerManager().getEditLayer();
        if (multipolygonRelation != null && editLayer != null && editLayer.isDownloadable()) {
            if (!multipolygonRelation.isNew() && multipolygonRelation.isIncomplete()) {
                MainApplication.worker.submit(new DownloadRelationTask(Collections.singleton(multipolygonRelation), editLayer));
            } else if (multipolygonRelation.hasIncompleteMembers()) {
                MainApplication.worker.submit(new DownloadRelationMemberTask(multipolygonRelation, Utils.filteredCollection(DownloadSelectedIncompleteMembersAction.buildSetOfIncompleteMembers(Collections.singleton(multipolygonRelation)), OsmPrimitive.class), editLayer));
            }
        }
        MainApplication.worker.submit(new CreateUpdateMultipolygonTask(selectedWays, multipolygonRelation));
    }

    private static Relation getSelectedMultipolygonRelation(Collection<Way> selectedWays, Collection<Relation> selectedRelations) {
        Relation candidate = null;
        if (selectedRelations.size() == 1) {
            candidate = selectedRelations.iterator().next();
            if (!candidate.hasTag("type", "multipolygon")) {
                candidate = null;
            }
        } else if (!selectedWays.isEmpty()) {
            for (Way w : selectedWays) {
                for (OsmPrimitive r : w.getReferrers()) {
                    if (r == candidate || r.isDisabled() || !(r instanceof Relation) || !r.hasTag("type", "multipolygon")) continue;
                    if (candidate != null) {
                        return null;
                    }
                    candidate = (Relation)r;
                }
            }
        }
        return candidate;
    }

    public static Pair<Relation, Relation> updateMultipolygonRelation(Collection<Way> selectedWays, Relation selectedMultipolygonRelation) {
        HashSet<Way> ways = new HashSet<Way>(selectedWays);
        ways.addAll(selectedMultipolygonRelation.getMemberPrimitives(Way.class));
        MultipolygonBuilder polygon = CreateMultipolygonAction.analyzeWays(ways, true);
        if (polygon == null) {
            return null;
        }
        return Pair.create(selectedMultipolygonRelation, CreateMultipolygonAction.createRelation(polygon, selectedMultipolygonRelation));
    }

    public static Pair<Relation, Relation> createMultipolygonRelation(Collection<Way> selectedWays, boolean showNotif) {
        MultipolygonBuilder polygon = CreateMultipolygonAction.analyzeWays(selectedWays, showNotif);
        if (polygon == null) {
            return null;
        }
        return Pair.create(null, CreateMultipolygonAction.createRelation(polygon, null));
    }

    public static Pair<SequenceCommand, Relation> createMultipolygonCommand(Collection<Way> selectedWays, Relation selectedMultipolygonRelation) {
        String commandName;
        Pair<Relation, Relation> rr;
        Pair<Relation, Relation> pair = rr = selectedMultipolygonRelation == null ? CreateMultipolygonAction.createMultipolygonRelation(selectedWays, true) : CreateMultipolygonAction.updateMultipolygonRelation(selectedWays, selectedMultipolygonRelation);
        if (rr == null) {
            return null;
        }
        Relation existingRelation = (Relation)rr.a;
        Relation relation = (Relation)rr.b;
        List<Command> list = CreateMultipolygonAction.removeTagsFromWaysIfNeeded(relation);
        if (existingRelation == null) {
            list.add(new AddCommand(selectedWays.iterator().next().getDataSet(), relation));
            commandName = CreateMultipolygonAction.getName(false);
        } else {
            list.add(new ChangeCommand(existingRelation, relation));
            commandName = CreateMultipolygonAction.getName(true);
        }
        return Pair.create(new SequenceCommand(commandName, list), relation);
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds == null || selection.isEmpty()) {
            this.setEnabled(false);
        } else if (this.update) {
            this.setEnabled(CreateMultipolygonAction.getSelectedMultipolygonRelation(ds.getSelectedWays(), ds.getSelectedRelations()) != null);
        } else {
            this.setEnabled(!ds.getSelectedWays().isEmpty());
        }
    }

    private static MultipolygonBuilder analyzeWays(Collection<Way> selectedWays, boolean showNotif) {
        MultipolygonBuilder pol = new MultipolygonBuilder();
        String error = pol.makeFromWays(selectedWays);
        if (error != null) {
            if (showNotif) {
                GuiHelper.runInEDT(() -> new Notification(error).setIcon(1).show());
            }
            return null;
        }
        return pol;
    }

    private static Relation createRelation(MultipolygonBuilder pol, Relation clone) {
        Relation rel = clone != null ? new Relation(clone) : new Relation();
        rel.put("type", "multipolygon");
        for (MultipolygonBuilder.JoinedPolygon jway : pol.outerWays) {
            CreateMultipolygonAction.addMembers(jway, rel, "outer");
        }
        for (MultipolygonBuilder.JoinedPolygon jway : pol.innerWays) {
            CreateMultipolygonAction.addMembers(jway, rel, "inner");
        }
        if (clone == null) {
            rel.setMembers(RelationSorter.sortMembersByConnectivity(rel.getMembers()));
        }
        return rel;
    }

    private static void addMembers(MultipolygonBuilder.JoinedPolygon polygon, Relation rel, String role) {
        int count = rel.getMembersCount();
        HashSet<Way> ways = new HashSet<Way>(polygon.ways);
        for (int i = 0; i < count; ++i) {
            RelationMember m = rel.getMember(i);
            if (!ways.contains(m.getMember()) || role.equals(m.getRole())) continue;
            rel.setMember(i, new RelationMember(role, m.getMember()));
        }
        ways.removeAll(rel.getMemberPrimitivesList());
        for (Way way : ways) {
            rel.addMember(new RelationMember(role, way));
        }
    }

    public static List<Command> removeTagsFromWaysIfNeeded(Relation relation) {
        HashMap<String, String> values = new HashMap<String, String>(relation.getKeys());
        ArrayList<Way> innerWays = new ArrayList<Way>();
        ArrayList<Way> outerWays = new ArrayList<Way>();
        TreeSet<String> conflictingKeys = new TreeSet<String>();
        for (RelationMember m : relation.getMembers()) {
            if (m.hasRole() && "inner".equals(m.getRole()) && m.isWay() && m.getWay().hasKeys()) {
                innerWays.add(m.getWay());
            }
            if (!m.hasRole() || !"outer".equals(m.getRole()) || !m.isWay() || !m.getWay().hasKeys()) continue;
            Iterator way = m.getWay();
            outerWays.add((Way)((Object)way));
            for (String key : ((AbstractPrimitive)((Object)way)).keySet()) {
                if (!values.containsKey(key)) {
                    values.put(key, ((AbstractPrimitive)((Object)way)).get(key));
                    continue;
                }
                if (relation.hasKey(key) || ((String)values.get(key)).equals(((AbstractPrimitive)((Object)way)).get(key))) continue;
                conflictingKeys.add(key);
            }
        }
        if (!Config.getPref().getBoolean("multipoly.alltags", false)) {
            for (RelationMember m : relation.getMembers()) {
                if (!m.hasRole() || !"outer".equals(m.getRole()) || !m.isWay()) continue;
                for (String key : values.keySet()) {
                    if (m.getWay().hasKey(key) || relation.hasKey(key)) continue;
                    conflictingKeys.add(key);
                }
            }
        }
        for (String key : conflictingKeys) {
            values.remove(key);
        }
        for (String linearTag : Config.getPref().getList("multipoly.lineartagstokeep", DEFAULT_LINEAR_TAGS)) {
            values.remove(linearTag);
        }
        if ("coastline".equals(values.get("natural"))) {
            values.remove("natural");
        }
        values.put("area", "yes");
        ArrayList<Command> commands = new ArrayList<Command>();
        boolean moveTags = Config.getPref().getBoolean("multipoly.movetags", true);
        for (Map.Entry entry : values.entrySet()) {
            ArrayList affectedWays = new ArrayList();
            String string = (String)entry.getKey();
            String value = (String)entry.getValue();
            for (Way way : innerWays) {
                if (!value.equals(way.get(string))) continue;
                affectedWays.add(way);
            }
            if (moveTags) {
                for (Way way : outerWays) {
                    if (!way.hasKey(string)) continue;
                    affectedWays.add(way);
                }
            }
            if (affectedWays.isEmpty()) continue;
            commands.add(new ChangePropertyCommand(affectedWays, string, null));
        }
        if (moveTags) {
            boolean fixed = false;
            Relation r2 = new Relation(relation);
            for (Map.Entry entry : values.entrySet()) {
                String key = (String)entry.getKey();
                if (r2.hasKey(key) || "area".equals(key)) continue;
                if (relation.isNew()) {
                    relation.put(key, (String)entry.getValue());
                } else {
                    r2.put(key, (String)entry.getValue());
                }
                fixed = true;
            }
            if (fixed && !relation.isNew()) {
                DataSet ds = relation.getDataSet();
                if (ds == null) {
                    ds = MainApplication.getLayerManager().getEditDataSet();
                }
                commands.add(new ChangeCommand(ds, relation, r2));
            }
        }
        return commands;
    }

    private static final class CreateUpdateMultipolygonTask
    implements Runnable {
        private final Collection<Way> selectedWays;
        private final Relation multipolygonRelation;

        private CreateUpdateMultipolygonTask(Collection<Way> selectedWays, Relation multipolygonRelation) {
            this.selectedWays = selectedWays;
            this.multipolygonRelation = multipolygonRelation;
        }

        @Override
        public void run() {
            Pair<SequenceCommand, Relation> commandAndRelation = CreateMultipolygonAction.createMultipolygonCommand(this.selectedWays, this.multipolygonRelation);
            if (commandAndRelation == null) {
                return;
            }
            Command command = (Command)commandAndRelation.a;
            Relation relation = (Relation)commandAndRelation.b;
            SwingUtilities.invokeLater(() -> {
                UndoRedoHandler.getInstance().add(command);
                SwingUtilities.invokeLater(() -> {
                    MainApplication.getMap().relationListDialog.selectRelation(relation);
                    if (Config.getPref().getBoolean("multipoly.show-relation-editor", false)) {
                        RelationEditor editor = RelationEditor.getEditor(MainApplication.getLayerManager().getEditLayer(), relation, null);
                        editor.setModal(true);
                        editor.setVisible(true);
                    } else {
                        MainApplication.getLayerManager().getEditLayer().setRecentRelation(relation);
                    }
                });
            });
        }
    }
}

