/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsECCUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsPSKIdentity;
import org.bouncycastle.tls.TlsPSKIdentityManager;
import org.bouncycastle.tls.TlsRSAUtils;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;

public class TlsPSKKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsPSKIdentity pskIdentity;
    protected TlsPSKIdentityManager pskIdentityManager;
    protected TlsDHGroupVerifier dhGroupVerifier;
    protected byte[] psk_identity_hint = null;
    protected byte[] psk = null;
    protected TlsDHConfig dhConfig;
    protected TlsECConfig ecConfig;
    protected TlsAgreement agreement;
    protected TlsCredentialedDecryptor serverCredentials = null;
    protected TlsCertificate serverCertificate;
    protected TlsSecret preMasterSecret;

    private static int checkKeyExchange(int n) {
        switch (n) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return n;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsPSKKeyExchange(int n, TlsPSKIdentity tlsPSKIdentity, TlsDHGroupVerifier tlsDHGroupVerifier) {
        this(n, tlsPSKIdentity, null, tlsDHGroupVerifier, null, null);
    }

    public TlsPSKKeyExchange(int n, TlsPSKIdentityManager tlsPSKIdentityManager, TlsDHConfig tlsDHConfig, TlsECConfig tlsECConfig) {
        this(n, null, tlsPSKIdentityManager, null, tlsDHConfig, tlsECConfig);
    }

    private TlsPSKKeyExchange(int n, TlsPSKIdentity tlsPSKIdentity, TlsPSKIdentityManager tlsPSKIdentityManager, TlsDHGroupVerifier tlsDHGroupVerifier, TlsDHConfig tlsDHConfig, TlsECConfig tlsECConfig) {
        super(TlsPSKKeyExchange.checkKeyExchange(n));
        this.pskIdentity = tlsPSKIdentity;
        this.pskIdentityManager = tlsPSKIdentityManager;
        this.dhGroupVerifier = tlsDHGroupVerifier;
        this.dhConfig = tlsDHConfig;
        this.ecConfig = tlsECConfig;
    }

    public void skipServerCredentials() throws IOException {
        if (this.keyExchange == 15) {
            throw new TlsFatalAlert(80);
        }
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (this.keyExchange != 15) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = TlsUtils.requireDecryptorCredentials(tlsCredentials);
    }

    public void processServerCertificate(Certificate certificate) throws IOException {
        if (this.keyExchange != 15) {
            throw new TlsFatalAlert(10);
        }
        this.serverCertificate = certificate.getCertificateAt(0).useInRole(0, this.keyExchange);
    }

    public byte[] generateServerKeyExchange() throws IOException {
        this.psk_identity_hint = this.pskIdentityManager.getHint();
        if (this.psk_identity_hint == null && !this.requiresServerKeyExchange()) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.psk_identity_hint == null) {
            TlsUtils.writeOpaque16(TlsUtils.EMPTY_BYTES, byteArrayOutputStream);
        } else {
            TlsUtils.writeOpaque16(this.psk_identity_hint, byteArrayOutputStream);
        }
        if (this.keyExchange == 14) {
            if (this.dhConfig == null) {
                throw new TlsFatalAlert(80);
            }
            TlsDHUtils.writeDHConfig(this.dhConfig, byteArrayOutputStream);
            this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
            this.generateEphemeralDH(byteArrayOutputStream);
        } else if (this.keyExchange == 24) {
            if (this.ecConfig == null) {
                throw new TlsFatalAlert(80);
            }
            TlsECCUtils.writeECConfig(this.ecConfig, byteArrayOutputStream);
            this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
            this.generateEphemeralECDH(byteArrayOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public boolean requiresServerKeyExchange() {
        switch (this.keyExchange) {
            case 14: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        this.psk_identity_hint = TlsUtils.readOpaque16(inputStream);
        if (this.keyExchange == 14) {
            this.dhConfig = TlsDHUtils.receiveDHConfig(this.context, this.dhGroupVerifier, inputStream);
            byte[] byArray = TlsUtils.readOpaque16(inputStream, 1);
            this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
            this.processEphemeralDH(byArray);
        } else if (this.keyExchange == 24) {
            this.ecConfig = TlsECCUtils.receiveECDHConfig(this.context, inputStream);
            byte[] byArray = TlsUtils.readOpaque8(inputStream, 1);
            this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
            this.processEphemeralECDH(byArray);
        }
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        if (this.psk_identity_hint == null) {
            this.pskIdentity.skipIdentityHint();
        } else {
            this.pskIdentity.notifyIdentityHint(this.psk_identity_hint);
        }
        byte[] byArray = this.pskIdentity.getPSKIdentity();
        if (byArray == null) {
            throw new TlsFatalAlert(80);
        }
        this.psk = this.pskIdentity.getPSK();
        if (this.psk == null) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeOpaque16(byArray, outputStream);
        this.context.getSecurityParametersHandshake().pskIdentity = Arrays.clone((byte[])byArray);
        if (this.keyExchange == 14) {
            this.generateEphemeralDH(outputStream);
        } else if (this.keyExchange == 24) {
            this.generateEphemeralECDH(outputStream);
        } else if (this.keyExchange == 15) {
            this.preMasterSecret = TlsRSAUtils.generateEncryptedPreMasterSecret(this.context, this.serverCertificate, outputStream);
        }
    }

    public void processClientKeyExchange(InputStream inputStream) throws IOException {
        byte[] byArray = TlsUtils.readOpaque16(inputStream);
        this.psk = this.pskIdentityManager.getPSK(byArray);
        if (this.psk == null) {
            throw new TlsFatalAlert(115);
        }
        this.context.getSecurityParametersHandshake().pskIdentity = byArray;
        if (this.keyExchange == 14) {
            byte[] byArray2 = TlsUtils.readOpaque16(inputStream, 1);
            this.processEphemeralDH(byArray2);
        } else if (this.keyExchange == 24) {
            byte[] byArray3 = TlsUtils.readOpaque8(inputStream, 1);
            this.processEphemeralECDH(byArray3);
        } else if (this.keyExchange == 15) {
            byte[] byArray4 = TlsUtils.readOpaque16(inputStream);
            this.preMasterSecret = this.serverCredentials.decrypt(new TlsCryptoParameters(this.context), byArray4);
        }
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        byte[] byArray = this.generateOtherSecret(this.psk.length);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4 + byArray.length + this.psk.length);
        TlsUtils.writeOpaque16(byArray, byteArrayOutputStream);
        TlsUtils.writeOpaque16(this.psk, byteArrayOutputStream);
        Arrays.fill((byte[])this.psk, (byte)0);
        this.psk = null;
        return this.context.getCrypto().createSecret(byteArrayOutputStream.toByteArray());
    }

    protected void generateEphemeralDH(OutputStream outputStream) throws IOException {
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(byArray, outputStream);
    }

    protected void generateEphemeralECDH(OutputStream outputStream) throws IOException {
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque8(byArray, outputStream);
    }

    protected byte[] generateOtherSecret(int n) throws IOException {
        if (this.keyExchange == 13) {
            return new byte[n];
        }
        if ((this.keyExchange == 14 || this.keyExchange == 24) && this.agreement != null) {
            return this.agreement.calculateSecret().extract();
        }
        if (this.keyExchange == 15 && this.preMasterSecret != null) {
            return this.preMasterSecret.extract();
        }
        throw new TlsFatalAlert(80);
    }

    protected void processEphemeralDH(byte[] byArray) throws IOException {
        this.agreement.receivePeerValue(byArray);
    }

    protected void processEphemeralECDH(byte[] byArray) throws IOException {
        TlsECCUtils.checkPointEncoding(this.ecConfig.getNamedGroup(), byArray);
        this.agreement.receivePeerValue(byArray);
    }
}

