/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ExplicitMetadataChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "()V", "METADATA_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "frontend.java"})
public final class ExplicitMetadataChecker
implements AdditionalAnnotationChecker {
    private static final FqName METADATA_FQ_NAME;
    public static final ExplicitMetadataChecker INSTANCE;

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries2, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(entries2, "entries");
        Intrinsics.checkParameterIsNotNull(actualTargets, "actualTargets");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        for (KtAnnotationEntry ktAnnotationEntry : entries2) {
            AnnotationDescriptor descriptor2;
            if ((AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, ktAnnotationEntry) == null) {
                continue;
            }
            if (!Intrinsics.areEqual(descriptor2.getFqName(), METADATA_FQ_NAME)) continue;
            trace.report(ErrorsJvm.EXPLICIT_METADATA_IS_DISALLOWED.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry)));
        }
    }

    private ExplicitMetadataChecker() {
    }

    static {
        ExplicitMetadataChecker explicitMetadataChecker;
        INSTANCE = explicitMetadataChecker = new ExplicitMetadataChecker();
        METADATA_FQ_NAME = new FqName("kotlin.Metadata");
    }
}

