/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.deprecation;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.protege.editor.core.log.LogBanner;
import org.protege.editor.owl.model.deprecation.DeprecateEntityInfo;
import org.protege.editor.owl.model.deprecation.DeprecationProfile;
import org.protege.editor.owl.model.deprecation.ReparentVisitor;
import org.protege.editor.owl.model.entity.HomeOntologySupplier;
import org.protege.editor.owl.model.util.DefinitionExtractor;
import org.protege.editor.owl.model.util.LiteralLexicalValueReplacer;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.AxiomSubjectProvider;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDeprecator<E extends OWLEntity> {
    private static Logger logger = LoggerFactory.getLogger(EntityDeprecator.class);
    @Nonnull
    private final OWLDataFactory dataFactory;
    @Nonnull
    private final Set<OWLOntology> ontologies = new HashSet<OWLOntology>();
    @Nonnull
    private final DeprecateEntityInfo<E> info;
    @Nonnull
    private final DeprecationProfile profile;
    @Nonnull
    private final HomeOntologySupplier homeOntologySupplier;

    public EntityDeprecator(@Nonnull DeprecateEntityInfo<E> info, @Nonnull DeprecationProfile profile, @Nonnull Set<OWLOntology> ontologies, @Nonnull HomeOntologySupplier homeOntologySupplier, @Nonnull OWLDataFactory dataFactory) {
        this.dataFactory = (OWLDataFactory)Preconditions.checkNotNull((Object)dataFactory);
        this.profile = (DeprecationProfile)Preconditions.checkNotNull((Object)profile);
        this.homeOntologySupplier = (HomeOntologySupplier)Preconditions.checkNotNull((Object)homeOntologySupplier);
        this.ontologies.addAll(ontologies);
        this.info = (DeprecateEntityInfo)Preconditions.checkNotNull(info);
    }

    public List<OWLOntologyChange> getChanges() {
        logger.info(LogBanner.start((String)"Deprecating entity"));
        logger.info("[Deprecate Entity] Deprecating " + this.info.getEntityToDeprecate());
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        this.switchUsageOfDeprecatedEntityWithReplacement(changes);
        this.updateDeprecatedEntityLogicalDefinition(changes);
        this.updateDeprecatedEntityAnnotations(changes);
        this.addDeprecatedAnnotationAssertion(changes);
        this.addDeprecationReason(changes);
        this.addDeprecationCode(changes);
        this.relabelDeprecatedEntity(changes);
        this.prefixDeprecatedAnnotationValues(changes);
        this.addReplacedByAnnotation(changes);
        this.addAlternateEntityAnnotations(changes);
        this.reparentDeprecatedEntity(changes);
        logger.info(LogBanner.end());
        return changes;
    }

    private void addDeprecatedAnnotationAssertion(@Nonnull List<OWLOntologyChange> changes) {
        OWLAnnotationAssertionAxiom ax = this.dataFactory.getOWLAnnotationAssertionAxiom(this.dataFactory.getOWLDeprecated(), (OWLAnnotationSubject)this.info.getEntityToDeprecate().getIRI(), (OWLAnnotationValue)this.dataFactory.getOWLLiteral(true));
        logger.info("[Deprecate Entity] Added owl:deprecated annotation");
        changes.add((OWLOntologyChange)new AddAxiom(this.getHomeOntology(), (OWLAxiom)ax));
    }

    private void updateDeprecatedEntityLogicalDefinition(@Nonnull List<OWLOntologyChange> changes) {
        if (!this.profile.shouldRemoveLogicalDefinition()) {
            logger.info("[Deprecate Entity] Logical definition left intact");
            return;
        }
        this.ontologies.forEach(o -> {
            DefinitionExtractor definitionExtractor = new DefinitionExtractor((OWLEntity)this.info.getEntityToDeprecate(), (OWLOntology)o, this.dataFactory);
            changes.addAll(definitionExtractor.getChangesToRemoveDefinition());
        });
        logger.info("[Deprecate Entity] Removed deprecated entity logical definition");
    }

    private void updateDeprecatedEntityAnnotations(@Nonnull List<OWLOntologyChange> changes) {
        if (!this.profile.shouldRemoveAnnotationAssertions()) {
            logger.info("[Deprecate Entity] Annotation assertions left intact");
            return;
        }
        this.ontologies.forEach(o -> o.getAnnotationAssertionAxioms((OWLAnnotationSubject)this.info.getEntityToDeprecate().getIRI()).stream().filter(ax -> {
            Set<IRI> preservedAnnotationValuePropertiesIris = this.profile.getPreservedAnnotationValuePropertiesIris();
            return !preservedAnnotationValuePropertiesIris.contains(ax.getProperty().getIRI());
        }).forEach(ax -> changes.add((OWLOntologyChange)new RemoveAxiom(o, (OWLAxiom)ax))));
    }

    private void relabelDeprecatedEntity(@Nonnull List<OWLOntologyChange> changes) {
        String prefix = this.profile.getDeprecatedEntityLabelPrefix();
        if (prefix.isEmpty()) {
            return;
        }
        String replacementPrefix = this.getReplacementPrefix(prefix);
        String replacement = replacementPrefix + "$0";
        logger.info("[Deprecate Entity] Relabelled deprecated entity");
        this.replaceAnnotationAssertions(changes, Collections.singleton(this.dataFactory.getRDFSLabel().getIRI()), replacement);
    }

    private String getReplacementPrefix(String prefix) {
        String trimmedPrefix = prefix.trim();
        return trimmedPrefix.endsWith("_") || trimmedPrefix.endsWith("-") ? trimmedPrefix : trimmedPrefix + " ";
    }

    private void prefixDeprecatedAnnotationValues(@Nonnull List<OWLOntologyChange> changes) {
        String prefix = this.profile.getPreservedAnnotationValuePrefix().trim();
        if (prefix.isEmpty()) {
            return;
        }
        String replacement = this.getReplacementPrefix(prefix) + "$0";
        logger.info("[Deprecate Entity] Prefixed deprecated entity annotations with \"{}\"", (Object)prefix);
        this.replaceAnnotationAssertions(changes, this.profile.getPreservedAnnotationValuePropertiesIris(), replacement);
    }

    private void addDeprecationReason(List<OWLOntologyChange> changes) {
        String reasonForDeprecation = this.info.getReasonForDeprecation().trim();
        if (reasonForDeprecation.isEmpty()) {
            return;
        }
        this.profile.getDeprecationTextualReasonAnnotationPropertyIri().ifPresent(propIri -> {
            OWLAnnotationAssertionAxiom ax = this.dataFactory.getOWLAnnotationAssertionAxiom(this.dataFactory.getOWLAnnotationProperty(propIri), (OWLAnnotationSubject)this.info.getEntityToDeprecate().getIRI(), (OWLAnnotationValue)this.dataFactory.getOWLLiteral(reasonForDeprecation, OWL2Datatype.XSD_STRING));
            logger.info("[Deprecate Entity] Added reason for deprecation as an annotation on the deprecated entity");
            changes.add((OWLOntologyChange)new AddAxiom(this.getHomeOntology(), (OWLAxiom)ax));
        });
    }

    private void addDeprecationCode(List<OWLOntologyChange> changes) {
        this.profile.getDeprecationCode().ifPresent(deprecationCode -> this.info.getDeprecationCode().ifPresent(selectedCode -> {
            OWLAnnotationAssertionAxiom ax = this.dataFactory.getOWLAnnotationAssertionAxiom(this.dataFactory.getOWLAnnotationProperty(deprecationCode.getPropertyIri()), (OWLAnnotationSubject)this.info.getEntityToDeprecate().getIRI(), selectedCode);
            changes.add((OWLOntologyChange)new AddAxiom(this.getHomeOntology(), (OWLAxiom)ax));
        }));
    }

    private void addReplacedByAnnotation(List<OWLOntologyChange> changes) {
        this.info.getReplacementEntity().ifPresent(replacementEntity -> this.profile.getReplacedByAnnotationPropertyIri().ifPresent(propIri -> {
            OWLAnnotationAssertionAxiom ax = this.dataFactory.getOWLAnnotationAssertionAxiom(this.dataFactory.getOWLAnnotationProperty(propIri), (OWLAnnotationSubject)this.info.getEntityToDeprecate().getIRI(), (OWLAnnotationValue)replacementEntity.getIRI());
            logger.info("[Deprecate Entity] Added annotation to point to deprecated entity replacement");
            changes.add((OWLOntologyChange)new AddAxiom(this.getHomeOntology(), (OWLAxiom)ax));
        }));
    }

    private void addAlternateEntityAnnotations(List<OWLOntologyChange> changes) {
        this.profile.getAlternateEntityAnnotationPropertyIri().ifPresent(property -> this.info.getAlternateEntities().forEach(alternate -> {
            OWLAnnotationAssertionAxiom ax = this.dataFactory.getOWLAnnotationAssertionAxiom(this.dataFactory.getOWLAnnotationProperty(property), (OWLAnnotationSubject)this.info.getEntityToDeprecate().getIRI(), (OWLAnnotationValue)alternate.getIRI());
            logger.info("[Deprecate Entity] Added annotations to point to alternate entities");
            changes.add((OWLOntologyChange)new AddAxiom(this.getHomeOntology(), (OWLAxiom)ax));
        }));
    }

    private void reparentDeprecatedEntity(List<OWLOntologyChange> changes) {
        E deprecatedEntity = this.info.getEntityToDeprecate();
        Optional ax = (Optional)deprecatedEntity.accept((OWLEntityVisitorEx)new ReparentVisitor(this.profile, this.dataFactory));
        ax.map(axiom -> new AddAxiom(this.getHomeOntology(), axiom)).ifPresent(changes::add);
    }

    private void switchUsageOfDeprecatedEntityWithReplacement(@Nonnull List<OWLOntologyChange> changes) {
        this.info.getReplacementEntity().ifPresent(replacementEntity -> {
            HashMap<E, IRI> replacementMap = new HashMap<E, IRI>();
            replacementMap.put(this.info.getEntityToDeprecate(), replacementEntity.getIRI());
            OWLObjectDuplicator duplicator = new OWLObjectDuplicator(replacementMap, this.dataFactory);
            this.ontologies.forEach(o -> o.getReferencingAxioms(this.info.getEntityToDeprecate()).stream().filter(OWLAxiom::isLogicalAxiom).filter(ax -> !new AxiomSubjectProvider().getSubject(ax).equals(this.info.getEntityToDeprecate())).forEach(ax -> {
                OWLAxiom replacementAx = (OWLAxiom)duplicator.duplicateObject((OWLObject)ax);
                changes.add((OWLOntologyChange)new RemoveAxiom(o, ax));
                changes.add((OWLOntologyChange)new AddAxiom(o, replacementAx));
            }));
        });
    }

    private void replaceAnnotationAssertions(@Nonnull List<OWLOntologyChange> changes, @Nonnull Set<IRI> propertyIris, @Nonnull String replacement) {
        this.ontologies.forEach(o -> {
            IRI entityIri = this.info.getEntityToDeprecate().getIRI();
            o.getAnnotationAssertionAxioms((OWLAnnotationSubject)entityIri).stream().filter(ax -> propertyIris.contains(ax.getProperty().getIRI())).filter(ax -> ax.getValue().asLiteral().isPresent()).forEach(ax -> {
                changes.add((OWLOntologyChange)new RemoveAxiom(o, (OWLAxiom)ax));
                OWLLiteral currentLiteral = (OWLLiteral)ax.getValue().asLiteral().get();
                OWLLiteral replacementLiteral = new LiteralLexicalValueReplacer(this.dataFactory).replaceLexicalValue(currentLiteral, replacement);
                OWLAnnotationAssertionAxiom replacementAx = this.dataFactory.getOWLAnnotationAssertionAxiom(ax.getProperty(), ax.getSubject(), (OWLAnnotationValue)replacementLiteral, ax.getAnnotations());
                changes.add((OWLOntologyChange)new AddAxiom(o, (OWLAxiom)replacementAx));
            });
        });
    }

    private OWLOntology getHomeOntology() {
        return this.homeOntologySupplier.getHomeOntology((OWLEntity)this.info.getEntityToDeprecate(), this.ontologies);
    }
}

