# Firejail profile for openclonk
# Description: Multiplayer action, tactics and skill game
# This file is overwritten after every install/update
# Persistent local customizations
include openclonk.local
# Persistent global definitions
include globals.local

noblacklist ${HOME}/.clonk

include disable-common.inc
include disable-devel.inc
include disable-exec.inc
include disable-interpreters.inc
include disable-passwdmgr.inc
include disable-programs.inc
include disable-xdg.inc

mkdir ${HOME}/.clonk
whitelist ${HOME}/.clonk
include whitelist-common.inc
include whitelist-var-common.inc

caps.drop all
ipc-namespace
net none
nodbus
nodvd
nogroups
nonewprivs
noroot
notv
nou2f
novideo
protocol unix
seccomp
shell none
tracelog

disable-mnt
private-bin openclonk,c4group
private-cache
private-dev
private-tmp
