/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import tim.prune.App;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.function.compress.MarkAndDeleteFunction;

public class MarkPointsInRectangleFunction
extends MarkAndDeleteFunction {
    private double _minLat = 0.0;
    private double _maxLat = 0.0;
    private double _minLon = 0.0;
    private double _maxLon = 0.0;

    public MarkPointsInRectangleFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "menu.track.markrectangle";
    }

    public void setRectCoords(double d, double d2, double d3, double d4) {
        if (d == d3 || d2 == d4) {
            this._maxLon = 0.0;
            this._minLon = 0.0;
            this._maxLat = 0.0;
            this._minLat = 0.0;
        } else {
            if (d3 > d) {
                this._minLon = d;
                this._maxLon = d3;
            } else {
                this._minLon = d3;
                this._maxLon = d;
            }
            if (d4 > d2) {
                this._minLat = d2;
                this._maxLat = d4;
            } else {
                this._minLat = d4;
                this._maxLat = d2;
            }
        }
    }

    public void begin() {
        if (this._maxLon == this._minLon || this._maxLat == this._minLat) {
            return;
        }
        int n = this._app.getTrackInfo().getTrack().getNumPoints();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            DataPoint dataPoint = this._app.getTrackInfo().getTrack().getPoint(n3);
            double d = dataPoint.getLongitude().getDouble();
            double d2 = dataPoint.getLatitude().getDouble();
            boolean bl = d >= this._minLon && d <= this._maxLon && d2 >= this._minLat && d2 <= this._maxLat;
            dataPoint.setMarkedForDeletion(bl);
            if (bl) {
                ++n2;
            }
            ++n3;
        }
        UpdateMessageBroker.informSubscribers();
        if (n2 > 0) {
            this.optionallyDeleteMarkedPoints(n2);
        }
    }
}

