/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.results.memory.HeapHistogram;
import org.netbeans.lib.profiler.wireprotocol.HeapHistogramResponse;

public class HeapHistogramManager {
    private Map<Integer, String> classesIdMap = new HashMap<Integer, String>(8000);
    private final ProfilerEngineSettings settings;

    public HeapHistogramManager(ProfilerEngineSettings profilerEngineSettings) {
        this.settings = profilerEngineSettings;
    }

    public HeapHistogram getHistogram(HeapHistogramResponse heapHistogramResponse) {
        String[] stringArray = heapHistogramResponse.getNewNames();
        int[] nArray = heapHistogramResponse.getNewids();
        for (int i = 0; i < stringArray.length; ++i) {
            this.classesIdMap.put(nArray[i], stringArray[i]);
        }
        int[] nArray2 = heapHistogramResponse.getIds();
        long[] lArray = heapHistogramResponse.getInstances();
        long[] lArray2 = heapHistogramResponse.getBytes();
        HeapHistogramImpl heapHistogramImpl = new HeapHistogramImpl(heapHistogramResponse.getTime());
        InstrumentationFilter instrumentationFilter = this.settings.getInstrumentationFilter();
        for (int i = 0; i < nArray2.length; ++i) {
            String string = this.classesIdMap.get(nArray2[i]);
            if (!((GenericFilter)instrumentationFilter).passes(string.replace('.', '/'))) continue;
            ClassInfoImpl classInfoImpl = new ClassInfoImpl(string, lArray[i], lArray2[i]);
            heapHistogramImpl.addClassInfo(classInfoImpl, false);
        }
        return heapHistogramImpl;
    }

    static class ClassInfoImpl
    extends HeapHistogram.ClassInfo {
        private String name;
        private long instances;
        private long bytes;

        ClassInfoImpl(String string, long l, long l2) {
            this.name = string;
            this.instances = l;
            this.bytes = l2;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getInstancesCount() {
            return this.instances;
        }

        @Override
        public long getBytes() {
            return this.bytes;
        }
    }

    class HeapHistogramImpl
    extends HeapHistogram {
        private Date time;
        private long totalHeapInstances;
        private long totalHeapBytes;
        private Set<HeapHistogram.ClassInfo> heap;
        private long totalPermInstances;
        private long totalPermBytes;
        private Set<HeapHistogram.ClassInfo> perm;

        HeapHistogramImpl(Date date) {
            this.time = date;
            this.heap = new HashSet<HeapHistogram.ClassInfo>(4096);
            this.perm = new HashSet<HeapHistogram.ClassInfo>();
        }

        void addClassInfo(HeapHistogram.ClassInfo classInfo, boolean bl) {
            if (bl) {
                this.perm.add(classInfo);
                this.totalPermInstances += classInfo.getInstancesCount();
                this.totalPermBytes += classInfo.getBytes();
            } else {
                this.heap.add(classInfo);
                this.totalHeapInstances += classInfo.getInstancesCount();
                this.totalHeapBytes += classInfo.getBytes();
            }
        }

        @Override
        public Date getTime() {
            return this.time;
        }

        @Override
        public long getTotalInstances() {
            return this.totalHeapInstances + this.totalPermInstances;
        }

        @Override
        public long getTotalBytes() {
            return this.totalHeapBytes + this.totalPermBytes;
        }

        @Override
        public Set<HeapHistogram.ClassInfo> getHeapHistogram() {
            return this.heap;
        }

        @Override
        public long getTotalHeapInstances() {
            return this.totalHeapInstances;
        }

        @Override
        public long getTotalHeapBytes() {
            return this.totalHeapBytes;
        }

        @Override
        public Set<HeapHistogram.ClassInfo> getPermGenHistogram() {
            return this.perm;
        }

        @Override
        public long getTotalPerGenInstances() {
            return this.totalPermInstances;
        }

        @Override
        public long getTotalPermGenHeapBytes() {
            return this.totalPermBytes;
        }
    }
}

