/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.DataSourceViewPlugin;
import com.sun.tools.visualvm.core.ui.DataSourceViewPluginProvider;
import com.sun.tools.visualvm.core.ui.DataSourceViewProvider;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class PluggableDataSourceViewProvider<X extends DataSource>
extends DataSourceViewProvider<X> {
    public static final Set<Integer> ALL_LOCATIONS = new HashSet<Integer>();
    private final Set<DataSourceViewPluginProvider<X>> pluginProviders = Collections.synchronizedSet(new HashSet());
    private final Map<X, Set<DataSourceViewPluginProvider<X>>> pluginProvidersCache = Collections.synchronizedMap(new HashMap());

    public final void registerPluginProvider(DataSourceViewPluginProvider<X> pluginProvider) {
        this.pluginProviders.add(pluginProvider);
    }

    public final void unregisterPluginProvider(DataSourceViewPluginProvider<X> pluginProvider) {
        this.pluginProviders.remove(pluginProvider);
    }

    public abstract Set<Integer> getPluggableLocations(DataSourceView var1);

    @Override
    protected void saveView(X dataSource, Snapshot snapshot) {
    }

    @Override
    void viewSaveView(X dataSource, Snapshot snapshot) {
        super.viewSaveView(dataSource, snapshot);
        Set<DataSourceViewPluginProvider<X>> providers = this.getProviders(dataSource, false);
        for (DataSourceViewPluginProvider<X> provider : providers) {
            if (!provider.supportsSavePluginFor(dataSource, snapshot.getClass())) continue;
            provider.savePlugin(dataSource, snapshot);
        }
    }

    @Override
    void processCreatedComponent(DataSourceView view, DataViewComponent component) {
        DataSource dataSource = view.getDataSource();
        Set<DataSourceViewPluginProvider<DataSource>> providers = this.getProviders(dataSource, true);
        for (DataSourceViewPluginProvider<DataSource> provider : providers) {
            Set<Integer> pluggableLocations = this.getPluggableLocations(view);
            DataSourceViewPlugin plugin = provider.getPlugin(dataSource);
            for (int pluggableLocation : pluggableLocations) {
                DataViewComponent.DetailsView pluginView = plugin.createView(pluggableLocation);
                if (pluginView == null) continue;
                component.addDetailsView(pluginView, pluggableLocation);
            }
        }
    }

    @Override
    void viewWillBeAdded(DataSourceView view) {
        DataSource dataSource = view.getDataSource();
        Set<DataSourceViewPluginProvider<DataSource>> providers = this.getProviders(dataSource, true);
        for (DataSourceViewPluginProvider<DataSource> provider : providers) {
            provider.getPlugin(dataSource).pluginWillBeAdded();
        }
    }

    @Override
    void viewAdded(DataSourceView view) {
        DataSource dataSource = view.getDataSource();
        Set<DataSourceViewPluginProvider<DataSource>> providers = this.getProviders(dataSource, true);
        for (DataSourceViewPluginProvider<DataSource> provider : providers) {
            provider.getPlugin(dataSource).pluginAdded();
        }
    }

    @Override
    void viewRemoved(DataSourceView view) {
        DataSource dataSource = view.getDataSource();
        Set<DataSourceViewPluginProvider<DataSource>> providers = this.getProviders(dataSource, true);
        for (DataSourceViewPluginProvider<DataSource> provider : providers) {
            provider.getPlugin(dataSource).pluginRemoved();
        }
        this.pluginProvidersCache.remove(dataSource);
        super.viewRemoved(view);
    }

    private Set<DataSourceViewPluginProvider<X>> getProviders(X dataSource, boolean cache) {
        Set<DataSourceViewPluginProvider<X>> providers = this.pluginProvidersCache.get(dataSource);
        if (providers != null) {
            return providers;
        }
        providers = new HashSet<DataSourceViewPluginProvider<X>>(this.pluginProviders);
        HashSet<DataSourceViewPluginProvider<X>> compatibleProviders = new HashSet<DataSourceViewPluginProvider<X>>();
        for (DataSourceViewPluginProvider<X> provider : providers) {
            if (!provider.supportsPluginFor(dataSource)) continue;
            compatibleProviders.add(provider);
        }
        if (cache) {
            this.pluginProvidersCache.put(dataSource, compatibleProviders);
        }
        return compatibleProviders;
    }

    static {
        ALL_LOCATIONS.add(1);
        ALL_LOCATIONS.add(2);
        ALL_LOCATIONS.add(3);
        ALL_LOCATIONS.add(4);
    }
}

