<?php

namespace Drupal\Tests\block\Functional\Update;

use Drupal\FunctionalTests\Update\UpdatePathTestBase;

/**
 * Tests the upgrade path for block with conditions missing context.
 *
 * @see https://www.drupal.org/node/2811519
 *
 * @group Update
 * @group legacy
 */
class BlockConditionMissingSchemaUpdateTest extends UpdatePathTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['block_test', 'language'];

  /**
   * {@inheritdoc}
   */
  protected function setDatabaseDumpFiles() {
    $this->databaseDumpFiles = [
      __DIR__ . '/../../../../../system/tests/fixtures/update/drupal-8.bare.standard.php.gz',
      __DIR__ . '/../../../fixtures/update/drupal-8.block-test-enabled-missing-schema.php',
    ];
  }

  /**
   * Tests that block context mapping is updated properly.
   */
  public function testUpdateHookN() {
    $this->runUpdates();
    $this->drupalGet('<front>');
    // If the block is fixed by block_post_update_fix_negate_in_conditions()
    // then it will be visible.
    $this->assertText('Test missing schema on conditions');
  }

}
