/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ingest.common.AbstractStringProcessor;

public final class HtmlStripProcessor
extends AbstractStringProcessor<String> {
    public static final String TYPE = "html_strip";

    HtmlStripProcessor(String tag, String field, boolean ignoreMissing, String targetField) {
        super(tag, field, ignoreMissing, targetField);
    }

    @Override
    protected String process(String value) {
        if (!value.contains("<") || !value.contains(">")) {
            return value;
        }
        HTMLStripCharFilter filter = new HTMLStripCharFilter((Reader)new StringReader(value));
        StringBuilder builder = new StringBuilder();
        try {
            int ch;
            while ((ch = filter.read()) != -1) {
                builder.append((char)ch);
            }
        }
        catch (IOException e) {
            throw new ElasticsearchException((Throwable)e);
        }
        return builder.toString();
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    extends AbstractStringProcessor.Factory {
        public Factory() {
            super(HtmlStripProcessor.TYPE);
        }

        protected HtmlStripProcessor newProcessor(String tag, Map<String, Object> config, String field, boolean ignoreMissing, String targetField) {
            return new HtmlStripProcessor(tag, field, ignoreMissing, targetField);
        }
    }
}

