/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.SoftHashMap;

public class LazyResettableHashMap<T> {
    private static List<LazyResettableHashMap<?>> all;
    private Map<HashMapKey, T> cache;
    private String displayName;

    public LazyResettableHashMap(String displayName) {
        this.displayName = displayName;
        if (all == null) {
            all = new LinkedList();
        }
        all.add(this);
    }

    private void createIfNecessary() {
        if (this.cache == null) {
            this.cache = new SoftHashMap<HashMapKey, T>();
        }
    }

    public void put(HashMapKey key, T entry) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalArgumentException("Called outside Event Dispatch Thread");
        }
        this.createIfNecessary();
        this.cache.put(key, entry);
    }

    public T get(HashMapKey key) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(key);
    }

    public boolean containsKey(HashMapKey key) {
        if (this.cache == null) {
            return false;
        }
        return this.cache.containsKey(key);
    }

    public int size() {
        if (this.cache == null) {
            return 0;
        }
        return this.cache.size();
    }

    public static void reset() {
        if (all != null) {
            for (LazyResettableHashMap<?> map : all) {
                if (map.cache == null) continue;
                map.cache.clear();
            }
        }
    }

    public static List<String> getStats() {
        if (all != null) {
            String key;
            LinkedList<String> result = new LinkedList<String>();
            TreeMap<String, Integer> mapCounter = new TreeMap<String, Integer>();
            TreeMap<String, Integer> entryCounter = new TreeMap<String, Integer>();
            for (LazyResettableHashMap<?> lazyResettableHashMap : all) {
                key = lazyResettableHashMap.displayName;
                if (!mapCounter.containsKey(key)) {
                    mapCounter.put(key, 0);
                    entryCounter.put(key, 0);
                }
                mapCounter.put(key, (Integer)mapCounter.get(key) + 1);
                entryCounter.put(key, (Integer)entryCounter.get(key) + lazyResettableHashMap.size());
            }
            for (Map.Entry entry : mapCounter.entrySet()) {
                key = (String)entry.getKey();
                result.add(entry.getValue() + " " + key + " with " + entryCounter.get(key) + " entries total");
            }
            return result;
        }
        return null;
    }
}

