/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.map;

import edu.berkeley.nlp.lm.collections.Iterators;
import edu.berkeley.nlp.lm.map.AbstractNgramMap;
import edu.berkeley.nlp.lm.map.HashMap;
import java.io.Serializable;
import java.util.Iterator;

final class UnigramHashMap
implements Serializable,
HashMap {
    public static long EMPTY_KEY = -1L;
    private static final long serialVersionUID = 1L;
    private final long numWords;
    private final AbstractNgramMap<?> ngramMap;

    public UnigramHashMap(long numWords, AbstractNgramMap<?> ngramMap) {
        this.numWords = numWords;
        this.ngramMap = ngramMap;
    }

    @Override
    public long put(long key) {
        return this.ngramMap.wordOf(key);
    }

    @Override
    public final long getOffset(long key) {
        long word = this.ngramMap.wordOf(key);
        return word < 0L || word >= this.numWords ? EMPTY_KEY : word;
    }

    @Override
    public long getKey(long contextOffset) {
        return this.ngramMap.combineToKey((int)contextOffset, 0L);
    }

    @Override
    public boolean isEmptyKey(long key) {
        return key == EMPTY_KEY;
    }

    @Override
    public long size() {
        return this.numWords;
    }

    @Override
    public Iterable<Long> keys() {
        return Iterators.able(new RangeIterator(this.numWords));
    }

    @Override
    public double getLoadFactor() {
        return 1.0;
    }

    @Override
    public long getCapacity() {
        return this.numWords;
    }

    @Override
    public boolean hasContexts(int word) {
        return word >= 0 || (long)word < this.numWords;
    }

    private static class RangeIterator
    implements Iterator<Long> {
        private final long numWords;
        private long i = 0L;

        public RangeIterator(long numWords) {
            this.numWords = numWords;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.numWords;
        }

        @Override
        public Long next() {
            return this.i++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method not yet implemented");
        }
    }
}

