/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring.namespace;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.annotations.DataTransferObject;
import org.directwebremoting.annotations.GlobalFilter;
import org.directwebremoting.annotations.RemoteProxy;
import org.directwebremoting.spring.DwrClassPathBeanDefinitionScanner;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AnnotationScannerParser
implements BeanDefinitionParser {
    private static final Log log = LogFactory.getLog(AnnotationScannerParser.class);
    private boolean scanFilters = true;
    private boolean scanProxies = true;
    private boolean scanConverters = true;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String filters;
        String conv;
        String proxies;
        String regex;
        DwrClassPathBeanDefinitionScanner scanner = new DwrClassPathBeanDefinitionScanner(parserContext.getRegistry());
        String basePackage = element.getAttribute("base-package");
        scanner.setBeanNameGenerator((BeanNameGenerator)new DefaultBeanNameGenerator());
        if (!StringUtils.hasText((String)basePackage) && log.isInfoEnabled()) {
            log.info((Object)"No base package defined for classpath scanning. Traversing the whole JVM classpath");
        }
        if (StringUtils.hasText((String)(regex = element.getAttribute("regex")))) {
            scanner.addIncludeFilter((TypeFilter)new RegexPatternTypeFilter(Pattern.compile(regex)));
        }
        if (StringUtils.hasText((String)(proxies = element.getAttribute("scanRemoteProxy"))) && ("TRUE".equals(proxies.toUpperCase()) || "FALSE".equals(proxies.toUpperCase()))) {
            this.scanProxies = Boolean.parseBoolean(proxies);
        }
        if (this.scanProxies) {
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(RemoteProxy.class));
        }
        if (StringUtils.hasText((String)(conv = element.getAttribute("scanDataTransferObject"))) && ("TRUE".equals(conv.toUpperCase()) || "FALSE".equals(conv.toUpperCase()))) {
            this.scanConverters = Boolean.parseBoolean(conv);
        }
        if (this.scanConverters) {
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(DataTransferObject.class));
        }
        if (StringUtils.hasText((String)(filters = element.getAttribute("scanGlobalFilter"))) && ("TRUE".equals(filters.toUpperCase()) || "FALSE".equals(filters.toUpperCase()))) {
            this.scanFilters = Boolean.parseBoolean(filters);
        }
        if (this.scanFilters) {
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(GlobalFilter.class));
        }
        if (this.scanProxies | this.scanConverters | this.scanFilters) {
            scanner.scan(new String[]{basePackage == null ? "" : basePackage});
        } else {
            log.warn((Object)"Scan is not required if all @RemoteProxy, @DataTransferObject and @GlobalFilter are disabled. Skipping detection");
        }
        return null;
    }
}

