/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.zeroc.Ice.Identity;
import com.zeroc.Ice.ToStringMode;
import com.zeroc.Ice.Util;
import com.zeroc.IceGrid.AdapterInfo;
import com.zeroc.IceGrid.ObjectDescriptor;
import com.zeroc.IceGrid.ObjectInfo;
import com.zeroc.IceGrid.PropertyDescriptor;
import com.zeroc.IceGridGUI.Utils;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class TableField
extends JTable {
    private DefaultTableModel _model;
    private Vector<String> _columnNames;

    public TableField(String ... columns) {
        this._columnNames = new Vector(columns.length);
        for (String name : columns) {
            this._columnNames.add(name);
        }
        int fontSize = this.getFont().getSize();
        int minRowHeight = fontSize + fontSize / 3;
        if (this.rowHeight < minRowHeight) {
            this.setRowHeight(minRowHeight);
        }
        this.init();
    }

    private void init() {
        this._model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.setModel(this._model);
        this.setCellSelectionEnabled(false);
        this.setOpaque(false);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
    }

    public void setProperties(List<PropertyDescriptor> properties, Utils.Resolver resolver) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (PropertyDescriptor p : properties) {
            map.put(resolver.substitute(p.name), resolver.substitute(p.value));
        }
        this.setSortedMap(map);
    }

    public void setObjects(List<ObjectDescriptor> objects, Utils.Resolver resolver) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (ObjectDescriptor p : objects) {
            Identity id = new Identity(resolver.substitute(p.id.name), resolver.substitute(p.id.category));
            map.put(Util.identityToString((Identity)id, (ToStringMode)ToStringMode.Unicode), resolver.substitute(p.type));
        }
        this.setSortedMap(map);
    }

    public void setObjects(SortedMap<String, ObjectInfo> objects) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (ObjectInfo p : objects.values()) {
            map.put(p.proxy.toString(), p.type);
        }
        this.setSortedMap(map);
    }

    public void setEnvs(List<String> envs, Utils.Resolver resolver) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String p : envs) {
            String env = resolver.substitute(p);
            int equal = env.indexOf(61);
            if (equal == -1 || equal == env.length() - 1) {
                map.put(env, "");
                continue;
            }
            map.put(env.substring(0, equal), env.substring(equal + 1));
        }
        this.setSortedMap(map);
    }

    public void setAdapters(SortedMap<String, AdapterInfo> adapters) {
        Vector vector = new Vector(adapters.size());
        for (Map.Entry<String, AdapterInfo> p : adapters.entrySet()) {
            Vector<String> row = new Vector<String>(3);
            row.add(p.getKey());
            AdapterInfo ai = p.getValue();
            if (ai.proxy == null) {
                row.add("");
            } else {
                String str = ai.proxy.toString();
                int index = str.indexOf(58);
                if (index == -1 || index == str.length() - 1) {
                    row.add("");
                } else {
                    row.add(str.substring(index + 1));
                }
            }
            row.add(ai.replicaGroupId);
            vector.add(row);
        }
        this._model.setDataVector(vector, this._columnNames);
        DefaultTableCellRenderer cr = (DefaultTableCellRenderer)this.getDefaultRenderer(String.class);
        cr.setOpaque(false);
    }

    public void setSortedMap(SortedMap<String, String> map) {
        Vector vector = new Vector(map.size());
        for (Map.Entry<String, String> p : map.entrySet()) {
            Vector<String> row = new Vector<String>(2);
            row.add(p.getKey());
            row.add(p.getValue());
            vector.add(row);
        }
        this._model.setDataVector(vector, this._columnNames);
        DefaultTableCellRenderer cr = (DefaultTableCellRenderer)this.getDefaultRenderer(String.class);
        cr.setOpaque(false);
    }

    public void clear() {
        this._model.setDataVector(new Vector(), this._columnNames);
        DefaultTableCellRenderer cr = (DefaultTableCellRenderer)this.getDefaultRenderer(String.class);
        cr.setOpaque(false);
    }
}

