/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class CoordinationMetaData
implements Writeable,
ToXContentFragment {
    public static final CoordinationMetaData EMPTY_META_DATA = CoordinationMetaData.builder().build();
    private final long term;
    private final VotingConfiguration lastCommittedConfiguration;
    private final VotingConfiguration lastAcceptedConfiguration;
    private final Set<VotingConfigExclusion> votingConfigExclusions;
    private static final ParseField TERM_PARSE_FIELD = new ParseField("term", new String[0]);
    private static final ParseField LAST_COMMITTED_CONFIGURATION_FIELD = new ParseField("last_committed_config", new String[0]);
    private static final ParseField LAST_ACCEPTED_CONFIGURATION_FIELD = new ParseField("last_accepted_config", new String[0]);
    private static final ParseField VOTING_CONFIG_EXCLUSIONS_FIELD = new ParseField("voting_config_exclusions", new String[0]);
    private static final ConstructingObjectParser<CoordinationMetaData, Void> PARSER = new ConstructingObjectParser("coordination_metadata", fields -> new CoordinationMetaData(CoordinationMetaData.term(fields), CoordinationMetaData.lastCommittedConfig(fields), CoordinationMetaData.lastAcceptedConfig(fields), CoordinationMetaData.votingConfigExclusions(fields)));

    private static long term(Object[] termAndConfigs) {
        return (Long)termAndConfigs[0];
    }

    private static VotingConfiguration lastCommittedConfig(Object[] fields) {
        List nodeIds = (List)fields[1];
        return new VotingConfiguration(new HashSet<String>(nodeIds));
    }

    private static VotingConfiguration lastAcceptedConfig(Object[] fields) {
        List nodeIds = (List)fields[2];
        return new VotingConfiguration(new HashSet<String>(nodeIds));
    }

    private static Set<VotingConfigExclusion> votingConfigExclusions(Object[] fields) {
        HashSet<VotingConfigExclusion> votingTombstones = new HashSet<VotingConfigExclusion>((List)fields[3]);
        return votingTombstones;
    }

    public CoordinationMetaData(long term, VotingConfiguration lastCommittedConfiguration, VotingConfiguration lastAcceptedConfiguration, Set<VotingConfigExclusion> votingConfigExclusions) {
        this.term = term;
        this.lastCommittedConfiguration = lastCommittedConfiguration;
        this.lastAcceptedConfiguration = lastAcceptedConfiguration;
        this.votingConfigExclusions = Collections.unmodifiableSet(new HashSet<VotingConfigExclusion>(votingConfigExclusions));
    }

    public CoordinationMetaData(StreamInput in) throws IOException {
        this.term = in.readLong();
        this.lastCommittedConfiguration = new VotingConfiguration(in);
        this.lastAcceptedConfiguration = new VotingConfiguration(in);
        this.votingConfigExclusions = Collections.unmodifiableSet(in.readSet(VotingConfigExclusion::new));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CoordinationMetaData coordinationMetaData) {
        return new Builder(coordinationMetaData);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.term);
        this.lastCommittedConfiguration.writeTo(out);
        this.lastAcceptedConfiguration.writeTo(out);
        out.writeCollection(this.votingConfigExclusions);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(TERM_PARSE_FIELD.getPreferredName(), this.term).field(LAST_COMMITTED_CONFIGURATION_FIELD.getPreferredName(), (ToXContent)this.lastCommittedConfiguration).field(LAST_ACCEPTED_CONFIGURATION_FIELD.getPreferredName(), (ToXContent)this.lastAcceptedConfiguration).field(VOTING_CONFIG_EXCLUSIONS_FIELD.getPreferredName(), this.votingConfigExclusions);
    }

    public static CoordinationMetaData fromXContent(XContentParser parser) throws IOException {
        return (CoordinationMetaData)PARSER.parse(parser, null);
    }

    public long term() {
        return this.term;
    }

    public VotingConfiguration getLastAcceptedConfiguration() {
        return this.lastAcceptedConfiguration;
    }

    public VotingConfiguration getLastCommittedConfiguration() {
        return this.lastCommittedConfiguration;
    }

    public Set<VotingConfigExclusion> getVotingConfigExclusions() {
        return this.votingConfigExclusions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CoordinationMetaData)) {
            return false;
        }
        CoordinationMetaData that = (CoordinationMetaData)o;
        if (this.term != that.term) {
            return false;
        }
        if (!this.lastCommittedConfiguration.equals(that.lastCommittedConfiguration)) {
            return false;
        }
        if (!this.lastAcceptedConfiguration.equals(that.lastAcceptedConfiguration)) {
            return false;
        }
        return this.votingConfigExclusions.equals(that.votingConfigExclusions);
    }

    public int hashCode() {
        int result = (int)(this.term ^ this.term >>> 32);
        result = 31 * result + this.lastCommittedConfiguration.hashCode();
        result = 31 * result + this.lastAcceptedConfiguration.hashCode();
        result = 31 * result + this.votingConfigExclusions.hashCode();
        return result;
    }

    public String toString() {
        return "CoordinationMetaData{term=" + this.term + ", lastCommittedConfiguration=" + this.lastCommittedConfiguration + ", lastAcceptedConfiguration=" + this.lastAcceptedConfiguration + ", votingConfigExclusions=" + this.votingConfigExclusions + '}';
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TERM_PARSE_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), LAST_COMMITTED_CONFIGURATION_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), LAST_ACCEPTED_CONFIGURATION_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (ContextParser)VotingConfigExclusion.PARSER, VOTING_CONFIG_EXCLUSIONS_FIELD);
    }

    public static class VotingConfiguration
    implements Writeable,
    ToXContentFragment {
        public static final VotingConfiguration EMPTY_CONFIG = new VotingConfiguration(Collections.emptySet());
        public static final VotingConfiguration MUST_JOIN_ELECTED_MASTER = new VotingConfiguration(Collections.singleton("_must_join_elected_master_"));
        private final Set<String> nodeIds;

        public VotingConfiguration(Set<String> nodeIds) {
            this.nodeIds = Collections.unmodifiableSet(new HashSet<String>(nodeIds));
        }

        public VotingConfiguration(StreamInput in) throws IOException {
            this.nodeIds = Collections.unmodifiableSet(Sets.newHashSet(in.readStringArray()));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringArray(this.nodeIds.toArray(new String[this.nodeIds.size()]));
        }

        public boolean hasQuorum(Collection<String> votes) {
            HashSet<String> intersection = new HashSet<String>(this.nodeIds);
            intersection.retainAll(votes);
            return intersection.size() * 2 > this.nodeIds.size();
        }

        public Set<String> getNodeIds() {
            return this.nodeIds;
        }

        public String toString() {
            return "VotingConfiguration{" + String.join((CharSequence)",", this.nodeIds) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VotingConfiguration that = (VotingConfiguration)o;
            return Objects.equals(this.nodeIds, that.nodeIds);
        }

        public int hashCode() {
            return Objects.hash(this.nodeIds);
        }

        public boolean isEmpty() {
            return this.nodeIds.isEmpty();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray();
            for (String nodeId : this.nodeIds) {
                builder.value(nodeId);
            }
            return builder.endArray();
        }

        public static VotingConfiguration of(DiscoveryNode ... nodes) {
            return new VotingConfiguration(Arrays.stream(nodes).map(DiscoveryNode::getId).collect(Collectors.toSet()));
        }
    }

    public static class VotingConfigExclusion
    implements Writeable,
    ToXContentFragment {
        private final String nodeId;
        private final String nodeName;
        private static final ParseField NODE_ID_PARSE_FIELD = new ParseField("node_id", new String[0]);
        private static final ParseField NODE_NAME_PARSE_FIELD = new ParseField("node_name", new String[0]);
        private static final ConstructingObjectParser<VotingConfigExclusion, Void> PARSER = new ConstructingObjectParser("voting_config_exclusion", nodeIdAndName -> new VotingConfigExclusion(VotingConfigExclusion.nodeId(nodeIdAndName), VotingConfigExclusion.nodeName(nodeIdAndName)));

        public VotingConfigExclusion(DiscoveryNode node) {
            this(node.getId(), node.getName());
        }

        public VotingConfigExclusion(StreamInput in) throws IOException {
            this.nodeId = in.readString();
            this.nodeName = in.readString();
        }

        public VotingConfigExclusion(String nodeId, String nodeName) {
            this.nodeId = nodeId;
            this.nodeName = nodeName;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeString(this.nodeName);
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        private static String nodeId(Object[] nodeIdAndName) {
            return (String)nodeIdAndName[0];
        }

        private static String nodeName(Object[] nodeIdAndName) {
            return (String)nodeIdAndName[1];
        }

        public static VotingConfigExclusion fromXContent(XContentParser parser) throws IOException {
            return (VotingConfigExclusion)PARSER.parse(parser, null);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(NODE_ID_PARSE_FIELD.getPreferredName(), this.nodeId).field(NODE_NAME_PARSE_FIELD.getPreferredName(), this.nodeName).endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VotingConfigExclusion that = (VotingConfigExclusion)o;
            return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.nodeName, that.nodeName);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.nodeName);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.nodeName.length() > 0) {
                sb.append('{').append(this.nodeName).append('}');
            }
            sb.append('{').append(this.nodeId).append('}');
            return sb.toString();
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), NODE_ID_PARSE_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), NODE_NAME_PARSE_FIELD);
        }
    }

    public static class Builder {
        private long term = 0L;
        private VotingConfiguration lastCommittedConfiguration = VotingConfiguration.EMPTY_CONFIG;
        private VotingConfiguration lastAcceptedConfiguration = VotingConfiguration.EMPTY_CONFIG;
        private final Set<VotingConfigExclusion> votingConfigExclusions = new HashSet<VotingConfigExclusion>();

        public Builder() {
        }

        public Builder(CoordinationMetaData state) {
            this.term = state.term;
            this.lastCommittedConfiguration = state.lastCommittedConfiguration;
            this.lastAcceptedConfiguration = state.lastAcceptedConfiguration;
            this.votingConfigExclusions.addAll(state.votingConfigExclusions);
        }

        public Builder term(long term) {
            this.term = term;
            return this;
        }

        public Builder lastCommittedConfiguration(VotingConfiguration config) {
            this.lastCommittedConfiguration = config;
            return this;
        }

        public Builder lastAcceptedConfiguration(VotingConfiguration config) {
            this.lastAcceptedConfiguration = config;
            return this;
        }

        public Builder addVotingConfigExclusion(VotingConfigExclusion exclusion) {
            this.votingConfigExclusions.add(exclusion);
            return this;
        }

        public Builder clearVotingConfigExclusions() {
            this.votingConfigExclusions.clear();
            return this;
        }

        public CoordinationMetaData build() {
            return new CoordinationMetaData(this.term, this.lastCommittedConfiguration, this.lastAcceptedConfiguration, this.votingConfigExclusions);
        }
    }
}

