/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.io;

import java.io.IOException;
import java.io.OutputStream;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.io.TextStream;

public class LineBufferingOutputStream
extends OutputStream {
    private static final int LINE_MAX_LENGTH = 0x100000;
    private boolean hasBeenClosed;
    private final TextStream handler;
    private StreamByteBuffer buffer;
    private final OutputStream output;
    private final byte lastLineSeparatorByte;
    private final int lineMaxLength;
    private int counter;

    public LineBufferingOutputStream(TextStream handler) {
        this(handler, 2048);
    }

    public LineBufferingOutputStream(TextStream handler, int bufferLength) {
        this(handler, bufferLength, 0x100000);
    }

    public LineBufferingOutputStream(TextStream handler, int bufferLength, int lineMaxLength) {
        this.handler = handler;
        this.buffer = new StreamByteBuffer(bufferLength);
        this.lineMaxLength = lineMaxLength;
        this.output = this.buffer.getOutputStream();
        byte[] lineSeparator = SystemProperties.getInstance().getLineSeparator().getBytes();
        this.lastLineSeparatorByte = lineSeparator[lineSeparator.length - 1];
    }

    @Override
    public void close() throws IOException {
        this.hasBeenClosed = true;
        this.flush();
        this.handler.endOfStream(null);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.hasBeenClosed) {
            throw new IOException("The stream has been closed.");
        }
        this.output.write(b);
        ++this.counter;
        if (this.endsWithLineSeparator(b) || this.counter >= this.lineMaxLength) {
            this.flush();
        }
    }

    private boolean endsWithLineSeparator(int b) {
        byte currentByte = (byte)(b & 0xFF);
        return currentByte == this.lastLineSeparatorByte || currentByte == 10;
    }

    @Override
    public void flush() {
        String text = this.buffer.readAsString();
        if (text.length() > 0) {
            this.handler.text(text);
        }
        this.counter = 0;
    }
}

