/*
 * Decompiled with CFR 0.152.
 */
package org.grails.spring.context.support;

import grails.core.DefaultGrailsApplication;
import grails.core.GrailsApplication;
import grails.core.GrailsApplicationClass;
import grails.core.support.GrailsApplicationAware;
import grails.plugins.GrailsPlugin;
import grails.plugins.GrailsPluginManager;
import grails.plugins.PluginManagerAware;
import grails.util.BuildSettings;
import grails.util.CacheEntry;
import grails.util.Environment;
import grails.util.GrailsStringUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.grails.core.io.CachingPathMatchingResourcePatternResolver;
import org.grails.core.support.internal.tools.ClassRelativeResourcePatternResolver;
import org.grails.plugins.BinaryGrailsPlugin;
import org.grails.spring.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class PluginAwareResourceBundleMessageSource
extends ReloadableResourceBundleMessageSource
implements GrailsApplicationAware,
PluginManagerAware,
InitializingBean {
    private static final String GRAILS_APP_I18N_PATH_COMPONENT = "/grails-app/i18n/";
    protected GrailsApplication application;
    protected GrailsPluginManager pluginManager;
    protected List<String> pluginBaseNames = new ArrayList<String>();
    private ResourceLoader localResourceLoader;
    private PathMatchingResourcePatternResolver resourceResolver;
    private ConcurrentMap<Locale, CacheEntry<ReloadableResourceBundleMessageSource.PropertiesHolder>> cachedMergedPluginProperties = new ConcurrentHashMap<Locale, CacheEntry<ReloadableResourceBundleMessageSource.PropertiesHolder>>();
    private ConcurrentMap<Locale, CacheEntry<ReloadableResourceBundleMessageSource.PropertiesHolder>> cachedMergedBinaryPluginProperties = new ConcurrentHashMap<Locale, CacheEntry<ReloadableResourceBundleMessageSource.PropertiesHolder>>();
    private long pluginCacheMillis = Long.MIN_VALUE;
    private boolean searchClasspath = false;
    private String messageBundleLocationPattern = "classpath*:*.properties";

    public PluginAwareResourceBundleMessageSource() {
    }

    public PluginAwareResourceBundleMessageSource(GrailsApplication application, GrailsPluginManager pluginManager) {
        this.application = application;
        this.pluginManager = pluginManager;
    }

    @Override
    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.application = grailsApplication;
    }

    @Override
    public void setPluginManager(GrailsPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void setResourceResolver(PathMatchingResourcePatternResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public void afterPropertiesSet() throws Exception {
        Resource[] resources;
        if (this.pluginCacheMillis == Long.MIN_VALUE) {
            this.pluginCacheMillis = this.cacheMillis;
        }
        if (this.localResourceLoader == null) {
            return;
        }
        if (Environment.isDevelopmentEnvironmentAvailable()) {
            File[] propertiesFiles = new File(BuildSettings.BASE_DIR, GRAILS_APP_I18N_PATH_COMPONENT).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".properties");
                }
            });
            if (propertiesFiles != null && propertiesFiles.length > 0) {
                ArrayList<FileSystemResource> resourceList = new ArrayList<FileSystemResource>(propertiesFiles.length);
                for (File propertiesFile : propertiesFiles) {
                    resourceList.add(new FileSystemResource(propertiesFile));
                }
                resources = resourceList.toArray(new Resource[resourceList.size()]);
            } else {
                resources = new Resource[]{};
            }
        } else if (this.searchClasspath) {
            resources = this.resourceResolver.getResources(this.messageBundleLocationPattern);
        } else {
            DefaultGrailsApplication defaultGrailsApplication = (DefaultGrailsApplication)this.application;
            if (defaultGrailsApplication != null) {
                GrailsApplicationClass applicationClass = defaultGrailsApplication.getApplicationClass();
                if (applicationClass != null) {
                    ClassRelativeResourcePatternResolver resourcePatternResolver = new ClassRelativeResourcePatternResolver(applicationClass.getClass());
                    resources = resourcePatternResolver.getResources(this.messageBundleLocationPattern);
                } else {
                    resources = this.resourceResolver.getResources(this.messageBundleLocationPattern);
                }
            } else {
                resources = this.resourceResolver.getResources(this.messageBundleLocationPattern);
            }
        }
        ArrayList<String> basenames = new ArrayList<String>();
        for (Resource resource : resources) {
            String filename = resource.getFilename();
            String baseName = GrailsStringUtils.getFileBasename(filename);
            int i = baseName.indexOf(95);
            if (i > -1) {
                baseName = baseName.substring(0, i);
            }
            if (basenames.contains(baseName) || baseName.equals("")) continue;
            basenames.add(baseName);
        }
        this.setBasenames(basenames.toArray(new String[basenames.size()]));
    }

    @Override
    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        String msg = super.resolveCodeWithoutArguments(code, locale);
        return msg == null ? this.resolveCodeWithoutArgumentsFromPlugins(code, locale) : msg;
    }

    @Override
    protected MessageFormat resolveCode(String code, Locale locale) {
        MessageFormat mf = super.resolveCode(code, locale);
        return mf == null ? this.resolveCodeFromPlugins(code, locale) : mf;
    }

    protected ReloadableResourceBundleMessageSource.PropertiesHolder getMergedPluginProperties(final Locale locale) {
        return CacheEntry.getValue(this.cachedMergedPluginProperties, locale, this.cacheMillis, new Callable<ReloadableResourceBundleMessageSource.PropertiesHolder>(){

            @Override
            public ReloadableResourceBundleMessageSource.PropertiesHolder call() throws Exception {
                Properties mergedProps = new Properties();
                ReloadableResourceBundleMessageSource.PropertiesHolder mergedHolder = new ReloadableResourceBundleMessageSource.PropertiesHolder(mergedProps);
                PluginAwareResourceBundleMessageSource.this.mergeBinaryPluginProperties(locale, mergedProps);
                return mergedHolder;
            }
        });
    }

    protected String resolveCodeWithoutArgumentsFromPlugins(String code, Locale locale) {
        if (this.pluginCacheMillis < 0L) {
            ReloadableResourceBundleMessageSource.PropertiesHolder propHolder = this.getMergedPluginProperties(locale);
            String result = propHolder.getProperty(code);
            if (result != null) {
                return result;
            }
        } else {
            String result = this.findCodeInBinaryPlugins(code, locale);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    protected ReloadableResourceBundleMessageSource.PropertiesHolder getMergedBinaryPluginProperties(final Locale locale) {
        return CacheEntry.getValue(this.cachedMergedBinaryPluginProperties, locale, this.cacheMillis, new Callable<ReloadableResourceBundleMessageSource.PropertiesHolder>(){

            @Override
            public ReloadableResourceBundleMessageSource.PropertiesHolder call() throws Exception {
                Properties mergedProps = new Properties();
                ReloadableResourceBundleMessageSource.PropertiesHolder mergedHolder = new ReloadableResourceBundleMessageSource.PropertiesHolder(mergedProps);
                PluginAwareResourceBundleMessageSource.this.mergeBinaryPluginProperties(locale, mergedProps);
                return mergedHolder;
            }
        });
    }

    protected void mergeBinaryPluginProperties(Locale locale, Properties mergedProps) {
        GrailsPlugin[] allPlugins;
        for (GrailsPlugin plugin : allPlugins = this.pluginManager.getAllPlugins()) {
            BinaryGrailsPlugin binaryPlugin;
            Properties binaryPluginProperties;
            if (!(plugin instanceof BinaryGrailsPlugin) || (binaryPluginProperties = (binaryPlugin = (BinaryGrailsPlugin)plugin).getProperties(locale)) == null) continue;
            mergedProps.putAll((Map<?, ?>)binaryPluginProperties);
        }
    }

    private String findCodeInBinaryPlugins(String code, Locale locale) {
        return this.getMergedBinaryPluginProperties(locale).getProperty(code);
    }

    private MessageFormat findMessageFormatInBinaryPlugins(String code, Locale locale) {
        return this.getMergedBinaryPluginProperties(locale).getMessageFormat(code, locale);
    }

    protected MessageFormat resolveCodeFromPlugins(String code, Locale locale) {
        if (this.pluginCacheMillis < 0L) {
            ReloadableResourceBundleMessageSource.PropertiesHolder propHolder = this.getMergedPluginProperties(locale);
            MessageFormat result = propHolder.getMessageFormat(code, locale);
            if (result != null) {
                return result;
            }
        } else {
            MessageFormat result = this.findMessageFormatInBinaryPlugins(code, locale);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        super.setResourceLoader(resourceLoader);
        this.localResourceLoader = resourceLoader;
        if (this.resourceResolver == null) {
            this.resourceResolver = new CachingPathMatchingResourcePatternResolver(this.localResourceLoader);
        }
    }

    public void setPluginCacheSeconds(int pluginCacheSeconds) {
        this.pluginCacheMillis = pluginCacheSeconds * 1000;
    }

    public void setSearchClasspath(boolean searchClasspath) {
        this.searchClasspath = searchClasspath;
    }

    public void setMessageBundleLocationPattern(String messageBundleLocationPattern) {
        this.messageBundleLocationPattern = messageBundleLocationPattern;
    }
}

