/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public enum Compression {
    NONE,
    BZIP2,
    GZIP,
    ZIP,
    XZ;


    public static Compression byExtension(String name) {
        return name != null && name.endsWith(".gz") ? GZIP : (name != null && (name.endsWith(".bz2") || name.endsWith(".bz")) ? BZIP2 : (name != null && name.endsWith(".zip") ? ZIP : (name != null && name.endsWith(".xz") ? XZ : NONE)));
    }

    public static Compression forContentType(String contentType) {
        switch (contentType) {
            case "application/zip": {
                return ZIP;
            }
            case "application/x-gzip": {
                return GZIP;
            }
            case "application/x-bzip2": {
                return BZIP2;
            }
            case "application/x-xz": {
                return XZ;
            }
        }
        return NONE;
    }

    public InputStream getUncompressedInputStream(InputStream in) throws IOException {
        switch (this) {
            case BZIP2: {
                return Compression.getBZip2InputStream(in);
            }
            case GZIP: {
                return Compression.getGZipInputStream(in);
            }
            case ZIP: {
                return Compression.getZipInputStream(in);
            }
            case XZ: {
                return Compression.getXZInputStream(in);
            }
        }
        return in;
    }

    public static XZCompressorInputStream getXZInputStream(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        return new XZCompressorInputStream(in, true);
    }

    public static BZip2CompressorInputStream getBZip2InputStream(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        return new BZip2CompressorInputStream(in, true);
    }

    public static GZIPInputStream getGZipInputStream(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        return new GZIPInputStream(in);
    }

    public static ZipInputStream getZipInputStream(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        ZipInputStream zis = new ZipInputStream(in, StandardCharsets.UTF_8);
        ZipEntry ze = zis.getNextEntry();
        if (ze != null && Logging.isDebugEnabled()) {
            Logging.debug("Zip entry: {0}", ze.getName());
        }
        return zis;
    }

    public static InputStream getUncompressedFileInputStream(File file) throws IOException {
        try {
            InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                return Compression.byExtension(file.getName()).getUncompressedInputStream(in);
            }
            catch (IOException e) {
                Utils.close(in);
                throw e;
            }
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    public OutputStream getCompressedOutputStream(OutputStream out) throws IOException {
        switch (this) {
            case BZIP2: {
                return new BZip2CompressorOutputStream(out);
            }
            case GZIP: {
                return new GZIPOutputStream(out);
            }
            case ZIP: {
                return new ZipOutputStream(out, StandardCharsets.UTF_8);
            }
            case XZ: {
                return new XZCompressorOutputStream(out);
            }
        }
        return out;
    }

    public static OutputStream getCompressedFileOutputStream(File file) throws IOException {
        OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);
        try {
            return Compression.byExtension(file.getName()).getCompressedOutputStream(out);
        }
        catch (IOException e) {
            Utils.close(out);
            throw e;
        }
    }
}

