/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Signature;
import java.lang.invoke.MethodHandle;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.Bootstrap;
import org.jruby.ir.targets.ClassData;
import org.jruby.ir.targets.ConstantLookupSite;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.YieldSite;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CompiledIRBlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.RegexpOptions;

public class IRBytecodeAdapter6
extends IRBytecodeAdapter {
    public static final String SUPER_SPLAT_UNRESOLVED = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, JVM.OBJECT_ARRAY, Block.class, boolean[].class));
    public static final String SUPER_NOSPLAT_UNRESOLVED = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, JVM.OBJECT_ARRAY, Block.class));
    public static final String SUPER_SPLAT_RESOLVED = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, RubyModule.class, JVM.OBJECT_ARRAY, Block.class, boolean[].class));
    public static final String SUPER_NOSPLAT_RESOLVED = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, RubyModule.class, JVM.OBJECT_ARRAY, Block.class));
    private final Runnable LOAD_CONTEXT = new Runnable(){

        @Override
        public void run() {
            IRBytecodeAdapter6.this.loadContext();
        }
    };
    private final Map<Object, String> cacheFieldNames = new HashMap<Object, String>();

    public IRBytecodeAdapter6(SkinnyMethodAdapter adapter, Signature signature, ClassData classData) {
        super(adapter, signature, classData);
    }

    @Override
    public void pushFixnum(final long l) {
        this.cacheValuePermanentlyLoadContext("fixnum", RubyFixnum.class, IRBytecodeAdapter6.keyFor("fixnum", (Object)l), new Runnable(){

            @Override
            public void run() {
                IRBytecodeAdapter6.this.loadRuntime();
                IRBytecodeAdapter6.this.adapter.ldc(l);
                IRBytecodeAdapter6.this.adapter.invokevirtual(CodegenUtils.p(Ruby.class), "newFixnum", CodegenUtils.sig(RubyFixnum.class, Long.TYPE));
            }
        });
    }

    @Override
    public void pushFloat(final double d) {
        this.cacheValuePermanentlyLoadContext("float", RubyFloat.class, IRBytecodeAdapter6.keyFor("float", (Object)Double.doubleToLongBits(d)), new Runnable(){

            @Override
            public void run() {
                IRBytecodeAdapter6.this.loadRuntime();
                IRBytecodeAdapter6.this.adapter.ldc(d);
                IRBytecodeAdapter6.this.adapter.invokevirtual(CodegenUtils.p(Ruby.class), "newFloat", CodegenUtils.sig(RubyFloat.class, Double.TYPE));
            }
        });
    }

    @Override
    public void pushString(ByteList bl, int cr) {
        this.loadRuntime();
        this.pushByteList(bl);
        this.adapter.ldc(cr);
        this.adapter.invokestatic(CodegenUtils.p(RubyString.class), "newStringShared", CodegenUtils.sig(RubyString.class, Ruby.class, ByteList.class, Integer.TYPE));
    }

    private String newFieldName(String baseName) {
        return baseName + this.getClassData().callSiteCount.getAndIncrement();
    }

    @Override
    public void pushFrozenString(final ByteList bl, final int cr, final String file2, final int line) {
        this.cacheValuePermanentlyLoadContext("fstring", RubyString.class, IRBytecodeAdapter6.keyFor("fstring", (Object)bl), new Runnable(){

            @Override
            public void run() {
                IRBytecodeAdapter6.this.loadContext();
                IRBytecodeAdapter6.this.adapter.ldc(bl.toString());
                IRBytecodeAdapter6.this.adapter.ldc(bl.getEncoding().toString());
                IRBytecodeAdapter6.this.adapter.ldc(cr);
                IRBytecodeAdapter6.this.adapter.ldc(file2);
                IRBytecodeAdapter6.this.adapter.ldc(line);
                IRBytecodeAdapter6.this.invokeIRHelper("newFrozenStringFromRaw", CodegenUtils.sig(RubyString.class, ThreadContext.class, String.class, String.class, Integer.TYPE, String.class, Integer.TYPE));
            }
        });
    }

    @Override
    public void pushByteList(final ByteList bl) {
        this.cacheValuePermanentlyLoadContext("bytelist", ByteList.class, IRBytecodeAdapter6.keyFor("bytelist", (Object)bl), new Runnable(){

            @Override
            public void run() {
                IRBytecodeAdapter6.this.loadRuntime();
                IRBytecodeAdapter6.this.adapter.ldc(bl.toString());
                IRBytecodeAdapter6.this.adapter.ldc(bl.getEncoding().toString());
                IRBytecodeAdapter6.this.invokeIRHelper("newByteListFromRaw", CodegenUtils.sig(ByteList.class, Ruby.class, String.class, String.class));
            }
        });
    }

    public String cacheValuePermanentlyLoadContext(String what, Class type2, Object key2, Runnable construction) {
        return this.cacheValuePermanently(what, type2, key2, false, CodegenUtils.sig(type2, ThreadContext.class), this.LOAD_CONTEXT, construction);
    }

    public String cacheValuePermanently(String what, Class type2, Object key2, boolean sync2, Runnable construction) {
        return this.cacheValuePermanently(what, type2, key2, sync2, CodegenUtils.sig(type2, new Class[0]), null, construction);
    }

    public String cacheValuePermanently(String what, Class type2, Object key2, boolean sync2, String signature, Runnable loadState, Runnable construction) {
        String cacheField = key2 == null ? null : this.cacheFieldNames.get(key2);
        String clsName = this.getClassData().clsName;
        if (cacheField == null) {
            cacheField = this.newFieldName(what);
            this.cacheFieldNames.put(key2, cacheField);
            SkinnyMethodAdapter tmp = this.adapter;
            this.adapter = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, cacheField, signature, null, null);
            Label done = new Label();
            Label before = sync2 ? new Label() : null;
            Label after = sync2 ? new Label() : null;
            Label catchbody = sync2 ? new Label() : null;
            Label done2 = sync2 ? new Label() : null;
            this.adapter.getClassVisitor().visitField(10, cacheField, CodegenUtils.ci(type2), null, null).visitEnd();
            this.adapter.getstatic(clsName, cacheField, CodegenUtils.ci(type2));
            this.adapter.dup();
            this.adapter.ifnonnull(done);
            this.adapter.pop();
            Type classType = Type.getType("L" + clsName.replace('.', '/') + ';');
            int tempIndex = Type.getMethodType(signature).getArgumentsAndReturnSizes() >> 3;
            if (sync2) {
                this.adapter.ldc(classType);
                this.adapter.dup();
                this.adapter.astore(tempIndex);
                this.adapter.monitorenter();
                this.adapter.trycatch(before, after, catchbody, null);
                this.adapter.label(before);
                this.adapter.getstatic(clsName, cacheField, CodegenUtils.ci(type2));
                this.adapter.dup();
                this.adapter.ifnonnull(done2);
                this.adapter.pop();
            }
            construction.run();
            this.adapter.dup();
            this.adapter.putstatic(clsName, cacheField, CodegenUtils.ci(type2));
            if (sync2) {
                this.adapter.label(done2);
                this.adapter.aload(tempIndex);
                this.adapter.monitorexit();
                this.adapter.go_to(done);
                this.adapter.label(after);
                this.adapter.label(catchbody);
                this.adapter.aload(tempIndex);
                this.adapter.monitorexit();
                this.adapter.athrow();
            }
            this.adapter.label(done);
            this.adapter.areturn();
            this.adapter.end();
            this.adapter = tmp;
        }
        if (loadState != null) {
            loadState.run();
        }
        this.adapter.invokestatic(clsName, cacheField, signature);
        return cacheField;
    }

    @Override
    public void pushRegexp(final ByteList source2, final int options2) {
        this.cacheValuePermanentlyLoadContext("regexp", RubyRegexp.class, IRBytecodeAdapter6.keyFor("regexp", source2, options2), new Runnable(){

            @Override
            public void run() {
                IRBytecodeAdapter6.this.loadContext();
                IRBytecodeAdapter6.this.pushByteList(source2);
                IRBytecodeAdapter6.this.adapter.pushInt(options2);
                IRBytecodeAdapter6.this.invokeIRHelper("newLiteralRegexp", CodegenUtils.sig(RubyRegexp.class, ThreadContext.class, ByteList.class, Integer.TYPE));
            }
        });
    }

    private static String keyFor(Object obj1, Object obj2) {
        StringBuilder sb = new StringBuilder(16);
        IRBytecodeAdapter6.keyFor(sb, obj1);
        IRBytecodeAdapter6.keyFor(sb, obj2);
        return sb.toString();
    }

    private static String keyFor(Object obj1, Object obj2, Object obj3) {
        StringBuilder sb = new StringBuilder(24);
        IRBytecodeAdapter6.keyFor(sb, obj1);
        IRBytecodeAdapter6.keyFor(sb, obj2);
        IRBytecodeAdapter6.keyFor(sb, obj3);
        return sb.toString();
    }

    private static void keyFor(StringBuilder builder, Object obj) {
        builder.append(obj.toString());
        if (obj instanceof ByteList) {
            builder.append('_').append(((ByteList)obj).getEncoding());
        }
        builder.append('_');
    }

    @Override
    public void pushDRegexp(Runnable callback, RegexpOptions options2, int arity2) {
        if (arity2 > 250) {
            throw new NotCompilableException("dynamic regexp has more than 250 elements");
        }
        String incomingSig = CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, arity2, Integer.TYPE));
        ClassData classData = this.getClassData();
        String className = classData.clsName;
        String cacheField = "dregexp" + classData.callSiteCount.getAndIncrement();
        String atomicRefField = null;
        Label done = new Label();
        if (options2.isOnce()) {
            atomicRefField = this.cacheValuePermanently("atomicref", AtomicReference.class, cacheField, true, new Runnable(){

                @Override
                public void run() {
                    IRBytecodeAdapter6.this.adapter.newobj(CodegenUtils.p(AtomicReference.class));
                    IRBytecodeAdapter6.this.adapter.dup();
                    IRBytecodeAdapter6.this.adapter.invokespecial(CodegenUtils.p(AtomicReference.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
                }
            });
            this.adapter.invokevirtual(CodegenUtils.p(AtomicReference.class), "get", CodegenUtils.sig(Object.class, new Class[0]));
            this.adapter.dup();
            this.adapter.ifnonnull(done);
            this.adapter.pop();
            this.adapter.getstatic(className.replace('.', '/'), atomicRefField, CodegenUtils.ci(AtomicReference.class));
            this.adapter.aconst_null();
        }
        callback.run();
        this.adapter.ldc(options2.toEmbeddedOptions());
        if (arity2 >= 1 && arity2 <= 5) {
            this.invokeIRHelper("newDynamicRegexp", incomingSig);
        } else {
            String methodName = "dregexp" + arity2;
            if (!classData.dregexpMethodsDefined.contains(arity2)) {
                SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
                adapter2.aload(0);
                IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 1, arity2);
                adapter2.iload(1 + arity2);
                adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "newDynamicRegexp", CodegenUtils.sig(RubyRegexp.class, ThreadContext.class, IRubyObject[].class, Integer.TYPE));
                adapter2.areturn();
                adapter2.end();
                classData.dregexpMethodsDefined.add(arity2);
            }
            this.adapter.invokestatic(className, methodName, incomingSig);
        }
        if (options2.isOnce()) {
            this.adapter.invokevirtual(CodegenUtils.p(AtomicReference.class), "compareAndSet", CodegenUtils.sig(Boolean.TYPE, Object.class, Object.class));
            this.adapter.pop();
            this.adapter.getstatic(className.replace('.', '/'), atomicRefField, CodegenUtils.ci(AtomicReference.class));
            this.adapter.invokevirtual(CodegenUtils.p(AtomicReference.class), "get", CodegenUtils.sig(Object.class, new Class[0]));
            this.adapter.label(done);
            this.adapter.checkcast(CodegenUtils.p(RubyRegexp.class));
        }
    }

    @Override
    public void pushSymbol(final ByteList bytes2) {
        this.cacheValuePermanentlyLoadContext("symbol", RubySymbol.class, IRBytecodeAdapter6.keyFor("symbol", bytes2, bytes2.getEncoding()), new Runnable(){

            @Override
            public void run() {
                IRBytecodeAdapter6.this.loadRuntime();
                IRBytecodeAdapter6.this.pushByteList(bytes2);
                IRBytecodeAdapter6.this.adapter.invokestatic(CodegenUtils.p(RubySymbol.class), "newSymbol", CodegenUtils.sig(RubySymbol.class, Ruby.class, ByteList.class));
            }
        });
    }

    @Override
    public void pushSymbolProc(final String id2) {
        this.cacheValuePermanentlyLoadContext("symbolProc", RubyProc.class, null, new Runnable(){

            @Override
            public void run() {
                IRBytecodeAdapter6.this.loadContext();
                IRBytecodeAdapter6.this.adapter.ldc(id2);
                IRBytecodeAdapter6.this.invokeIRHelper("newSymbolProc", CodegenUtils.sig(RubyProc.class, ThreadContext.class, String.class));
            }
        });
    }

    @Override
    public void loadRuntime() {
        this.loadContext();
        this.adapter.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
    }

    @Override
    public void pushEncoding(final Encoding encoding2) {
        this.cacheValuePermanentlyLoadContext("encoding", RubySymbol.class, IRBytecodeAdapter6.keyFor("encoding", (Object)encoding2), new Runnable(){

            @Override
            public void run() {
                IRBytecodeAdapter6.this.loadContext();
                IRBytecodeAdapter6.this.adapter.ldc(encoding2.toString());
                IRBytecodeAdapter6.this.invokeIRHelper("retrieveEncoding", CodegenUtils.sig(RubyEncoding.class, ThreadContext.class, String.class));
            }
        });
    }

    @Override
    public void invokeOther(String file2, int line, String scopeFieldName, CallBase call2, int arity2) {
        this.invoke(file2, line, scopeFieldName, call2, arity2);
    }

    @Override
    public void invokeArrayDeref(String file2, int line, String scopeFieldName, CallBase call2) {
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyString.class));
        String methodName = this.getUniqueSiteName(call2.getId());
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        adapter2.aloadMany(0, 1, 2, 3);
        IRBytecodeAdapter6.cacheCallSite(adapter2, this.getClassData().clsName, methodName, scopeFieldName, call2);
        adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "callOptimizedAref", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, RubyString.class, CallSite.class));
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    @Override
    public void invokeAsString(String file2, int line, String scopeFieldName, CallBase call2) {
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT));
        String methodName = this.getUniqueSiteName(call2.getId());
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        adapter2.aloadMany(0, 1, 2);
        IRBytecodeAdapter6.cacheCallSite(adapter2, this.getClassData().clsName, methodName, scopeFieldName, call2);
        adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "asString", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, CallSite.class));
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    public void invoke(String file2, int lineNumber, String scopeFieldName, CallBase call2, int arity2) {
        String outgoingSig;
        String incomingSig;
        String id2 = call2.getId();
        if (arity2 > 250) {
            throw new NotCompilableException("call to `" + id2 + "' has more than " + 250 + " arguments");
        }
        IRBytecodeAdapter.BlockPassType blockPassType = IRBytecodeAdapter.BlockPassType.fromIR(call2);
        boolean blockGiven = blockPassType.given();
        if (blockGiven) {
            switch (arity2) {
                case -1: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class));
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2, Block.class));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2, Block.class));
                    break;
                }
                default: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2, Block.class));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class));
                    break;
                }
            }
        } else {
            switch (arity2) {
                case -1: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY));
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2));
                    break;
                }
                default: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY));
                }
            }
        }
        String methodName = this.getUniqueSiteName(id2);
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        adapter2.line(lineNumber);
        IRBytecodeAdapter6.cacheCallSite(adapter2, this.getClassData().clsName, methodName, scopeFieldName, call2);
        adapter2.aload(0);
        adapter2.aload(1);
        adapter2.aload(2);
        switch (arity2) {
            case -1: 
            case 1: {
                adapter2.aload(3);
                if (!blockGiven) break;
                adapter2.aload(4);
                break;
            }
            case 0: {
                if (!blockGiven) break;
                adapter2.aload(3);
                break;
            }
            case 2: {
                adapter2.aload(3);
                adapter2.aload(4);
                if (!blockGiven) break;
                adapter2.aload(5);
                break;
            }
            case 3: {
                adapter2.aload(3);
                adapter2.aload(4);
                adapter2.aload(5);
                if (!blockGiven) break;
                adapter2.aload(6);
                break;
            }
            default: {
                IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 3, arity2);
                if (!blockGiven) break;
                adapter2.aload(3 + arity2);
            }
        }
        adapter2.invokevirtual(CodegenUtils.p(CachingCallSite.class), blockPassType.literal() ? "callIter" : "call", outgoingSig);
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    public static void buildArrayFromLocals(SkinnyMethodAdapter adapter2, int base, int arity2) {
        int j;
        if (arity2 == 0) {
            adapter2.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            return;
        }
        adapter2.pushInt(arity2);
        adapter2.invokestatic(CodegenUtils.p(Helpers.class), "anewarrayIRubyObjects", CodegenUtils.sig(IRubyObject[].class, Integer.TYPE));
        for (int i2 = 0; i2 < arity2; i2 += j) {
            for (j = 0; i2 + j < arity2 && j < 10; ++j) {
                adapter2.aload(base + i2 + j);
            }
            adapter2.pushInt(i2);
            adapter2.invokestatic(CodegenUtils.p(Helpers.class), "aastoreIRubyObjects", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject.class, j, Integer.TYPE)));
        }
    }

    @Override
    public void invokeOtherOneFixnum(String file2, int line, CallBase call2, long fixnum) {
        String id2 = call2.getId();
        if (!MethodIndex.hasFastFixnumOps(id2)) {
            this.pushFixnum(fixnum);
            if (call2.getCallType() == CallType.NORMAL) {
                this.invokeOther(file2, line, null, call2, 1);
            } else {
                this.invokeSelf(file2, line, null, call2, 1);
            }
            return;
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT));
        String outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, Long.TYPE));
        String methodName = "invokeOtherOneFixnum" + this.getClassData().callSiteCount.getAndIncrement() + ":" + JavaNameMangler.mangleMethodName(id2);
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        adapter2.line(line);
        this.adapter.getClassVisitor().visitField(10, methodName, CodegenUtils.ci(CallSite.class), null, null).visitEnd();
        adapter2.getstatic(this.getClassData().clsName, methodName, CodegenUtils.ci(CallSite.class));
        adapter2.dup();
        Label doCall = new Label();
        adapter2.ifnonnull(doCall);
        adapter2.pop();
        adapter2.ldc(id2);
        adapter2.invokestatic(CodegenUtils.p(MethodIndex.class), "getFastFixnumOpsCallSite", CodegenUtils.sig(CallSite.class, String.class));
        adapter2.dup();
        adapter2.putstatic(this.getClassData().clsName, methodName, CodegenUtils.ci(CallSite.class));
        adapter2.label(doCall);
        adapter2.aload(0);
        adapter2.aload(1);
        adapter2.aload(2);
        adapter2.ldc(fixnum);
        adapter2.invokevirtual(CodegenUtils.p(CallSite.class), "call", outgoingSig);
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    @Override
    public void invokeOtherOneFloat(String file2, int line, CallBase call2, double flote) {
        String id2 = call2.getId();
        if (!MethodIndex.hasFastFloatOps(id2)) {
            this.pushFloat(flote);
            if (call2.getCallType() == CallType.NORMAL) {
                this.invokeOther(file2, line, null, call2, 1);
            } else {
                this.invokeSelf(file2, line, null, call2, 1);
            }
            return;
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT));
        String outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, Double.TYPE));
        String methodName = "invokeOtherOneFloat" + this.getClassData().callSiteCount.getAndIncrement() + ':' + JavaNameMangler.mangleMethodName(id2);
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        adapter2.line(line);
        this.adapter.getClassVisitor().visitField(10, methodName, CodegenUtils.ci(CallSite.class), null, null).visitEnd();
        adapter2.getstatic(this.getClassData().clsName, methodName, CodegenUtils.ci(CallSite.class));
        adapter2.dup();
        Label doCall = new Label();
        adapter2.ifnonnull(doCall);
        adapter2.pop();
        adapter2.ldc(id2);
        adapter2.invokestatic(CodegenUtils.p(MethodIndex.class), "getFastFloatOpsCallSite", CodegenUtils.sig(CallSite.class, String.class));
        adapter2.dup();
        adapter2.putstatic(this.getClassData().clsName, methodName, CodegenUtils.ci(CallSite.class));
        adapter2.label(doCall);
        adapter2.aload(0);
        adapter2.aload(1);
        adapter2.aload(2);
        adapter2.ldc(flote);
        adapter2.invokevirtual(CodegenUtils.p(CallSite.class), "call", outgoingSig);
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    @Override
    public void invokeSelf(String file2, int line, String scopeFieldName, CallBase call2, int arity2) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to `" + call2.getId() + "' has more than " + 250 + " arguments");
        }
        this.invoke(file2, line, scopeFieldName, call2, arity2);
    }

    @Override
    public void invokeInstanceSuper(String file2, int line, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to instance super has more than 250 arguments");
        }
        this.performSuper(file2, line, name2, arity2, hasClosure, splatmap, "instanceSuper", "instanceSuperSplatArgs", false);
    }

    @Override
    public void invokeClassSuper(String file2, int line, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to class super has more than 250 arguments");
        }
        this.performSuper(file2, line, name2, arity2, hasClosure, splatmap, "classSuper", "classSuperSplatArgs", false);
    }

    @Override
    public void invokeUnresolvedSuper(String file2, int line, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to unresolved super has more than 250 arguments");
        }
        this.performSuper(file2, line, name2, arity2, hasClosure, splatmap, "unresolvedSuper", "unresolvedSuperSplatArgs", true);
    }

    @Override
    public void invokeZSuper(String file2, int line, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to zsuper has more than 250 arguments");
        }
        this.performSuper(file2, line, name2, arity2, hasClosure, splatmap, "zSuper", "zSuperSplatArgs", true);
    }

    private void performSuper(String file2, int line, String name2, int arity2, boolean hasClosure, boolean[] splatmap, String superHelper, String splatHelper, boolean unresolved) {
        boolean needsSplatting = IRRuntimeHelpers.needsSplatting(splatmap);
        String incomingSig = hasClosure ? CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)) : CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2));
        String outgoingSig = unresolved ? (needsSplatting ? SUPER_SPLAT_UNRESOLVED : SUPER_NOSPLAT_UNRESOLVED) : (needsSplatting ? SUPER_SPLAT_RESOLVED : SUPER_NOSPLAT_RESOLVED);
        String methodName = "invokeSuper" + this.getClassData().callSiteCount.getAndIncrement() + ':' + JavaNameMangler.mangleMethodName(name2);
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        adapter2.line(line);
        adapter2.aload(0);
        adapter2.aload(2);
        if (!unresolved) {
            adapter2.ldc(name2);
        }
        if (!unresolved) {
            adapter2.aload(3);
        }
        IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 4, arity2);
        if (hasClosure) {
            adapter2.aload(4 + arity2);
        } else {
            adapter2.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        }
        if (needsSplatting) {
            String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
            adapter2.ldc(splatmapString);
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "decodeSplatmap", CodegenUtils.sig(boolean[].class, String.class));
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), splatHelper, outgoingSig);
        } else {
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), superHelper, outgoingSig);
        }
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    @Override
    public void searchConst(String name2, boolean noPrivateConsts) {
        this.adapter.invokedynamic("searchConst", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, StaticScope.class)), ConstantLookupSite.BOOTSTRAP, name2, noPrivateConsts ? 1 : 0, 1);
    }

    @Override
    public void searchModuleForConst(String name2, boolean noPrivateConsts, boolean callConstMissing) {
        this.adapter.invokedynamic("searchModuleForConst", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class)), ConstantLookupSite.BOOTSTRAP, name2, noPrivateConsts ? 1 : 0, callConstMissing ? 1 : 0);
    }

    @Override
    public void inheritanceSearchConst(String name2, boolean noPrivateConsts) {
        this.adapter.invokedynamic("inheritanceSearchConst", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class)), ConstantLookupSite.BOOTSTRAP, name2, noPrivateConsts ? 1 : 0, 1);
    }

    @Override
    public void lexicalSearchConst(String name2) {
        this.adapter.invokedynamic("lexicalSearchConst", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, StaticScope.class)), ConstantLookupSite.BOOTSTRAP, name2, 0, 1);
    }

    @Override
    public void pushNil() {
        this.loadContext();
        this.adapter.getfield(CodegenUtils.p(ThreadContext.class), "nil", CodegenUtils.ci(IRubyObject.class));
    }

    @Override
    public void pushBoolean(boolean b2) {
        this.loadRuntime();
        this.adapter.invokevirtual(CodegenUtils.p(Ruby.class), b2 ? "getTrue" : "getFalse", CodegenUtils.sig(RubyBoolean.class, new Class[0]));
    }

    @Override
    public void pushBignum(BigInteger bigint) {
        String bigintStr = bigint.toString();
        this.loadRuntime();
        this.adapter.ldc(bigintStr);
        this.adapter.invokestatic(CodegenUtils.p(RubyBignum.class), "newBignum", CodegenUtils.sig(RubyBignum.class, Ruby.class, String.class));
    }

    @Override
    public void putField(String name2) {
        this.adapter.dup2();
        this.adapter.pop();
        this.cacheVariableAccessor(name2, true);
        this.invokeIRHelper("setVariableWithAccessor", CodegenUtils.sig(Void.TYPE, IRubyObject.class, IRubyObject.class, VariableAccessor.class));
    }

    @Override
    public void getField(String name2) {
        this.adapter.dup();
        this.cacheVariableAccessor(name2, false);
        this.loadContext();
        this.adapter.ldc(name2);
        this.invokeIRHelper("getVariableWithAccessor", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, VariableAccessor.class, ThreadContext.class, String.class));
    }

    private void cacheVariableAccessor(String name2, boolean write2) {
        String incomingSig = CodegenUtils.sig(VariableAccessor.class, CodegenUtils.params(JVM.OBJECT));
        String methodName = (write2 ? "ivarSet" : "ivarGet") + this.getClassData().callSiteCount.getAndIncrement() + ':' + JavaNameMangler.mangleMethodName(name2);
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        this.adapter.getClassVisitor().visitField(10, methodName, CodegenUtils.ci(VariableAccessor.class), null, null).visitEnd();
        String className = this.getClassData().clsName;
        adapter2.getstatic(className, methodName, CodegenUtils.ci(VariableAccessor.class));
        adapter2.dup();
        Label get2 = new Label();
        adapter2.ifnull(get2);
        adapter2.dup();
        adapter2.aload(0);
        adapter2.invokevirtual(CodegenUtils.p(VariableAccessor.class), "verify", CodegenUtils.sig(Boolean.TYPE, Object.class));
        adapter2.iffalse(get2);
        adapter2.areturn();
        adapter2.label(get2);
        adapter2.pop();
        adapter2.aload(0);
        adapter2.ldc(name2);
        adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), write2 ? "getVariableAccessorForWrite" : "getVariableAccessorForRead", CodegenUtils.sig(VariableAccessor.class, IRubyObject.class, String.class));
        adapter2.dup();
        adapter2.putstatic(className, methodName, CodegenUtils.ci(VariableAccessor.class));
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(className, methodName, incomingSig);
    }

    @Override
    public void array(int length2) {
        if (length2 > 250) {
            throw new NotCompilableException("literal array has more than 250 elements");
        }
        if (length2 <= 2) {
            this.invokeIRHelper("newArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, length2)));
            return;
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2));
        String methodName = "array:" + length2;
        ClassData classData = this.getClassData();
        if (!classData.arrayMethodsDefined.contains(length2)) {
            SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
            adapter2.aload(0);
            adapter2.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
            IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 1, length2);
            adapter2.invokevirtual(CodegenUtils.p(Ruby.class), "newArrayNoCopy", CodegenUtils.sig(RubyArray.class, IRubyObject[].class));
            adapter2.areturn();
            adapter2.end();
            classData.arrayMethodsDefined.add(length2);
        }
        this.adapter.invokestatic(classData.clsName, methodName, incomingSig);
    }

    @Override
    public void hash(int length2) {
        if (length2 > 125) {
            throw new NotCompilableException("literal hash has more than 125 pairs");
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2 * 2));
        String methodName = "hash:" + length2;
        ClassData classData = this.getClassData();
        if (!classData.hashMethodsDefined.contains(length2)) {
            SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
            adapter2.aload(0);
            adapter2.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
            IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 1, length2 * 2);
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "constructHashFromArray", CodegenUtils.sig(RubyHash.class, Ruby.class, IRubyObject[].class));
            adapter2.areturn();
            adapter2.end();
            classData.hashMethodsDefined.add(length2);
        }
        this.adapter.invokestatic(classData.clsName, methodName, incomingSig);
    }

    @Override
    public void kwargsHash(int length2) {
        if (length2 > 125) {
            throw new NotCompilableException("kwargs hash has more than 125 pairs");
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, RubyHash.class, IRubyObject.class, length2 * 2));
        String methodName = "kwargsHash:" + length2;
        ClassData classData = this.getClassData();
        if (!classData.kwargsHashMethodsDefined.contains(length2)) {
            SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
            adapter2.aload(0);
            adapter2.aload(1);
            IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 2, length2 * 2);
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "dupKwargsHashAndPopulateFromArray", CodegenUtils.sig(RubyHash.class, ThreadContext.class, RubyHash.class, IRubyObject[].class));
            adapter2.areturn();
            adapter2.end();
            classData.kwargsHashMethodsDefined.add(length2);
        }
        this.adapter.invokestatic(classData.clsName, methodName, incomingSig);
    }

    @Override
    public void checkpoint() {
        this.loadContext();
        this.adapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "callThreadPoll", CodegenUtils.sig(Void.TYPE, new Class[0]));
    }

    @Override
    public void getGlobalVariable(String name2, String file2, int line) {
        this.loadContext();
        this.adapter.invokedynamic("get:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(IRubyObject.class, ThreadContext.class), Bootstrap.global(), file2, line);
    }

    @Override
    public void setGlobalVariable(String name2, String file2, int line) {
        this.loadContext();
        this.adapter.invokedynamic("set:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(Void.TYPE, IRubyObject.class, ThreadContext.class), Bootstrap.global(), file2, line);
    }

    @Override
    public void yield(boolean unwrap) {
        this.adapter.invokedynamic("yield", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, Block.class, JVM.OBJECT)), YieldSite.BOOTSTRAP, unwrap ? 1 : 0);
    }

    @Override
    public void yieldSpecific() {
        this.adapter.invokedynamic("yieldSpecific", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, Block.class)), YieldSite.BOOTSTRAP, 0);
    }

    @Override
    public void yieldValues(int arity2) {
        this.adapter.invokedynamic("yieldValues", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, Block.class, JVM.OBJECT, arity2)), YieldSite.BOOTSTRAP, 0);
    }

    @Override
    public void prepareBlock(Handle handle, org.jruby.runtime.Signature signature, String className) {
        String cacheField = "blockBody" + this.getClassData().callSiteCount.getAndIncrement();
        Label done = new Label();
        this.adapter.getClassVisitor().visitField(10, cacheField, CodegenUtils.ci(CompiledIRBlockBody.class), null, null).visitEnd();
        this.adapter.getstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(CompiledIRBlockBody.class));
        this.adapter.dup();
        this.adapter.ifnonnull(done);
        this.adapter.pop();
        this.adapter.newobj(CodegenUtils.p(CompiledIRBlockBody.class));
        this.adapter.dup();
        this.adapter.ldc(handle);
        this.adapter.getstatic(className, handle.getName() + "_IRScope", CodegenUtils.ci(IRScope.class));
        this.adapter.ldc(signature.encode());
        this.adapter.invokespecial(CodegenUtils.p(CompiledIRBlockBody.class), "<init>", CodegenUtils.sig(Void.TYPE, MethodHandle.class, IRScope.class, Long.TYPE));
        this.adapter.dup();
        this.adapter.putstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(CompiledIRBlockBody.class));
        this.adapter.label(done);
        this.invokeIRHelper("prepareBlock", CodegenUtils.sig(Block.class, ThreadContext.class, IRubyObject.class, DynamicScope.class, BlockBody.class));
    }

    @Override
    public void callEqq(EQQInstr call2) {
        IRBytecodeAdapter.cacheCallSite(this.adapter, this.getClassData().clsName, this.getUniqueSiteName(call2.getId()), null, call2);
        this.adapter.ldc(call2.isSplattedValue());
        this.invokeIRHelper("isEQQ", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, CallSite.class, Boolean.TYPE));
    }
}

