/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsCredentialedAgreement;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsSecret;

public class TlsECDHKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsCredentialedAgreement agreementCredentials;
    protected TlsCertificate ecdhPeerCertificate;

    private static int checkKeyExchange(int n) {
        switch (n) {
            case 16: 
            case 18: {
                return n;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsECDHKeyExchange(int n) {
        super(TlsECDHKeyExchange.checkKeyExchange(n));
    }

    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        this.agreementCredentials = TlsUtils.requireAgreementCredentials(tlsCredentials);
    }

    public void processServerCertificate(Certificate certificate) throws IOException {
        this.ecdhPeerCertificate = certificate.getCertificateAt(0).useInRole(0, this.keyExchange);
    }

    public short[] getClientCertificateTypes() {
        return new short[]{66, 65};
    }

    public void skipClientCredentials() throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        this.agreementCredentials = TlsUtils.requireAgreementCredentials(tlsCredentials);
    }

    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
    }

    public void processClientCertificate(Certificate certificate) throws IOException {
        this.ecdhPeerCertificate = certificate.getCertificateAt(0).useInRole(1, this.keyExchange);
    }

    public void processClientKeyExchange(InputStream inputStream) throws IOException {
    }

    public boolean requiresCertificateVerify() {
        return false;
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreementCredentials.generateAgreement(this.ecdhPeerCertificate);
    }
}

