/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.annotation;

import java.util.Optional;
import org.protege.editor.owl.model.annotation.AnnotationValueProvider;
import org.protege.editor.owl.model.user.Orcid;
import org.protege.editor.owl.model.user.OrcidProvider;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLDataFactory;

public class OrcidAnnotationValueProvider
implements AnnotationValueProvider {
    private final OrcidProvider orcidProvider;

    public OrcidAnnotationValueProvider(OrcidProvider orcidProvider) {
        this.orcidProvider = orcidProvider;
    }

    @Override
    public Optional<OWLAnnotationValue> getAnnotationValue(OWLDataFactory dataFactory) {
        Optional<Orcid> orcid = this.orcidProvider.getOrcid();
        if (!orcid.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(IRI.create((String)("http://orcid.org/" + orcid.get().getValue())));
    }
}

