/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.views.threads;

import com.sun.tools.visualvm.application.views.threads.VisualVMThreadsDataManager;
import com.sun.tools.visualvm.core.datasource.Storage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.lib.profiler.results.threads.ThreadData;

final class PersistenceSupport {
    private static final String THREADS_DATA_FILE = "threads.dat";
    private static final String THREADS_SNAPSHOT_HEADER = "ThreadsDataManagerSnapshot";
    private static final int THREADS_SNAPSHOT_VERSION = 1;
    private static final String PROP_PREFIX = "ApplicationThreadsModel_";
    static final String SNAPSHOT_VERSION = "ApplicationThreadsModel_version";
    private static final String SNAPSHOT_VERSION_DIVIDER = ".";
    private static final String CURRENT_SNAPSHOT_VERSION_MAJOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION_MINOR = "0";
    private static final String CURRENT_SNAPSHOT_VERSION = "1.0";

    PersistenceSupport() {
    }

    static boolean supportsStorage(Storage storage) {
        return storage.getCustomProperty(SNAPSHOT_VERSION) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveDataManager(VisualVMThreadsDataManager dm, Storage storage) {
        if (dm == null) {
            return;
        }
        File dir = storage.getDirectory();
        OutputStream os = null;
        try {
            os = new FileOutputStream(new File(dir, THREADS_DATA_FILE));
            PersistenceSupport.saveDataManager(dm, os);
            storage.setCustomProperty(SNAPSHOT_VERSION, CURRENT_SNAPSHOT_VERSION);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static VisualVMThreadsDataManager loadDataManager(Storage storage) {
        File dir = storage.getDirectory();
        InputStream is = null;
        try {
            is = new FileInputStream(new File(dir, THREADS_DATA_FILE));
            VisualVMThreadsDataManager visualVMThreadsDataManager = PersistenceSupport.loadDataManager(is);
            return visualVMThreadsDataManager;
        }
        catch (Exception e) {
            VisualVMThreadsDataManager visualVMThreadsDataManager = null;
            return visualVMThreadsDataManager;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void saveDataManager(VisualVMThreadsDataManager dm, OutputStream os) throws IOException {
        try (FilterOutputStream dos = null;){
            VisualVMThreadsDataManager visualVMThreadsDataManager = dm;
            synchronized (visualVMThreadsDataManager) {
                int tcount = dm.getThreadsCount();
                dos = new DataOutputStream(os);
                ((DataOutputStream)dos).writeUTF(THREADS_SNAPSHOT_HEADER);
                ((DataOutputStream)dos).writeInt(1);
                ((DataOutputStream)dos).writeLong(dm.getStartTime());
                ((DataOutputStream)dos).writeLong(dm.getEndTime());
                ((DataOutputStream)dos).writeInt(tcount);
                ((DataOutputStream)dos).writeInt(dm.getDaemonThreadCount());
                for (int tidx = 0; tidx < tcount; ++tidx) {
                    ThreadData tdata = dm.getThreadData(tidx);
                    int scount = tdata.size();
                    ((DataOutputStream)dos).writeUTF(tdata.getName());
                    ((DataOutputStream)dos).writeInt(scount);
                    for (int sidx = 0; sidx < scount; ++sidx) {
                        ((DataOutputStream)dos).writeLong(tdata.getTimeStampAt(sidx));
                        ((DataOutputStream)dos).writeByte(tdata.getStateAt(sidx));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VisualVMThreadsDataManager loadDataManager(InputStream is) throws IOException {
        SavedThreadsDataManager dm = null;
        try (DataInputStream dis = null;){
            dis = new DataInputStream(is);
            if (!THREADS_SNAPSHOT_HEADER.equals(dis.readUTF())) {
                throw new IOException("Unknown snapshot format");
            }
            if (1 != dis.readInt()) {
                throw new IOException("Unsupported snapshot version");
            }
            long stime = dis.readLong();
            long etime = dis.readLong();
            int tcount = dis.readInt();
            int dtcount = dis.readInt();
            ThreadData[] tdata = new ThreadData[tcount];
            for (int tidx = 0; tidx < tcount; ++tidx) {
                ThreadData td = new ThreadData(dis.readUTF(), "");
                int scount = dis.readInt();
                for (int sidx = 0; sidx < scount; ++sidx) {
                    td.add(dis.readLong(), dis.readByte());
                }
                tdata[tidx] = td;
            }
            dm = new SavedThreadsDataManager(stime, etime, dtcount, tdata);
        }
        return dm;
    }

    private static class SavedThreadsDataManager
    extends VisualVMThreadsDataManager {
        private final long startTime;
        private final long endTime;
        private final int daemonThreads;
        private final ThreadData[] threadData;

        public SavedThreadsDataManager(long startTime, long endTime, int daemonThreads, ThreadData[] threadData) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.daemonThreads = daemonThreads;
            this.threadData = threadData;
        }

        @Override
        public int getThreadCount() {
            return this.getThreadsCount();
        }

        @Override
        public int getDaemonThreadCount() {
            return this.daemonThreads;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public int getThreadsCount() {
            return this.threadData.length;
        }

        public String getThreadName(int index) {
            return this.threadData[index].getName();
        }

        public String getThreadClassName(int index) {
            return this.threadData[index].getClassName();
        }

        public ThreadData getThreadData(int index) {
            return this.threadData[index];
        }
    }
}

