/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.util.Introspector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMMessage {
    protected static final Logger logger = Logger.getLogger(DOMMessage.class.getName());
    private static final String FREECOL_PROTOCOL_VERSION = "0.1.6";
    private static final String INVALID_MESSAGE = "invalid";
    protected Document document;

    protected DOMMessage(String tag) {
        this.document = DOMMessage.createNewDocument();
        this.document.appendChild(this.document.createElement(tag));
    }

    public DOMMessage(InputStream inputStream) throws SAXException, IOException {
        this(new InputSource(inputStream));
    }

    private DOMMessage(InputSource inputSource) throws SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document tempDocument = null;
        boolean dumpMsgOnError = true;
        if (dumpMsgOnError) {
            inputSource.setByteStream(new BufferedInputStream(inputSource.getByteStream()));
            inputSource.getByteStream().mark(1000000);
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            tempDocument = builder.parse(inputSource);
        }
        catch (ParserConfigurationException pce) {
            logger.log(Level.WARNING, "Parser error", pce);
        }
        catch (IOException | SAXException ex) {
            throw ex;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (dumpMsgOnError) {
                int i;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                inputSource.getByteStream().reset();
                while (-1 != (i = inputSource.getByteStream().read())) {
                    baos.write(i);
                }
                logger.severe(baos.toString("UTF-8"));
            }
            throw e;
        }
        this.document = tempDocument;
    }

    public DOMMessage(Document document) {
        this.document = document;
    }

    public static DOMMessage createMessage(Game game, Element element) {
        DOMMessage message;
        if (element == null) {
            return null;
        }
        String tag = element.getTagName();
        tag = "net.sf.freecol.common.networking." + tag.substring(0, 1).toUpperCase() + tag.substring(1) + "Message";
        Class[] types = new Class[]{Game.class, Element.class};
        Object[] params = new Object[]{game, element};
        try {
            message = (DOMMessage)Introspector.instantiate(tag, types, params);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, "Instantiation fail", e);
            message = null;
        }
        return message;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getType() {
        return this.document != null && this.document.getDocumentElement() != null ? this.document.getDocumentElement().getTagName() : INVALID_MESSAGE;
    }

    public boolean isType(String type) {
        return this.getType().equals(type);
    }

    public String getAttribute(String key) {
        return this.document.getDocumentElement().getAttribute(key);
    }

    public void setAttribute(String key, String value) {
        this.document.getDocumentElement().setAttribute(key, value);
    }

    public void setAttribute(String key, int value) {
        this.setAttribute(key, Integer.toString(value));
    }

    public boolean hasAttribute(String attribute) {
        return this.document.getDocumentElement().hasAttribute(attribute);
    }

    public void insertAsRoot(Element newRoot) {
        Element oldRoot = this.document.getDocumentElement();
        if (oldRoot != null) {
            this.document.removeChild(oldRoot);
            newRoot.appendChild(oldRoot);
        }
        this.document.appendChild(newRoot);
    }

    public Element toXMLElement() {
        return null;
    }

    public static String getFreeColProtocolVersion() {
        return FREECOL_PROTOCOL_VERSION;
    }

    public static Document createNewDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            return factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pce) {
            logger.log(Level.WARNING, "Parser failure", pce);
            return null;
        }
    }

    public static Element createNewRootElement(String tagName) {
        return DOMMessage.createNewDocument().createElement(tagName);
    }

    public static Element createMessage(String tagName, String ... attributes) {
        Element root = DOMMessage.createNewRootElement(tagName);
        String[] all = attributes;
        for (int i = 0; i < all.length; i += 2) {
            root.setAttribute(all[i], all[i + 1]);
        }
        return root;
    }

    public static Element collapseElements(List<Element> elements) {
        switch (elements.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return elements.get(0);
            }
        }
        Element first = elements.remove(0);
        Document doc = first.getOwnerDocument();
        Element result = doc.createElement("multiple");
        result.appendChild(first);
        for (Element e : elements) {
            result.appendChild(doc.importNode(e, true));
        }
        return result;
    }

    public static Element createError(String messageID, String message) {
        Element errorElement = DOMMessage.createMessage("error", new String[0]);
        if (messageID != null && !messageID.isEmpty()) {
            errorElement.setAttribute("messageID", messageID);
        }
        if (message != null && !message.isEmpty()) {
            errorElement.setAttribute("message", message);
        }
        return errorElement;
    }

    public static void createError(FreeColXMLWriter xw, String messageID, String message) {
        try {
            xw.writeStartElement("error");
            if (messageID != null && !messageID.isEmpty()) {
                xw.writeAttribute("messageID", messageID);
            }
            if (message != null && !message.isEmpty()) {
                xw.writeAttribute("message", message);
            }
            xw.writeEndElement();
        }
        catch (XMLStreamException e) {
            logger.log(Level.WARNING, "Could not send error message.", e);
        }
    }

    public static Element clientError(String message) {
        logger.warning(message);
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.COMMS)) {
            Thread.dumpStack();
        }
        return DOMMessage.createMessage("error", "messageID", "server.reject", "message", message);
    }

    public static Element getChildElement(Element element, String tagName) {
        NodeList n = element.getChildNodes();
        for (int i = 0; i < n.getLength(); ++i) {
            if (!(n.item(i) instanceof Element) || !((Element)n.item(i)).getTagName().equals(tagName)) continue;
            return (Element)n.item(i);
        }
        return null;
    }

    public static String elementToString(Element element) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer xt = factory.newTransformer();
            StringWriter sw = new StringWriter();
            xt.transform(new DOMSource(element), new StreamResult(sw));
            String result = sw.toString();
            if (result.startsWith("<?xml")) {
                String xmlEnd = "?>";
                int index = result.indexOf("?>");
                if (index > 0) {
                    result = result.substring(index + "?>".length());
                }
            }
            return result;
        }
        catch (TransformerException e) {
            logger.log(Level.WARNING, "TransformerException", e);
            return null;
        }
    }

    public String toString() {
        return this.document.getDocumentElement().toString();
    }
}

