/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java;

import com.sun.tools.visualvm.heapviewer.java.Bundle;
import com.sun.tools.visualvm.heapviewer.java.InstanceNode;
import com.sun.tools.visualvm.heapviewer.java.InstanceNodeRenderer;
import com.sun.tools.visualvm.heapviewer.java.InstanceReferenceNode;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerRenderer;
import javax.swing.Icon;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.MultiRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NormalBoldGrayRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

public class InstanceReferenceNodeRenderer
extends MultiRenderer
implements HeapViewerRenderer {
    protected static final Icon ICON_PRIMITIVE = Icons.getIcon((String)"LanguageIcons.Primitive");
    protected static final Icon ICON_INSTANCE = Icons.getIcon((String)"LanguageIcons.Instance");
    protected static final Icon ICON_ARRAY = Icons.getIcon((String)"LanguageIcons.Array");
    protected final NormalBoldGrayRenderer nameRenderer;
    protected final LabelRenderer equalsRenderer;
    private final InstanceNodeRenderer instanceRenderer;
    private final ProfilerRenderer[] renderers;
    protected final Heap heap;

    public InstanceReferenceNodeRenderer(Heap heap) {
        this.heap = heap;
        this.nameRenderer = new NormalBoldGrayRenderer(){

            public void setValue(Object value, int row) {
                InstanceReferenceNode node = (InstanceReferenceNode)((Object)value);
                String name = node.getFieldName();
                if (name.startsWith("static ")) {
                    this.setNormalValue("static ");
                    this.setBoldValue(name.substring("static ".length()));
                } else {
                    this.setNormalValue("");
                    this.setBoldValue(name);
                }
                this.setIcon(Icons.getIcon((String)(InstanceNode.Mode.INCOMING_REFERENCE.equals((Object)node.getMode()) ? "ProfilerIcons.NodeReverse" : "ProfilerIcons.NodeForward")));
            }
        };
        this.equalsRenderer = new LabelRenderer(){

            public void setValue(Object value, int row) {
                InstanceReferenceNode node = (InstanceReferenceNode)((Object)value);
                if (InstanceNode.Mode.INCOMING_REFERENCE.equals((Object)node.getMode())) {
                    this.setText(Bundle.InstanceReferenceNodeRenderer_NodeNameRefence());
                    InstanceReferenceNodeRenderer.this.equalsRenderer.setMargin(3, 2, 3, 0);
                } else {
                    this.setText("=");
                    InstanceReferenceNodeRenderer.this.equalsRenderer.setMargin(3, 0, 3, 0);
                }
            }
        };
        this.instanceRenderer = new InstanceNodeRenderer(heap);
        this.renderers = new ProfilerRenderer[]{this.nameRenderer, this.equalsRenderer, this.instanceRenderer};
    }

    @Override
    public Icon getIcon() {
        return this.nameRenderer.getIcon();
    }

    @Override
    public String getShortName() {
        return this.nameRenderer.toString();
    }

    protected ProfilerRenderer[] valueRenderers() {
        return this.renderers;
    }

    public void setValue(Object value, int row) {
        HeapViewerNode node = (HeapViewerNode)((Object)value);
        HeapViewerNode loop = HeapViewerNode.getValue(node, DataType.LOOP, this.heap);
        if (loop != null) {
            node = loop;
        }
        this.nameRenderer.setValue((Object)node, row);
        this.equalsRenderer.setValue((Object)node, row);
        this.instanceRenderer.setValue(value, row);
    }
}

