/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ser.SerializerCache;
import java.util.Map;

public class JsonSerializerMap {
    private final Bucket[] _buckets;
    private final int _size;

    public JsonSerializerMap(Map<SerializerCache.TypeKey, JsonSerializer<Object>> serializers) {
        int size;
        this._size = size = JsonSerializerMap.findSize(serializers.size());
        int hashMask = size - 1;
        Bucket[] buckets = new Bucket[size];
        for (Map.Entry<SerializerCache.TypeKey, JsonSerializer<Object>> entry : serializers.entrySet()) {
            SerializerCache.TypeKey key2 = entry.getKey();
            int index2 = key2.hashCode() & hashMask;
            buckets[index2] = new Bucket(buckets[index2], key2, entry.getValue());
        }
        this._buckets = buckets;
    }

    private static final int findSize(int size) {
        int result;
        int needed = size <= 64 ? size + size : size + (size >> 2);
        for (result = 8; result < needed; result += result) {
        }
        return result;
    }

    public int size() {
        return this._size;
    }

    public JsonSerializer<Object> find(SerializerCache.TypeKey key2) {
        int index2 = key2.hashCode() & this._buckets.length - 1;
        Bucket bucket = this._buckets[index2];
        if (bucket == null) {
            return null;
        }
        if (key2.equals(bucket.key)) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (!key2.equals(bucket.key)) continue;
            return bucket.value;
        }
        return null;
    }

    private static final class Bucket {
        public final SerializerCache.TypeKey key;
        public final JsonSerializer<Object> value;
        public final Bucket next;

        public Bucket(Bucket next2, SerializerCache.TypeKey key2, JsonSerializer<Object> value) {
            this.next = next2;
            this.key = key2;
            this.value = value;
        }
    }
}

