/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import org.eclipse.jgit.util.RawParseUtils;

class ByteArraySet {
    private int size;
    private int grow;
    private int mask;
    private byte[][] table;
    private Hasher hasher = new Hasher(null, 0);

    ByteArraySet(int capacity) {
        this.initTable(1 << Integer.highestOneBit(capacity * 2 - 1));
    }

    private byte[] get(byte[] toFind, int length, int hash2) {
        byte[] obj;
        int msk = this.mask;
        int i = hash2 & msk;
        byte[][] tbl = this.table;
        while ((obj = tbl[i]) != null) {
            if (ByteArraySet.equals(obj, toFind, length)) {
                return obj;
            }
            i = i + 1 & msk;
        }
        return null;
    }

    private static boolean equals(byte[] storedObj, byte[] toFind, int length) {
        if (storedObj.length != length || toFind.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (storedObj[i] == toFind[i]) continue;
            return false;
        }
        return true;
    }

    boolean contains(byte[] toFind, int length, int hash2) {
        return this.get(toFind, length, hash2) != null;
    }

    byte[] addIfAbsent(byte[] newValue, int length, int hash2) {
        byte[] obj;
        int msk = this.mask;
        int i = hash2 & msk;
        byte[][] tbl = this.table;
        while ((obj = tbl[i]) != null) {
            if (ByteArraySet.equals(obj, newValue, length)) {
                return obj;
            }
            i = i + 1 & msk;
        }
        byte[] valueToInsert = ByteArraySet.copyIfNotSameSize(newValue, length);
        if (++this.size == this.grow) {
            this.grow();
            this.insert(valueToInsert, hash2);
        } else {
            tbl[i] = valueToInsert;
        }
        return valueToInsert;
    }

    private static byte[] copyIfNotSameSize(byte[] newValue, int length) {
        if (newValue.length == length) {
            return newValue;
        }
        byte[] ret = new byte[length];
        System.arraycopy(newValue, 0, ret, 0, length);
        return ret;
    }

    int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    private void insert(byte[] newValue, int hash2) {
        int msk = this.mask;
        int j = hash2 & msk;
        byte[][] tbl = this.table;
        while (tbl[j] != null) {
            j = j + 1 & msk;
        }
        tbl[j] = newValue;
    }

    private void grow() {
        byte[][] oldTable = this.table;
        int oldSize = this.table.length;
        this.initTable(oldSize << 1);
        for (int i = 0; i < oldSize; ++i) {
            byte[] obj = oldTable[i];
            if (obj == null) continue;
            this.hasher.init(obj, obj.length);
            this.insert(obj, this.hasher.hash());
        }
    }

    private void initTable(int sz) {
        if (sz < 2) {
            sz = 2;
        }
        this.grow = sz >> 1;
        this.mask = sz - 1;
        this.table = new byte[sz][];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (byte[] b : this.table) {
            if (b == null) continue;
            if (sb.length() > 1) {
                sb.append(" , ");
            }
            sb.append('\"');
            sb.append(RawParseUtils.decode(b));
            sb.append('\"');
            sb.append('(');
            sb.append(this.chainlength(b));
            sb.append(')');
        }
        sb.append(']');
        return sb.toString();
    }

    private int chainlength(byte[] b) {
        byte[] obj;
        Hasher h = new Hasher(b, b.length);
        int hash2 = h.hash();
        int msk = this.mask;
        int i = hash2 & msk;
        byte[][] tbl = this.table;
        int n = 0;
        while ((obj = tbl[i]) != null) {
            if (ByteArraySet.equals(obj, b, b.length)) {
                return n;
            }
            i = i + 1 & msk;
            ++n;
        }
        return -1;
    }

    byte[][] toArray() {
        byte[][] ret = new byte[this.size][];
        int i = 0;
        for (byte[] entry : this.table) {
            if (entry == null) continue;
            ret[i++] = entry;
        }
        return ret;
    }

    static class Hasher {
        private int hash;
        private int pos;
        private byte[] data;
        private int length;

        Hasher(byte[] data2, int length) {
            this.init(data2, length);
        }

        void init(byte[] d, int l) {
            this.data = d;
            this.length = l;
            this.pos = 0;
            this.hash = 0;
        }

        int hash() {
            while (this.pos < this.length) {
                this.hash = this.hash * 31 + this.data[this.pos++];
            }
            return this.hash;
        }

        int nextHash() {
            do {
                this.hash = this.hash * 31 + this.data[this.pos];
                ++this.pos;
            } while (this.pos != this.length && this.data[this.pos] != 47);
            return this.hash;
        }

        int getHash() {
            return this.hash;
        }

        boolean hasNext() {
            return this.pos < this.length;
        }

        public int length() {
            return this.pos;
        }

        public String toString() {
            int i;
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < this.pos; ++i) {
                sb.append((char)this.data[i]);
            }
            sb.append(" | ");
            for (i = this.pos; i < this.length; ++i) {
                sb.append((char)this.data[i]);
            }
            return sb.toString();
        }
    }
}

