/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.server.model.ServerUnit;

public final class EditSettlementDialog
extends FreeColDialog<IndianSettlement>
implements ItemListener {
    private static final Logger logger = Logger.getLogger(EditSettlementDialog.class.getName());
    private final IndianSettlement settlement;
    private final JTextField name;
    private final JComboBox<Nation> owner;
    private final JCheckBox capital;
    private final JComboBox<UnitType> skill;
    private final JSpinner units;

    public EditSettlementDialog(FreeColClient freeColClient, JFrame frame, IndianSettlement settlement) {
        super(freeColClient, frame);
        this.settlement = settlement;
        this.name = new JTextField(settlement.getName(), 30);
        DefaultComboBoxModel<Nation> nationModel = new DefaultComboBoxModel<Nation>();
        for (Nation n : this.getSpecification().getIndianNations()) {
            nationModel.addElement(n);
        }
        this.owner = new JComboBox(nationModel);
        this.owner.setSelectedItem(settlement.getOwner().getNation());
        this.owner.addItemListener(this);
        this.owner.setRenderer(new FreeColComboBoxRenderer());
        this.capital = new JCheckBox();
        this.capital.setSelected(settlement.isCapital());
        this.skill = new JComboBox<UnitType>(this.getSkillModel());
        this.skill.setSelectedItem(settlement.getLearnableSkill());
        this.skill.setRenderer(new FreeColComboBoxRenderer());
        int unitCount = settlement.getUnitCount();
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(unitCount, 1, 20, 1);
        this.units = new JSpinner(spinnerModel);
        spinnerModel.setValue(unitCount);
        MigPanel panel = new MigPanel(new MigLayout("wrap 2, gapx 20"));
        panel.add(Utility.localizedLabel("name"));
        panel.add(this.name);
        panel.add(Utility.localizedLabel("nation"));
        panel.add(this.owner);
        panel.add(Utility.localizedLabel("capital"));
        panel.add(this.capital);
        panel.add(Utility.localizedLabel("skillTaught"));
        panel.add(this.skill);
        panel.add(Utility.localizedLabel("units"));
        panel.add(this.units);
        Object fake = null;
        List c = EditSettlementDialog.choices();
        c.add(new ChoiceItem<IndianSettlement>(Messages.message("ok"), settlement).okOption());
        c.add(new ChoiceItem<Object>(Messages.message("editSettlementDialog.removeSettlement"), fake));
        c.add(new ChoiceItem<Object>(Messages.message("cancel"), fake).cancelOption().defaultOption());
        this.initializeDialog(frame, FreeColDialog.DialogType.QUESTION, true, panel, new ImageIcon(this.getImageLibrary().getSmallSettlementImage(settlement)), c);
    }

    private Nation getOwnerNation() {
        return (Nation)this.owner.getSelectedItem();
    }

    private IndianNationType getOwnerNationType() {
        Nation n = this.getOwnerNation();
        return n == null ? null : (IndianNationType)n.getType();
    }

    private Player getOwnerPlayer() {
        Nation n = this.getOwnerNation();
        return CollectionUtils.find(this.settlement.getGame().getLivePlayers(null), p -> p.getNationId().equals(n.getId()));
    }

    private SettlementType getSettlementType() {
        return this.getOwnerNationType().getSettlementType(this.capital.isSelected());
    }

    private int getAverageSize() {
        SettlementType t = this.getSettlementType();
        return (t.getMinimumSize() + t.getMaximumSize()) / 2;
    }

    private DefaultComboBoxModel<UnitType> getSkillModel() {
        IndianNationType ownerType = this.getOwnerNationType();
        DefaultComboBoxModel<UnitType> skillModel = new DefaultComboBoxModel<UnitType>();
        for (RandomChoice<UnitType> skill : ownerType.getSkills()) {
            skillModel.addElement(skill.getObject());
        }
        return skillModel;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Player player = this.getOwnerPlayer();
        if (player != null) {
            this.name.setText(this.capital.isSelected() ? player.getCapitalName(null) : player.getSettlementName(null));
        }
        this.skill.setModel(this.getSkillModel());
        this.skill.setSelectedItem(this.settlement.getLearnableSkill());
        this.units.getModel().setValue(this.settlement.getUnitList().size());
    }

    @Override
    public IndianSettlement getResponse() {
        Specification spec = this.freeColClient.getGame().getSpecification();
        SwingGUI gui = this.getGUI();
        IndianSettlement ret = null;
        Set<Tile> tiles = this.settlement.getOwnedTiles();
        Object value = this.getValue();
        if (((ChoiceItem)this.options.get(0)).equals(value)) {
            this.settlement.setName(this.name.getText());
            Nation newNation = this.getOwnerNation();
            if (newNation != this.settlement.getOwner().getNation()) {
                Player newPlayer = this.getOwnerPlayer();
                this.settlement.setOwner(newPlayer);
                List<Unit> ul = this.settlement.getUnitList();
                ul.addAll(this.settlement.getTile().getUnitList());
                for (Unit u : ul) {
                    u.setOwner(newPlayer);
                    u.setEthnicity(newNation.getId());
                    u.setNationality(newNation.getId());
                }
                for (Tile t : this.settlement.getOwnedTiles()) {
                    t.setOwner(newPlayer);
                }
                MapEditorTransformPanel.setNativeNation(newNation);
            }
            if (this.capital.isSelected() && !this.settlement.isCapital()) {
                for (IndianSettlement indianSettlement : this.settlement.getOwner().getIndianSettlements()) {
                    indianSettlement.setCapital(false);
                }
                this.settlement.setCapital(true);
            } else if (!this.capital.isSelected() && this.settlement.isCapital()) {
                this.settlement.setCapital(false);
            }
            this.settlement.setLearnableSkill((UnitType)this.skill.getSelectedItem());
            int numberOfUnits = (Integer)this.units.getValue() - this.settlement.getUnitCount();
            if (numberOfUnits > 0) {
                Player owner = this.settlement.getOwner();
                UnitType brave = spec.getDefaultUnitType(owner);
                for (int index = 0; index < numberOfUnits; ++index) {
                    this.settlement.add(new ServerUnit(this.settlement.getGame(), this.settlement, owner, brave));
                }
            } else if (numberOfUnits < 0) {
                List<Unit> unitList = this.settlement.getUnitList().subList(0, -numberOfUnits);
                for (Unit unit : unitList) {
                    unit.dispose();
                }
            }
            SettlementType oldType = this.settlement.getType();
            SettlementType type = this.getSettlementType();
            this.settlement.setType(type);
            this.settlement.getFeatureContainer().replaceSource(oldType, type);
            ret = this.settlement;
        } else if (((ChoiceItem)this.options.get(1)).equals(value)) {
            if (!gui.confirm("editSettlementDialog.removeSettlement.text", "ok", "cancel")) {
                return this.settlement;
            }
            Tile tile = this.settlement.getTile();
            for (Unit unit : tile.getUnitList()) {
                unit.dispose();
            }
            this.settlement.exciseSettlement();
        }
        for (Tile t : tiles) {
            gui.refreshTile(t);
        }
        return ret;
    }
}

