/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.SystemProperties;
import com.intellij.util.containers.LimitedPool;
import com.intellij.util.io.FinalizationRequest;
import com.intellij.util.io.PoolPageKey;
import com.intellij.util.io.RandomAccessDataFile;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Page {
    public static final int PAGE_SIZE = SystemProperties.getIntProperty("idea.io.page.size", 8192);
    private static final LimitedPool<ByteBuffer> ourBufferPool = new LimitedPool<ByteBuffer>(10, new LimitedPool.ObjectFactory<ByteBuffer>(){

        @Override
        @NotNull
        public ByteBuffer create() {
            ByteBuffer byteBuffer = ByteBuffer.allocate(PAGE_SIZE);
            if (byteBuffer == null) {
                1.$$$reportNull$$$0(0);
            }
            return byteBuffer;
        }

        @Override
        public void cleanup(@NotNull ByteBuffer byteBuffer) {
            if (byteBuffer == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/Page$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "byteBuffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/Page$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "cleanup";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    });
    private final long offset;
    private final RandomAccessDataFile owner;
    private final PoolPageKey myKey;
    private ByteBuffer buf;
    private boolean read;
    private boolean dirty;
    private int myFinalizationId;
    private BitSet myWriteMask;
    private final PageLock lock;
    private final Range myContinuousRange;

    private void ensureRead() {
        if (!this.read) {
            if (this.myWriteMask != null) {
                byte[] content = new byte[PAGE_SIZE];
                ByteBuffer b = this.getBuf();
                b.position(0);
                b.get(content, 0, PAGE_SIZE);
                this.owner.loadPage(this);
                int i = this.myWriteMask.nextSetBit(0);
                while (i >= 0) {
                    b.put(i, content[i]);
                    i = this.myWriteMask.nextSetBit(i + 1);
                }
                this.myWriteMask = null;
            } else {
                this.owner.loadPage(this);
            }
            this.read = true;
        }
    }

    @Nullable
    private Range calcContinuousRange(BitSet mask) {
        int lowestByte = mask.nextSetBit(0);
        if (lowestByte >= 0) {
            int highestByte = mask.nextClearBit(lowestByte);
            if (highestByte > 0) {
                int nextChunk = mask.nextSetBit(highestByte);
                if (nextChunk < 0) {
                    this.myContinuousRange.start = lowestByte;
                    this.myContinuousRange.end = highestByte;
                    return this.myContinuousRange;
                }
                return null;
            }
            this.myContinuousRange.start = lowestByte;
            this.myContinuousRange.end = PAGE_SIZE;
            return this.myContinuousRange;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if (this.dirty) {
                int start = 0;
                int end = PAGE_SIZE;
                if (this.myWriteMask != null) {
                    Range range = this.calcContinuousRange(this.myWriteMask);
                    if (range == null) {
                        this.ensureRead();
                    } else {
                        start = range.start;
                        end = range.end;
                    }
                    this.myWriteMask = null;
                }
                if (end - start > 0) {
                    this.owner.flushPage(this, start, end);
                }
                this.dirty = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getBuf() {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if (this.buf == null) {
                LimitedPool<ByteBuffer> limitedPool = ourBufferPool;
                synchronized (limitedPool) {
                    this.buf = ourBufferPool.alloc();
                }
            }
            return this.buf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycle() {
        if (this.buf != null) {
            LimitedPool<ByteBuffer> limitedPool = ourBufferPool;
            synchronized (limitedPool) {
                ourBufferPool.recycle(this.buf);
            }
        }
        this.buf = null;
        this.read = false;
        this.dirty = false;
        this.myWriteMask = null;
    }

    public long getOffset() {
        return this.offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FinalizationRequest prepareForFinalization(int finalizationId) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if (this.dirty) {
                this.myFinalizationId = finalizationId;
                return new FinalizationRequest(this, finalizationId);
            }
            this.recycle();
            return null;
        }
    }

    public RandomAccessDataFile getOwner() {
        return this.owner;
    }

    public PoolPageKey getKey() {
        return this.myKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushIfFinalizationIdIsEqualTo(long finalizationId) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if ((long)this.myFinalizationId == finalizationId) {
                this.flush();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recycleIfFinalizationIdIsEqualTo(long finalizationId) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if ((long)this.myFinalizationId == finalizationId) {
                this.recycle();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            return "Page[" + this.owner + ", dirty: " + this.dirty + ", offset=" + this.offset + "]";
        }
    }

    private static class Range {
        int start;
        int end;
    }

    private static class PageLock {
    }
}

