/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.PositiveValuesSlider;

public class OptionsScannerPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panelScanner = null;
    private JSlider sliderHostPerScan = null;
    private JSlider sliderThreadsPerHost = null;
    private ZapNumberSpinner spinnerDelayInMs = null;
    private JLabel labelThreadsPerHostValue = null;
    private ZapNumberSpinner spinnerMaxRuleDuration = null;
    private ZapNumberSpinner spinnerMaxScanDuration = null;
    private ZapNumberSpinner spinnerMaxResultsList = null;
    private JCheckBox chkInjectPluginIdInHeader = null;
    private JCheckBox chkHandleAntiCrsfTokens = null;
    private JCheckBox chkPromptInAttackMode = null;
    private JCheckBox chkRescanInAttackMode = null;
    private JComboBox<String> defaultAscanPolicy = null;
    private JComboBox<String> defaultAttackPolicy = null;
    private JCheckBox allowAttackModeOnStart = null;
    private ZapNumberSpinner spinnerMaxChartTime = null;
    private ExtensionActiveScan extension;

    public OptionsScannerPanel(ExtensionActiveScan extension) {
        this.extension = extension;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("ascan.options.title"));
        this.add(new JScrollPane(this.getPanelScanner()));
    }

    private JPanel getPanelScanner() {
        if (this.panelScanner == null) {
            this.panelScanner = new JPanel();
            this.panelScanner.setLayout(new GridBagLayout());
            this.panelScanner.setName("");
            int row = 0;
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.numHosts.label")), LayoutHelper.getGBC(0, row++, 3, 1.0, 0.0, 2));
            this.panelScanner.add((Component)this.getSliderHostPerScan(), LayoutHelper.getGBC(0, row++, 3, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.numThreads.label")), LayoutHelper.getGBC(0, row, 2, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getLabelThreadsPerHostValue(), LayoutHelper.getGBC(2, row++, 1, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getSliderThreadsPerHost(), LayoutHelper.getGBC(0, row++, 3, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.maxRes.label")), LayoutHelper.getGBC(0, row, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getSpinnerMaxResultsList(), LayoutHelper.getGBC(1, row++, 2, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.maxRule.label")), LayoutHelper.getGBC(0, row, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getSpinnerMaxRuleDuration(), LayoutHelper.getGBC(1, row++, 2, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.maxScan.label")), LayoutHelper.getGBC(0, row, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getSpinnerMaxScanDuration(), LayoutHelper.getGBC(1, row++, 2, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.delayInMs.label")), LayoutHelper.getGBC(0, row, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getSpinnerDelayInMs(), LayoutHelper.getGBC(1, row++, 2, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getChkInjectPluginIdInHeader(), LayoutHelper.getGBC(0, row++, 3, 1.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.panelScanner.add((Component)this.getChkHandleAntiCSRFTokens(), LayoutHelper.getGBC(0, row++, 3, 1.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.panelScanner.add((Component)this.getChkPromptInAttackMode(), LayoutHelper.getGBC(0, row++, 3, 1.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.panelScanner.add((Component)this.getChkRescanInAttackMode(), LayoutHelper.getGBC(0, row++, 3, 1.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.policy.ascan.label")), LayoutHelper.getGBC(0, row, 1, 0.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.panelScanner.add(this.getDefaultAscanPolicyPulldown(), LayoutHelper.getGBC(1, row++, 2, 0.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.policy.attack.label")), LayoutHelper.getGBC(0, row, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add(this.getDefaultAttackPolicyPulldown(), LayoutHelper.getGBC(1, row++, 2, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getAllowAttackModeOnStart(), LayoutHelper.getGBC(0, row++, 3, 1.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.maxChart.label")), LayoutHelper.getGBC(0, row, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getSpinnerMaxChartTime(), LayoutHelper.getGBC(1, row++, 2, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(), LayoutHelper.getGBC(0, row, 3, 1.0, 1.0, 1));
        }
        return this.panelScanner;
    }

    private JComboBox<String> getDefaultAscanPolicyPulldown() {
        if (this.defaultAscanPolicy == null) {
            this.defaultAscanPolicy = new JComboBox();
        }
        return this.defaultAscanPolicy;
    }

    private JComboBox<String> getDefaultAttackPolicyPulldown() {
        if (this.defaultAttackPolicy == null) {
            this.defaultAttackPolicy = new JComboBox();
        }
        return this.defaultAttackPolicy;
    }

    private void initPolicyPulldowns() {
        this.getDefaultAscanPolicyPulldown().removeAllItems();
        this.getDefaultAttackPolicyPulldown().removeAllItems();
        for (String policy : this.extension.getPolicyManager().getAllPolicyNames()) {
            this.getDefaultAscanPolicyPulldown().addItem(policy);
            this.getDefaultAttackPolicyPulldown().addItem(policy);
        }
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam options = (OptionsParam)obj;
        ScannerParam param = options.getParamSet(ScannerParam.class);
        this.getSliderHostPerScan().setValue(param.getHostPerScan());
        this.getSliderThreadsPerHost().setValue(param.getThreadPerHost());
        this.getSpinnerDelayInMs().setValue(param.getDelayInMs());
        this.getSpinnerMaxResultsList().setValue(param.getMaxResultsToList());
        this.getSpinnerMaxRuleDuration().setValue(param.getMaxRuleDurationInMins());
        this.getSpinnerMaxScanDuration().setValue(param.getMaxScanDurationInMins());
        this.getChkInjectPluginIdInHeader().setSelected(param.isInjectPluginIdInHeader());
        this.getChkHandleAntiCSRFTokens().setSelected(param.getHandleAntiCSRFTokens());
        this.getChkPromptInAttackMode().setSelected(param.isPromptInAttackMode());
        this.getChkRescanInAttackMode().setSelected(param.isRescanInAttackMode());
        this.getChkRescanInAttackMode().setEnabled(!this.getChkPromptInAttackMode().isSelected());
        this.initPolicyPulldowns();
        this.getDefaultAscanPolicyPulldown().setSelectedItem(param.getDefaultPolicy());
        this.getDefaultAttackPolicyPulldown().setSelectedItem(param.getAttackPolicy());
        this.getAllowAttackModeOnStart().setSelected(param.isAllowAttackOnStart());
        this.getSpinnerMaxChartTime().setValue(param.getMaxChartTimeInMins());
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam options = (OptionsParam)obj;
        ScannerParam param = options.getParamSet(ScannerParam.class);
        param.setHostPerScan(this.getSliderHostPerScan().getValue());
        param.setThreadPerHost(this.getSliderThreadsPerHost().getValue());
        param.setDelayInMs(this.getDelayInMs());
        param.setMaxResultsToList(this.getSpinnerMaxResultsList().getValue());
        param.setMaxRuleDurationInMins(this.getSpinnerMaxRuleDuration().getValue());
        param.setMaxScanDurationInMins(this.getSpinnerMaxScanDuration().getValue());
        param.setInjectPluginIdInHeader(this.getChkInjectPluginIdInHeader().isSelected());
        param.setHandleAntiCSRFTokens(this.getChkHandleAntiCSRFTokens().isSelected());
        param.setPromptInAttackMode(this.getChkPromptInAttackMode().isSelected());
        param.setRescanInAttackMode(this.getChkRescanInAttackMode().isSelected());
        param.setDefaultPolicy((String)this.getDefaultAscanPolicyPulldown().getSelectedItem());
        param.setAttackPolicy((String)this.getDefaultAttackPolicyPulldown().getSelectedItem());
        param.setAllowAttackOnStart(this.getAllowAttackModeOnStart().isSelected());
        param.setMaxChartTimeInMins(this.getSpinnerMaxChartTime().getValue());
    }

    private JSlider getSliderHostPerScan() {
        if (this.sliderHostPerScan == null) {
            this.sliderHostPerScan = new JSlider();
            this.sliderHostPerScan.setMaximum(5);
            this.sliderHostPerScan.setMinimum(1);
            this.sliderHostPerScan.setMinorTickSpacing(1);
            this.sliderHostPerScan.setPaintTicks(true);
            this.sliderHostPerScan.setPaintLabels(true);
            this.sliderHostPerScan.setName("");
            this.sliderHostPerScan.setMajorTickSpacing(1);
            this.sliderHostPerScan.setSnapToTicks(true);
            this.sliderHostPerScan.setPaintTrack(true);
        }
        return this.sliderHostPerScan;
    }

    private JSlider getSliderThreadsPerHost() {
        if (this.sliderThreadsPerHost == null) {
            this.sliderThreadsPerHost = new PositiveValuesSlider(50);
            this.sliderThreadsPerHost.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    OptionsScannerPanel.this.setLabelThreadsPerHostValue(OptionsScannerPanel.this.getSliderThreadsPerHost().getValue());
                }
            });
        }
        return this.sliderThreadsPerHost;
    }

    private ZapNumberSpinner getSpinnerDelayInMs() {
        if (this.spinnerDelayInMs == null) {
            this.spinnerDelayInMs = new ZapNumberSpinner(0, 0, Integer.MAX_VALUE);
        }
        return this.spinnerDelayInMs;
    }

    private int getDelayInMs() {
        return this.spinnerDelayInMs.getValue();
    }

    private void setLabelThreadsPerHostValue(int value) {
        if (this.labelThreadsPerHostValue == null) {
            this.labelThreadsPerHostValue = new JLabel();
        }
        this.labelThreadsPerHostValue.setText(String.valueOf(value));
    }

    private JLabel getLabelThreadsPerHostValue() {
        if (this.labelThreadsPerHostValue == null) {
            this.setLabelThreadsPerHostValue(this.getSliderThreadsPerHost().getValue());
        }
        return this.labelThreadsPerHostValue;
    }

    private ZapNumberSpinner getSpinnerMaxResultsList() {
        if (this.spinnerMaxResultsList == null) {
            this.spinnerMaxResultsList = new ZapNumberSpinner();
            this.spinnerMaxResultsList.setToolTipText(Constant.messages.getString("ascan.options.maxRes.tooltip"));
        }
        return this.spinnerMaxResultsList;
    }

    private ZapNumberSpinner getSpinnerMaxRuleDuration() {
        if (this.spinnerMaxRuleDuration == null) {
            this.spinnerMaxRuleDuration = new ZapNumberSpinner();
        }
        return this.spinnerMaxRuleDuration;
    }

    private ZapNumberSpinner getSpinnerMaxScanDuration() {
        if (this.spinnerMaxScanDuration == null) {
            this.spinnerMaxScanDuration = new ZapNumberSpinner();
        }
        return this.spinnerMaxScanDuration;
    }

    private ZapNumberSpinner getSpinnerMaxChartTime() {
        if (this.spinnerMaxChartTime == null) {
            this.spinnerMaxChartTime = new ZapNumberSpinner();
            this.spinnerMaxChartTime.setToolTipText(Constant.messages.getString("ascan.options.maxChart.tooltip"));
        }
        return this.spinnerMaxChartTime;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.ascan";
    }

    private JCheckBox getChkInjectPluginIdInHeader() {
        if (this.chkInjectPluginIdInHeader == null) {
            this.chkInjectPluginIdInHeader = new JCheckBox();
            this.chkInjectPluginIdInHeader.setText(Constant.messages.getString("ascan.options.pluginHeader.label"));
        }
        return this.chkInjectPluginIdInHeader;
    }

    private JCheckBox getChkHandleAntiCSRFTokens() {
        if (this.chkHandleAntiCrsfTokens == null) {
            this.chkHandleAntiCrsfTokens = new JCheckBox();
            this.chkHandleAntiCrsfTokens.setText(Constant.messages.getString("ascan.options.anticsrf.label"));
        }
        return this.chkHandleAntiCrsfTokens;
    }

    private JCheckBox getChkPromptInAttackMode() {
        if (this.chkPromptInAttackMode == null) {
            this.chkPromptInAttackMode = new JCheckBox(Constant.messages.getString("ascan.options.attackPrompt.label"));
            this.chkPromptInAttackMode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsScannerPanel.this.getChkRescanInAttackMode().setEnabled(!OptionsScannerPanel.this.chkPromptInAttackMode.isSelected());
                }
            });
        }
        return this.chkPromptInAttackMode;
    }

    private JCheckBox getChkRescanInAttackMode() {
        if (this.chkRescanInAttackMode == null) {
            this.chkRescanInAttackMode = new JCheckBox(Constant.messages.getString("ascan.options.attackRescan.label"));
        }
        return this.chkRescanInAttackMode;
    }

    private JCheckBox getAllowAttackModeOnStart() {
        if (this.allowAttackModeOnStart == null) {
            this.allowAttackModeOnStart = new JCheckBox(Constant.messages.getString("ascan.options.attackOnStart.label"));
        }
        return this.allowAttackModeOnStart;
    }
}

