/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptContext;

public final class ScriptVars {
    static final int MAX_KEY_SIZE = 30;
    static final int MAX_VALUE_SIZE = 0x100000;
    static final int MAX_SCRIPT_VARS = 20;
    static final int MAX_GLOBAL_VARS = 50;
    private static Map<String, String> globalVars = Collections.synchronizedMap(new HashMap());
    private static Map<String, Map<String, String>> scriptVars = Collections.synchronizedMap(new HashMap());

    private ScriptVars() {
    }

    public static void setGlobalVar(String key, String value) {
        ScriptVars.validateKey(key);
        if (value == null) {
            globalVars.remove(key);
        } else {
            ScriptVars.validateValueLength(value);
            if (globalVars.size() > 50) {
                throw new IllegalArgumentException("Maximum number of global variables reached: 50");
            }
            globalVars.put(key, value);
        }
    }

    private static void validateKey(String key) {
        if (key == null || key.length() > 30) {
            throw new IllegalArgumentException("Invalid key - must be non null and have a length less than 30");
        }
    }

    private static void validateValueLength(String value) {
        if (value.length() > 0x100000) {
            throw new IllegalArgumentException("Invalid value - must have a length less than 1048576");
        }
    }

    public static String getGlobalVar(String key) {
        return globalVars.get(key);
    }

    public static Map<String, String> getGlobalVars() {
        return Collections.unmodifiableMap(globalVars);
    }

    public static void setScriptVar(ScriptContext context, String key, String value) {
        ScriptVars.setScriptVarImpl(ScriptVars.getScriptName(context), key, value);
    }

    private static String getScriptName(ScriptContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Invalid context - must be non null");
        }
        Object scriptName = context.getAttribute("zap.script.name");
        if (scriptName == null) {
            throw new IllegalArgumentException("Failed to find script name in the script context.");
        }
        if (!(scriptName instanceof String)) {
            throw new IllegalArgumentException("The script name is not a String: " + scriptName.getClass().getCanonicalName());
        }
        return (String)scriptName;
    }

    public static void setScriptVar(String scriptName, String key, String value) {
        ScriptVars.validateScriptName(scriptName);
        ScriptVars.setScriptVarImpl(scriptName, key, value);
    }

    private static void setScriptVarImpl(String scriptName, String key, String value) {
        ScriptVars.validateKey(key);
        Map scVars = scriptVars.computeIfAbsent(scriptName, k -> Collections.synchronizedMap(new HashMap()));
        if (value == null) {
            scVars.remove(key);
        } else {
            ScriptVars.validateValueLength(value);
            if (scVars.size() > 20) {
                throw new IllegalArgumentException("Maximum number of script variables reached: 20");
            }
            scVars.put(key, value);
        }
    }

    private static void validateScriptName(String scriptName) {
        if (scriptName == null) {
            throw new IllegalArgumentException("The script name must not be null.");
        }
    }

    public static String getScriptVar(ScriptContext context, String key) {
        return ScriptVars.getScriptVarImpl(ScriptVars.getScriptName(context), key);
    }

    public static String getScriptVar(String scriptName, String key) {
        ScriptVars.validateScriptName(scriptName);
        return ScriptVars.getScriptVarImpl(scriptName, key);
    }

    private static String getScriptVarImpl(String scriptName, String key) {
        Map<String, String> scVars = scriptVars.get(scriptName);
        if (scVars == null) {
            return null;
        }
        return scVars.get(key);
    }

    public static Map<String, String> getScriptVars(String scriptName) {
        return Collections.unmodifiableMap(scriptVars.getOrDefault(scriptName, Collections.emptyMap()));
    }

    public static void clearGlobalVars() {
        globalVars.clear();
    }

    public static void clearScriptVars(String scriptName) {
        scriptVars.remove(scriptName);
    }

    public static void clear() {
        ScriptVars.clearGlobalVars();
        scriptVars.clear();
    }
}

